/*
 * Decompiled with CFR 0.152.
 */
package me.auxjackdev.greencuts;

import java.nio.file.Path;
import me.auxjackdev.greencuts.Constants;
import me.auxjackdev.greencuts.config.GreenCutsConfig;
import org.spongepowered.configurate.CommentedConfigurationNode;
import org.spongepowered.configurate.ConfigurateException;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.hocon.HoconConfigurationLoader;

public class GreenCutsCommon {
    private static final HoconConfigurationLoader configLoader = ((HoconConfigurationLoader.Builder)HoconConfigurationLoader.builder().path(Path.of("./config/greencuts.conf", new String[0]))).prettyPrinting(true).build();
    private static GreenCutsConfig _config = null;

    public static void init() {
        GreenCutsConfig tmp = GreenCutsCommon.getConfig();
        GreenCutsCommon.saveConfig();
        Constants.LOG.debug("[GreenCuts] Init!");
    }

    public static GreenCutsConfig getConfig() {
        if (_config != null) {
            return _config;
        }
        try {
            CommentedConfigurationNode rootNode = (CommentedConfigurationNode)configLoader.load();
            _config = (GreenCutsConfig)rootNode.get(GreenCutsConfig.class);
        }
        catch (ConfigurateException e) {
            Constants.LOG.error("[ERROR] Failed to load greencuts config file.");
        }
        return _config;
    }

    public static void saveConfig() {
        CommentedConfigurationNode rootNode = CommentedConfigurationNode.root();
        try {
            rootNode.set(GreenCutsConfig.class, (Object)_config);
            configLoader.save((ConfigurationNode)rootNode);
        }
        catch (ConfigurateException ex) {
            Constants.LOG.error("[ERROR] Failed to save greencuts config.");
        }
    }
}

