/*
 * Decompiled with CFR 0.152.
 */
package me.auxjackdev.greencuts.mixin;

import me.auxjackdev.greencuts.GreenCutsCommon;
import me.auxjackdev.greencuts.util.GreenCutsUtils;
import me.auxjackdev.greencuts.util.IAutoPlantable;
import me.auxjackdev.greencuts.util.IPlantableBush;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ItemEntity.class})
public abstract class MixinItemStack
extends Entity
implements IAutoPlantable {
    private boolean plantingFailed = false;
    private int plantingTicks = 0;
    @Shadow
    private int age;

    public MixinItemStack(EntityType<?> entityType, Level level) {
        super(entityType, level);
    }

    @Shadow
    public abstract ItemStack getItem();

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    void greenCuts$itemStackTick(CallbackInfo ci) {
        if (!GreenCutsCommon.getConfig().enabled) {
            return;
        }
        if (this.level().isClientSide) {
            return;
        }
        if (this.getPlantingFailed()) {
            return;
        }
        if (!GreenCutsUtils.isSaplingStack(this.getItem())) {
            return;
        }
        Block block = Block.byItem((Item)this.getItem().getItem());
        if (!(block instanceof IPlantableBush)) {
            return;
        }
        IPlantableBush plantableBush = (IPlantableBush)block;
        ++this.plantingTicks;
        if (this.plantingTicks < GreenCutsCommon.getConfig().autoPlantDelay) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)this.level();
        BlockState state = Block.byItem((Item)this.getItem().getItem()).defaultBlockState();
        BlockPos plantPos = this.getOnPos().above();
        this.plantingTicks = 0;
        if (!plantableBush.canSurviveAtPos(state, serverLevel, plantPos)) {
            if (!this.plantingFailed) {
                this.greenCuts$randomNudge();
            }
            return;
        }
        if (GreenCutsUtils.runPlantingChance(serverLevel)) {
            if (this.getItem().getCount() > 0) {
                serverLevel.setBlockAndUpdate(plantPos, state);
                this.greenCuts$randomNudge();
            }
            if (this.getItem().getCount() > 1) {
                this.getItem().setCount(this.getItem().getCount() - 1);
            } else {
                this.getItem().setCount(0);
                this.discard();
            }
            return;
        }
        if (!GreenCutsUtils.runPlantingChance(serverLevel)) {
            this.setPlantingFailed(true);
        }
    }

    @Unique
    void greenCuts$randomNudge() {
        double moveMultiplierX = this.level().random.nextIntBetweenInclusive(2, 6);
        double moveMultiplierZ = this.level().random.nextIntBetweenInclusive(2, 6);
        if (this.level().random.nextBoolean()) {
            moveMultiplierX *= -1.0;
        }
        if (this.level().random.nextBoolean()) {
            moveMultiplierZ *= -1.0;
        }
        this.setDeltaMovement(1.0 / moveMultiplierX, 1.0, 1.0 / moveMultiplierZ);
    }

    @Inject(method={"addAdditionalSaveData"}, at={@At(value="HEAD")})
    void greenCuts$itemStackWriteData(CompoundTag tag, CallbackInfo ci) {
        CompoundTag greencutsRootTag = new CompoundTag();
        greencutsRootTag.putBoolean("planting_failed", this.plantingFailed);
        greencutsRootTag.putInt("planting_ticks", this.plantingTicks);
        tag.put("greencuts", (Tag)greencutsRootTag);
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="HEAD")})
    void greenCuts$itemStackReadData(CompoundTag tag, CallbackInfo ci) {
        CompoundTag greencutsRootTag = tag.getCompound("greencuts");
        this.plantingFailed = greencutsRootTag.getBoolean("planting_failed");
        this.plantingTicks = greencutsRootTag.getInt("planting_ticks");
    }

    @Override
    public boolean getPlantingFailed() {
        return this.plantingFailed;
    }

    @Override
    public void setPlantingFailed(boolean value) {
        this.plantingFailed = value;
    }
}

