/*
 * Decompiled with CFR 0.152.
 */
package com.simplemotd.plugin.commands;

import com.simplemotd.plugin.SimpleMOTD;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabExecutor;
import org.bukkit.entity.Player;

public class MOTDCommand
implements TabExecutor {
    private final SimpleMOTD plugin;

    public MOTDCommand(SimpleMOTD plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        String subCommand;
        if (args.length == 0) {
            this.sendHelp(sender);
            return true;
        }
        switch (subCommand = args[0].toLowerCase()) {
            case "set": {
                this.handleSet(sender, args);
                break;
            }
            case "add": {
                this.handleAdd(sender, args);
                break;
            }
            case "remove": {
                this.handleRemove(sender, args);
                break;
            }
            case "clear": {
                this.handleClear(sender);
                break;
            }
            case "preview": {
                this.handlePreview(sender);
                break;
            }
            case "reload": {
                this.handleReload(sender);
                break;
            }
            default: {
                this.sendHelp(sender);
            }
        }
        return true;
    }

    private void handleSet(CommandSender sender, String[] args) {
        if (!sender.hasPermission("simplemotd.edit")) {
            this.plugin.getMessageManager().sendMessage(sender, "no-permission", new String[0]);
            return;
        }
        if (args.length < 3) {
            this.plugin.getMessageManager().sendMessage(sender, "usage-set", new String[0]);
            return;
        }
        try {
            int line = Integer.parseInt(args[1]) - 1;
            String text = String.join((CharSequence)" ", Arrays.copyOfRange(args, 2, args.length));
            this.plugin.getMOTDManager().setLine(line, text);
            this.plugin.getMessageManager().sendMessage(sender, "motd-set", new String[0]);
        }
        catch (NumberFormatException e) {
            this.plugin.getMessageManager().sendMessage(sender, "invalid-line", new String[0]);
        }
        catch (IndexOutOfBoundsException e) {
            this.plugin.getMessageManager().sendMessage(sender, "invalid-line", new String[0]);
        }
    }

    private void handleAdd(CommandSender sender, String[] args) {
        if (!sender.hasPermission("simplemotd.edit")) {
            this.plugin.getMessageManager().sendMessage(sender, "no-permission", new String[0]);
            return;
        }
        if (args.length < 2) {
            this.plugin.getMessageManager().sendMessage(sender, "usage-add", new String[0]);
            return;
        }
        try {
            String text = String.join((CharSequence)" ", Arrays.copyOfRange(args, 1, args.length));
            this.plugin.getMOTDManager().addLine(text);
            this.plugin.getMessageManager().sendMessage(sender, "line-added", new String[0]);
        }
        catch (IllegalStateException e) {
            this.plugin.getMessageManager().sendMessage(sender, "max-lines-reached", new String[0]);
        }
    }

    private void handleRemove(CommandSender sender, String[] args) {
        if (!sender.hasPermission("simplemotd.edit")) {
            this.plugin.getMessageManager().sendMessage(sender, "no-permission", new String[0]);
            return;
        }
        if (args.length < 2) {
            this.plugin.getMessageManager().sendMessage(sender, "usage-remove", new String[0]);
            return;
        }
        try {
            int line = Integer.parseInt(args[1]) - 1;
            this.plugin.getMOTDManager().removeLine(line);
            this.plugin.getMessageManager().sendMessage(sender, "line-removed", new String[0]);
        }
        catch (NumberFormatException e) {
            this.plugin.getMessageManager().sendMessage(sender, "invalid-line", new String[0]);
        }
        catch (IndexOutOfBoundsException e) {
            this.plugin.getMessageManager().sendMessage(sender, "invalid-line", new String[0]);
        }
    }

    private void handleClear(CommandSender sender) {
        if (!sender.hasPermission("simplemotd.edit")) {
            this.plugin.getMessageManager().sendMessage(sender, "no-permission", new String[0]);
            return;
        }
        this.plugin.getMOTDManager().clear();
        this.plugin.getMessageManager().sendMessage(sender, "motd-cleared", new String[0]);
    }

    private void handlePreview(CommandSender sender) {
        this.plugin.getMessageManager().sendMessage(sender, "preview-header", new String[0]);
        String motd = this.plugin.getMOTDManager().getFormattedMOTD(sender instanceof Player ? (Player)sender : null);
        String[] lines = motd.split("\n");
        for (int i = 0; i < lines.length; ++i) {
            sender.sendMessage("\u00a77" + (i + 1) + ": " + lines[i]);
        }
        this.plugin.getMessageManager().sendMessage(sender, "preview-footer", new String[0]);
    }

    private void handleReload(CommandSender sender) {
        if (!sender.hasPermission("simplemotd.reload")) {
            this.plugin.getMessageManager().sendMessage(sender, "no-permission", new String[0]);
            return;
        }
        this.plugin.reloadConfig();
        this.plugin.getMOTDManager().loadMOTD();
        this.plugin.getMessageManager().loadMessages();
        this.plugin.getMessageManager().sendMessage(sender, "reloaded", new String[0]);
    }

    private void sendHelp(CommandSender sender) {
        this.plugin.getMessageManager().sendMessage(sender, "help-header", new String[0]);
        this.plugin.getMessageManager().sendMessage(sender, "help-set", new String[0]);
        this.plugin.getMessageManager().sendMessage(sender, "help-add", new String[0]);
        this.plugin.getMessageManager().sendMessage(sender, "help-remove", new String[0]);
        this.plugin.getMessageManager().sendMessage(sender, "help-clear", new String[0]);
        this.plugin.getMessageManager().sendMessage(sender, "help-preview", new String[0]);
        this.plugin.getMessageManager().sendMessage(sender, "help-reload", new String[0]);
        this.plugin.getMessageManager().sendMessage(sender, "help-footer", new String[0]);
    }

    public List<String> onTabComplete(CommandSender sender, Command cmd, String label, String[] args) {
        ArrayList<String> completions = new ArrayList<String>();
        if (args.length == 1) {
            completions.addAll(Arrays.asList("set", "add", "remove", "clear", "preview", "reload", "help"));
        } else if (args.length == 2 && (args[0].equalsIgnoreCase("set") || args[0].equalsIgnoreCase("remove"))) {
            for (int i = 1; i <= this.plugin.getMOTDManager().getMOTDLines().size(); ++i) {
                completions.add(String.valueOf(i));
            }
        }
        return completions.stream().filter(s -> s.toLowerCase().startsWith(args[args.length - 1].toLowerCase())).collect(Collectors.toList());
    }
}

