/*
 * Decompiled with CFR 0.152.
 */
package com.simplemotd.plugin.manager;

import com.simplemotd.plugin.SimpleMOTD;
import com.simplemotd.plugin.storage.Storage;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;

public class MOTDManager {
    private final SimpleMOTD plugin;
    private final Storage storage;
    private List<String> motdLines;

    public MOTDManager(SimpleMOTD plugin, Storage storage) {
        this.plugin = plugin;
        this.storage = storage;
        this.motdLines = new ArrayList<String>();
        this.loadMOTD();
    }

    public void loadMOTD() {
        this.motdLines = this.storage.loadMOTD();
        this.plugin.getLogger().info("Loaded MOTD with " + this.motdLines.size() + " lines!");
    }

    public void saveMOTD() {
        this.storage.saveMOTD(this.motdLines);
    }

    public List<String> getMOTDLines() {
        return new ArrayList<String>(this.motdLines);
    }

    public String getMOTDString() {
        return String.join((CharSequence)"\n", this.motdLines);
    }

    public void setLine(int index, String text) {
        if (index < 0 || index >= this.motdLines.size()) {
            throw new IndexOutOfBoundsException("Invalid line number");
        }
        this.motdLines.set(index, this.processText(text));
        this.saveMOTD();
    }

    public void addLine(String text) {
        if (this.motdLines.size() >= this.plugin.getConfigManager().getMaxLines()) {
            throw new IllegalStateException("Maximum lines reached");
        }
        this.motdLines.add(this.processText(text));
        this.saveMOTD();
    }

    public void removeLine(int index) {
        if (index < 0 || index >= this.motdLines.size()) {
            throw new IndexOutOfBoundsException("Invalid line number");
        }
        this.motdLines.remove(index);
        this.saveMOTD();
    }

    public void clear() {
        this.motdLines.clear();
        this.saveMOTD();
    }

    public void setMOTD(List<String> lines) {
        this.motdLines = lines.stream().map(this::processText).collect(Collectors.toList());
        this.saveMOTD();
    }

    private String processText(String text) {
        if (this.plugin.getConfigManager().isCenterEnabled() && text.toUpperCase().contains("[CENTER]")) {
            text = text.replaceAll("(?i)\\[CENTER\\]", "").trim();
            return this.centerText(ChatColor.translateAlternateColorCodes((char)'&', (String)text));
        }
        return ChatColor.translateAlternateColorCodes((char)'&', (String)text);
    }

    private String centerText(String text) {
        int maxWidth = 60;
        int textWidth = ChatColor.stripColor((String)text).length();
        int spaces = Math.max(0, (maxWidth - textWidth) / 2);
        return " ".repeat(spaces) + text;
    }

    public String getFormattedMOTD(Player player) {
        String motd = this.getMOTDString();
        if (player != null) {
            motd = motd.replace("%player%", player.getName()).replace("%online%", String.valueOf(this.plugin.getServer().getOnlinePlayers().size())).replace("%max%", String.valueOf(this.plugin.getServer().getMaxPlayers()));
        }
        return motd;
    }
}

