/*
 * Decompiled with CFR 0.152.
 */
package com.simplemotd.plugin.manager;

import com.simplemotd.plugin.SimpleMOTD;
import java.io.File;
import java.io.IOException;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class MessageManager {
    private final SimpleMOTD plugin;
    private FileConfiguration messages;
    private final File messagesFile;

    public MessageManager(SimpleMOTD plugin) {
        this.plugin = plugin;
        this.messagesFile = new File(plugin.getDataFolder(), "messages.yml");
        this.loadMessages();
    }

    public void loadMessages() {
        if (!this.messagesFile.exists()) {
            this.plugin.saveResource("messages.yml", false);
        }
        this.messages = YamlConfiguration.loadConfiguration((File)this.messagesFile);
        this.addDefault("prefix", "&8[&bSimpleMOTD&8] &r");
        this.addDefault("no-permission", "&cYou don't have permission!");
        this.addDefault("motd-set", "&aMOTD has been updated!");
        this.addDefault("motd-cleared", "&aMOTD has been cleared!");
        this.addDefault("line-added", "&aAdded line to MOTD!");
        this.addDefault("line-removed", "&aRemoved line from MOTD!");
        this.addDefault("preview-header", "&8========== &bMOTD Preview &8==========");
        this.addDefault("preview-footer", "&8===============================");
        this.addDefault("max-lines-reached", "&cMaximum lines reached!");
        this.addDefault("invalid-line", "&cInvalid line number!");
        this.addDefault("usage-set", "&cUsage: /motd set <line> <text>");
        this.addDefault("usage-add", "&cUsage: /motd add <text>");
        this.addDefault("usage-remove", "&cUsage: /motd remove <line>");
        this.addDefault("help-header", "&8========== &bSimpleMOTD Help &8==========");
        this.addDefault("help-set", "&b/motd set <line> <text> &7- Set a line");
        this.addDefault("help-add", "&b/motd add <text> &7- Add a new line");
        this.addDefault("help-remove", "&b/motd remove <line> &7- Remove a line");
        this.addDefault("help-clear", "&b/motd clear &7- Clear all lines");
        this.addDefault("help-preview", "&b/motd preview &7- Preview MOTD");
        this.addDefault("help-reload", "&b/motd reload &7- Reload config");
        this.addDefault("help-footer", "&8=====================================");
        this.saveMessages();
    }

    private void addDefault(String key, String value) {
        if (!this.messages.contains(key)) {
            this.messages.set(key, (Object)value);
        }
    }

    private void saveMessages() {
        try {
            this.messages.save(this.messagesFile);
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Could not save messages.yml!");
            e.printStackTrace();
        }
    }

    public String getMessage(String key, String ... placeholders) {
        String message = this.messages.getString(key, "&cMessage not found: " + key);
        message = ChatColor.translateAlternateColorCodes((char)'&', (String)(this.messages.getString("prefix", "") + message));
        for (int i = 0; i < placeholders.length; i += 2) {
            if (i + 1 >= placeholders.length) continue;
            message = message.replace("%" + placeholders[i] + "%", placeholders[i + 1]);
        }
        return message;
    }

    public void sendMessage(CommandSender sender, String key, String ... placeholders) {
        sender.sendMessage(this.getMessage(key, placeholders));
    }
}

