/*
 * Decompiled with CFR 0.152.
 */
package com.simplemotd.plugin.storage;

import com.simplemotd.plugin.SimpleMOTD;
import com.simplemotd.plugin.storage.Storage;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class YamlStorage
implements Storage {
    private final SimpleMOTD plugin;
    private final File motdFile;
    private FileConfiguration motdConfig;

    public YamlStorage(SimpleMOTD plugin) {
        this.plugin = plugin;
        this.motdFile = new File(plugin.getDataFolder(), "motd.yml");
        this.load();
    }

    private void load() {
        if (!this.motdFile.exists()) {
            try {
                this.motdFile.getParentFile().mkdirs();
                this.motdFile.createNewFile();
            }
            catch (IOException e) {
                this.plugin.getLogger().severe("Could not create motd.yml!");
                e.printStackTrace();
            }
        }
        this.motdConfig = YamlConfiguration.loadConfiguration((File)this.motdFile);
    }

    @Override
    public void saveMOTD(List<String> lines) {
        this.motdConfig.set("motd.lines", lines);
        this.motdConfig.set("motd.version", (Object)this.plugin.getConfigManager().getMOTDVersion());
        this.saveFile();
    }

    @Override
    public List<String> loadMOTD() {
        return this.motdConfig.getStringList("motd.lines");
    }

    private void saveFile() {
        try {
            this.motdConfig.save(this.motdFile);
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Could not save motd.yml!");
            e.printStackTrace();
        }
    }
}

