/*
 * Decompiled with CFR 0.152.
 */
package de.myownbrain.autoLogout.client;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_3675;

@Environment(value=EnvType.CLIENT)
public class ConfigManager {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final File CONFIG_FILE = new File("config/auto_logout.json");
    public static boolean isModEnabled = true;
    public static float healthThreshold = 4.0f;
    public static String keyBinding = "key.keyboard.unknown";
    public static class_3675.class_306 currentKeyBinding = class_3675.method_15981((String)keyBinding);
    public static boolean isEntityTrackingEnabled = true;
    public static int nearbyEntityCount = 5;
    public static double radius = 20.0;
    public static boolean showJoinMessage = true;

    public static void loadConfig() {
        boolean updated = false;
        if (CONFIG_FILE.exists()) {
            try (FileReader reader = new FileReader(CONFIG_FILE);){
                ConfigData config = (ConfigData)GSON.fromJson((Reader)reader, ConfigData.class);
                if (config.isModEnabled != null) {
                    isModEnabled = config.isModEnabled;
                } else {
                    updated = true;
                }
                if (config.healthThreshold != null) {
                    healthThreshold = config.healthThreshold.floatValue();
                } else {
                    updated = true;
                }
                if (config.keyBinding != null && !config.keyBinding.isEmpty()) {
                    keyBinding = config.keyBinding;
                } else {
                    updated = true;
                }
                currentKeyBinding = class_3675.method_15981((String)keyBinding);
                if (config.isEntityTrackingEnabled != null) {
                    isEntityTrackingEnabled = config.isEntityTrackingEnabled;
                } else {
                    updated = true;
                }
                if (config.nearbyEntityCount != null) {
                    nearbyEntityCount = config.nearbyEntityCount;
                } else {
                    updated = true;
                }
                if (config.radius != null) {
                    radius = config.radius;
                } else {
                    updated = true;
                }
                if (config.showJoinMessage != null) {
                    showJoinMessage = config.showJoinMessage;
                } else {
                    updated = true;
                }
            }
            catch (IOException e) {
                System.err.println("Failed to load config: " + e.getMessage());
            }
        } else {
            updated = true;
        }
        if (updated) {
            ConfigManager.saveConfig();
        }
    }

    public static void saveConfig() {
        try {
            CONFIG_FILE.getParentFile().mkdirs();
            try (FileWriter writer = new FileWriter(CONFIG_FILE);){
                ConfigData config = new ConfigData(isModEnabled, Float.valueOf(healthThreshold), currentKeyBinding != null ? currentKeyBinding.method_1441() : "key.keyboard.unknown", isEntityTrackingEnabled, nearbyEntityCount, radius, showJoinMessage);
                GSON.toJson((Object)config, (Appendable)writer);
            }
        }
        catch (IOException e) {
            System.err.println("Failed to save config: " + e.getMessage());
        }
    }

    @Environment(value=EnvType.CLIENT)
    private static class ConfigData {
        Boolean isModEnabled;
        Float healthThreshold;
        String keyBinding;
        Boolean isEntityTrackingEnabled;
        Integer nearbyEntityCount;
        Double radius;
        Boolean showJoinMessage;

        public ConfigData(Boolean isModEnabled, Float healthThreshold, String keyBinding, Boolean isEntityTrackingEnabled, Integer nearbyEntityCount, Double radius, Boolean showJoinMessage) {
            this.isModEnabled = isModEnabled;
            this.healthThreshold = healthThreshold;
            this.keyBinding = keyBinding;
            this.isEntityTrackingEnabled = isEntityTrackingEnabled;
            this.nearbyEntityCount = nearbyEntityCount;
            this.radius = radius;
            this.showJoinMessage = showJoinMessage;
        }
    }
}

