/*
 * Decompiled with CFR 0.152.
 */
package de.myownbrain.autoLogout.client;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_3675;

@Environment(value=EnvType.CLIENT)
public class ConfigManager {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final File CONFIG_FILE = new File("config/auto_logout.json");
    public static boolean isModEnabled = true;
    public static float healthThreshold = 4.0f;
    public static String keyBinding = "key.keyboard.unknown";
    public static class_3675.class_306 currentKeyBinding = class_3675.method_15981((String)keyBinding);
    public static boolean isEntityTrackingEnabled = true;
    public static int nearbyEntityCount = 5;
    public static double radius = 20.0;

    public static void loadConfig() {
        if (CONFIG_FILE.exists()) {
            try (FileReader reader = new FileReader(CONFIG_FILE);){
                ConfigData config = (ConfigData)GSON.fromJson((Reader)reader, ConfigData.class);
                isModEnabled = config.isModEnabled;
                healthThreshold = config.healthThreshold;
                keyBinding = config.keyBinding != null && !config.keyBinding.isEmpty() ? config.keyBinding : "key.keyboard.unknown";
                currentKeyBinding = class_3675.method_15981((String)keyBinding);
                isEntityTrackingEnabled = config.isEntityTrackingEnabled;
                nearbyEntityCount = config.nearbyEntityCount;
                radius = config.radius;
            }
            catch (IOException e) {
                System.err.println("Failed to load config: " + e.getMessage());
            }
        } else {
            ConfigManager.saveConfig();
        }
    }

    public static void saveConfig() {
        try {
            CONFIG_FILE.getParentFile().mkdirs();
            try (FileWriter writer = new FileWriter(CONFIG_FILE);){
                ConfigData config = new ConfigData(isModEnabled, healthThreshold, currentKeyBinding != null ? currentKeyBinding.method_1441() : "key.keyboard.unknown", isEntityTrackingEnabled, nearbyEntityCount, radius);
                GSON.toJson((Object)config, (Appendable)writer);
            }
        }
        catch (IOException e) {
            System.err.println("Failed to save config: " + e.getMessage());
        }
    }

    @Environment(value=EnvType.CLIENT)
    private static class ConfigData {
        boolean isModEnabled;
        float healthThreshold;
        String keyBinding;
        boolean isEntityTrackingEnabled;
        int nearbyEntityCount;
        double radius;

        public ConfigData(boolean isModEnabled, float healthThreshold, String keyBinding, boolean isEntityTrackingEnabled, int nearbyEntityCount, double radius) {
            this.isModEnabled = isModEnabled;
            this.healthThreshold = healthThreshold;
            this.keyBinding = keyBinding;
            this.isEntityTrackingEnabled = isEntityTrackingEnabled;
            this.nearbyEntityCount = nearbyEntityCount;
            this.radius = radius;
        }
    }
}

