/*
 * Decompiled with CFR 0.152.
 */
package net.hour.eternity;

import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.entity.event.v1.ServerPlayerEvents;
import net.fabricmc.fabric.api.object.builder.v1.entity.FabricDefaultAttributeRegistry;
import net.fabricmc.fabric.api.registry.FlammableBlockRegistry;
import net.fabricmc.fabric.api.registry.StrippableBlockRegistry;
import net.hour.eternity.block.ModBlocks;
import net.hour.eternity.entity.ModEntities;
import net.hour.eternity.entity.custom.ForgottenEntity;
import net.hour.eternity.entity.custom.LilGuyEntity;
import net.hour.eternity.entity.custom.MenaceEntity;
import net.hour.eternity.item.ModItemGroup;
import net.hour.eternity.item.ModItems;
import net.hour.eternity.shader.GrayscaleProcessor;
import net.hour.eternity.util.TarrHostUtil;
import net.hour.eternity.util.inv.InventorySwapHandler;
import net.hour.eternity.util.inv.RespawnCopyHandler;
import net.hour.eternity.util.packets.ModClientPackets;
import net.hour.eternity.util.packets.ModPackets;
import net.hour.eternity.world.dimension.ModDimensions;
import net.hour.eternity.world.gen.ModWorldGeneration;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_5132;
import net.minecraft.class_5321;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Eternity
implements ModInitializer {
    public static final String MOD_ID = "eternity";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"eternity");
    public static final class_2960 ORBITAL_VFX = new class_2960("eternity", "orbital_strike_vfx");
    public static final class_2960 ORBITAL_IMPACT = new class_2960("eternity", "orbital_strike_impact");

    public void onInitialize() {
        ModBlocks.registerModBlocks();
        ModItems.registerModItems();
        ModItemGroup.registerItemGroup();
        ModWorldGeneration.generateModWorldGen();
        ModDimensions.register();
        ModEntities.registerModEntities();
        TarrHostUtil.register();
        ModPackets.registerPackets();
        ModClientPackets.registerClientPackets();
        InventorySwapHandler.register();
        RespawnCopyHandler.register();
        StrippableBlockRegistry.register((class_2248)ModBlocks.EVERGLOOM_LOG, (class_2248)ModBlocks.STRIPPED_EVERGLOOM_LOG);
        StrippableBlockRegistry.register((class_2248)ModBlocks.EVERGLOOM_WOOD, (class_2248)ModBlocks.STRIPPED_EVERGLOOM_WOOD);
        FlammableBlockRegistry.getDefaultInstance().add(ModBlocks.EVERGLOOM_LOG, 5, 5);
        FlammableBlockRegistry.getDefaultInstance().add(ModBlocks.STRIPPED_EVERGLOOM_LOG, 5, 5);
        FlammableBlockRegistry.getDefaultInstance().add(ModBlocks.STRIPPED_EVERGLOOM_WOOD, 5, 5);
        FlammableBlockRegistry.getDefaultInstance().add(ModBlocks.EVERGLOOM_WOOD, 5, 5);
        FlammableBlockRegistry.getDefaultInstance().add(ModBlocks.EVERGLOOM_PLANKS, 5, 20);
        FlammableBlockRegistry.getDefaultInstance().add(ModBlocks.EVERGLOOM_LEAVES, 30, 60);
        FabricDefaultAttributeRegistry.register(ModEntities.THE_FORGOTTEN, (class_5132.class_5133)ForgottenEntity.createTheForgottenAttributes());
        FabricDefaultAttributeRegistry.register(ModEntities.LILGUY, (class_5132.class_5133)LilGuyEntity.createLilGuyAttributes());
        FabricDefaultAttributeRegistry.register(ModEntities.MENACE, (class_5132.class_5133)MenaceEntity.createTheMenaceAttributes());
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            if (client.field_1687 == null) {
                GrayscaleProcessor.INSTANCE.setActive(false);
                return;
            }
            class_5321 current = client.field_1687.method_27983();
            if (current == ModDimensions.LIMBO_DIM_KEY) {
                GrayscaleProcessor.INSTANCE.setActive(true);
            } else {
                GrayscaleProcessor.INSTANCE.setActive(false);
            }
        });
        ServerPlayerEvents.AFTER_RESPAWN.register((oldPlayer, newPlayer, alive) -> {
            class_3218 customWorld;
            if (!alive && oldPlayer.method_37908().method_27983().equals(ModDimensions.LIMBO_DIM_KEY) && (customWorld = oldPlayer.method_5682().method_3847(ModDimensions.LIMBO_DIM_KEY)) != null) {
                class_2338 spawn = customWorld.method_43126();
                newPlayer.method_14251(customWorld, (double)spawn.method_10263() + 0.5, (double)spawn.method_10264(), (double)spawn.method_10260() + 0.5, newPlayer.method_36454(), newPlayer.method_36455());
            }
        });
    }
}

