/*
 * Decompiled with CFR 0.152.
 */
package net.hour.eternity.util.packets;

import io.github.fabricators_of_create.porting_lib.util.RegistryObject;
import java.awt.Color;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_243;
import net.minecraft.class_2540;
import net.minecraft.class_310;
import net.minecraft.class_638;
import team.lodestar.lodestone.registry.common.particle.LodestoneParticleRegistry;
import team.lodestar.lodestone.systems.easing.Easing;
import team.lodestar.lodestone.systems.particle.builder.WorldParticleBuilder;
import team.lodestar.lodestone.systems.particle.data.GenericParticleData;
import team.lodestar.lodestone.systems.particle.data.color.ColorParticleData;

public class BeamSpawnPacket {
    private final class_243 position;
    private final int startingColor;
    private final int endingColor;

    public BeamSpawnPacket(class_243 position, int startingColor, int endingColor) {
        this.position = position;
        this.startingColor = startingColor;
        this.endingColor = endingColor;
    }

    public BeamSpawnPacket(class_2540 buf) {
        this.position = new class_243(buf.readDouble(), buf.readDouble(), buf.readDouble());
        this.startingColor = buf.readInt();
        this.endingColor = buf.readInt();
    }

    public void toBytes(class_2540 buf) {
        buf.writeDouble(this.position.field_1352);
        buf.writeDouble(this.position.field_1351);
        buf.writeDouble(this.position.field_1350);
        buf.writeInt(this.startingColor);
        buf.writeInt(this.endingColor);
    }

    public void handle(class_310 client) {
        client.execute(() -> {
            class_638 level = client.field_1687;
            if (level != null) {
                Color startColor = new Color(this.startingColor);
                Color endColor = new Color(this.endingColor);
                BeamSpawnPacket.spawnBeamParticles((class_1937)level, this.position, startColor, endColor);
            }
        });
    }

    public static void spawnBeamParticles(class_1937 level, class_243 pos, Color startingColor, Color endingColor) {
        WorldParticleBuilder.create((RegistryObject)LodestoneParticleRegistry.WISP_PARTICLE).setScaleData(GenericParticleData.create((float)1.0f, (float)0.5f, (float)0.0f).build()).setTransparencyData(GenericParticleData.create((float)1.0f, (float)0.0f).build()).setColorData(ColorParticleData.create((Color)startingColor, (Color)endingColor).setCoefficient(3.5f).setEasing(Easing.BOUNCE_IN_OUT).build()).setScaleData(GenericParticleData.create((float)5.0f, (float)5.0f).build()).setLifetime(210).repeatRandomFace(level, class_2338.method_49638((class_2374)pos), 50).enableNoClip().spawn(level, pos.field_1352, pos.field_1351, pos.field_1350);
    }
}

