/*
 * Decompiled with CFR 0.152.
 */
package net.hour.eternity.util.packets;

import io.github.fabricators_of_create.porting_lib.util.RegistryObject;
import java.awt.Color;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2540;
import net.minecraft.class_310;
import net.minecraft.class_638;
import team.lodestar.lodestone.registry.common.particle.LodestoneParticleRegistry;
import team.lodestar.lodestone.systems.easing.Easing;
import team.lodestar.lodestone.systems.particle.builder.WorldParticleBuilder;
import team.lodestar.lodestone.systems.particle.data.GenericParticleData;
import team.lodestar.lodestone.systems.particle.data.color.ColorParticleData;

public class SmokeSpawnPacket {
    private final class_243 position;
    private final int startingSmokeColor;
    private final int endingSmokeColor;

    public SmokeSpawnPacket(class_243 position, int startingSmokeColor, int endingSmokeColor) {
        this.position = position;
        this.startingSmokeColor = startingSmokeColor;
        this.endingSmokeColor = endingSmokeColor;
    }

    public SmokeSpawnPacket(class_2540 buf) {
        this.position = new class_243(buf.readDouble(), buf.readDouble(), buf.readDouble());
        this.startingSmokeColor = buf.readInt();
        this.endingSmokeColor = buf.readInt();
    }

    public void toBytes(class_2540 buf) {
        buf.writeDouble(this.position.field_1352);
        buf.writeDouble(this.position.field_1351);
        buf.writeDouble(this.position.field_1350);
        buf.writeInt(this.startingSmokeColor);
        buf.writeInt(this.endingSmokeColor);
    }

    public void handle(class_310 client) {
        client.execute(() -> {
            class_638 level = client.field_1687;
            if (level != null) {
                Color starSmokeColor = new Color(this.startingSmokeColor);
                Color endSmokeColor = new Color(this.endingSmokeColor);
                SmokeSpawnPacket.spawnSmokeParticles((class_1937)level, this.position, starSmokeColor, endSmokeColor);
            }
        });
    }

    public static void spawnSmokeParticles(class_1937 level, class_243 pos, Color startingSmokeColor, Color endingSmokeColor) {
        WorldParticleBuilder.create((RegistryObject)LodestoneParticleRegistry.SMOKE_PARTICLE).setScaleData(GenericParticleData.create((float)1.5f, (float)5.5f, (float)0.0f).build()).setTransparencyData(GenericParticleData.create((float)0.9f, (float)0.0f).build()).setColorData(ColorParticleData.create((Color)startingSmokeColor, (Color)endingSmokeColor).setCoefficient(0.5f).setEasing((Easing)Easing.ELASTIC_IN).build()).setScaleData(GenericParticleData.create((float)4.0f, (float)4.0f).build()).setLifetime(200).setLifeDelay(40).enableNoClip().spawn(level, pos.field_1352, pos.field_1351, pos.field_1350);
    }
}

