/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.cookingforblockheads.block.BaseKitchenBlock;
import net.blay09.mods.cookingforblockheads.block.ModBlocks;
import net.blay09.mods.cookingforblockheads.block.entity.FridgeBlockEntity;
import net.blay09.mods.cookingforblockheads.block.entity.ModBlockEntities;
import net.blay09.mods.cookingforblockheads.item.ModItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class FridgeBlock
extends BaseKitchenBlock {
    public static final MapCodec<FridgeBlock> CODEC = RecordCodecBuilder.mapCodec(it -> it.group((App)DyeColor.CODEC.fieldOf("color").forGetter(FridgeBlock::getColor), (App)FridgeBlock.propertiesCodec()).apply((Applicative)it, FridgeBlock::new));
    public static final EnumProperty<FridgeModelType> MODEL_TYPE = EnumProperty.create((String)"model", FridgeModelType.class);
    public static final BooleanProperty PRESERVATION_CHAMBER = BooleanProperty.create((String)"preservation_chamber");
    public static final BooleanProperty ICE_UNIT = BooleanProperty.create((String)"ice_unit");
    private static final VoxelShape BOUNDING_BOX_X = Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0);
    private static final VoxelShape BOUNDING_BOX_Z = Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0);
    private final DyeColor color;

    public FridgeBlock(DyeColor color, BlockBehaviour.Properties properties) {
        super(properties.pushReaction(PushReaction.BLOCK).sound(SoundType.METAL).strength(5.0f, 10.0f));
        this.color = color;
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)PRESERVATION_CHAMBER, (Comparable)Boolean.valueOf(false))).setValue((Property)ICE_UNIT, (Comparable)Boolean.valueOf(false)));
    }

    public DyeColor getColor() {
        return this.color;
    }

    @Override
    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        if (((Direction)state.getValue((Property)FACING)).getAxis() == Direction.Axis.X) {
            return BOUNDING_BOX_X;
        }
        return BOUNDING_BOX_Z;
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, MODEL_TYPE, FLIPPED, PRESERVATION_CHAMBER, ICE_UNIT});
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new FridgeBlockEntity(pos, state);
    }

    protected InteractionResult useItemOn(ItemStack itemStack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult blockHitResult) {
        if (itemStack.isEmpty()) {
            return InteractionResult.TRY_WITH_EMPTY_HAND;
        }
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (!(blockEntity instanceof FridgeBlockEntity)) {
            return InteractionResult.FAIL;
        }
        FridgeBlockEntity fridge = (FridgeBlockEntity)blockEntity;
        if (itemStack.getItem() == ModItems.preservationChamber || itemStack.getItem() == ModItems.iceUnit) {
            return InteractionResult.PASS;
        }
        if (this.tryRecolorBlock(state, itemStack, level, pos, player, blockHitResult)) {
            return InteractionResult.SUCCESS;
        }
        Direction frontFace = (Direction)state.getValue((Property)FACING);
        if (blockHitResult.getDirection() == frontFace && fridge.getBaseFridge().getDoorAnimator().isForcedOpen()) {
            itemStack = fridge.insertItemStacked(itemStack, false);
            player.setItemInHand(hand, itemStack);
            return InteractionResult.SUCCESS;
        }
        if (Block.byItem((Item)itemStack.getItem()) instanceof FridgeBlock && blockHitResult.getDirection() != frontFace) {
            return InteractionResult.FAIL;
        }
        return super.useItemOn(itemStack, state, level, pos, player, hand, blockHitResult);
    }

    public InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult blockHitResult) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (!(blockEntity instanceof FridgeBlockEntity)) {
            return InteractionResult.FAIL;
        }
        FridgeBlockEntity fridge = (FridgeBlockEntity)blockEntity;
        Direction frontFace = (Direction)state.getValue((Property)FACING);
        if (blockHitResult.getDirection() == frontFace && player.isShiftKeyDown()) {
            fridge.getBaseFridge().getDoorAnimator().toggleForcedOpen();
            return InteractionResult.SUCCESS;
        }
        if (!level.isClientSide()) {
            Balm.getNetworking().openMenu(player, (MenuProvider)fridge);
        }
        return InteractionResult.SUCCESS;
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        boolean below = level.getBlockState(pos.below()).getBlock() == this;
        boolean above = level.getBlockState(pos.above()).getBlock() == this;
        return !(below && above || below && level.getBlockState(pos.below(2)).getBlock() == this || above && level.getBlockState(pos.above(2)).getBlock() == this || !super.canSurvive(state, level, pos));
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState state = super.getStateForPlacement(context);
        Level level = context.getLevel();
        BlockPos pos = context.getClickedPos();
        BlockPos posBelow = pos.below();
        BlockState stateBelow = level.getBlockState(posBelow);
        BlockPos posAbove = pos.above();
        BlockState stateAbove = level.getBlockState(posAbove);
        if (stateBelow.getBlock() == this && stateBelow.getValue(MODEL_TYPE) == FridgeModelType.SMALL) {
            state = (BlockState)state.setValue(MODEL_TYPE, (Comparable)((Object)FridgeModelType.LARGE_UPPER));
        } else if (stateAbove.getBlock() == this && stateAbove.getValue(MODEL_TYPE) == FridgeModelType.SMALL) {
            state = (BlockState)state.setValue(MODEL_TYPE, (Comparable)((Object)FridgeModelType.LARGE_LOWER));
        }
        return (BlockState)state.setValue((Property)FLIPPED, (Comparable)Boolean.valueOf(this.shouldBePlacedFlipped(context, (Direction)state.getValue((Property)FACING))));
    }

    protected BlockState updateShape(BlockState state, LevelReader level, ScheduledTickAccess scheduledTickAccess, BlockPos pos, Direction facing, BlockPos facingPos, BlockState facingState, RandomSource randomSource) {
        BlockPos posBelow = pos.below();
        BlockState stateBelow = level.getBlockState(posBelow);
        BlockPos posAbove = pos.above();
        BlockState stateAbove = level.getBlockState(posAbove);
        if (stateBelow.getBlock() == this && stateBelow.getValue(MODEL_TYPE) == FridgeModelType.LARGE_LOWER) {
            return (BlockState)((BlockState)state.setValue(MODEL_TYPE, (Comparable)((Object)FridgeModelType.LARGE_UPPER))).setValue((Property)FACING, (Comparable)((Direction)stateBelow.getValue((Property)FACING)));
        }
        if (stateAbove.getBlock() == this && stateAbove.getValue(MODEL_TYPE) == FridgeModelType.LARGE_UPPER) {
            return (BlockState)state.setValue(MODEL_TYPE, (Comparable)((Object)FridgeModelType.LARGE_LOWER));
        }
        if (state.getValue(MODEL_TYPE) == FridgeModelType.LARGE_LOWER && stateAbove.getBlock() != this) {
            return (BlockState)state.setValue(MODEL_TYPE, (Comparable)((Object)FridgeModelType.SMALL));
        }
        if (state.getValue(MODEL_TYPE) == FridgeModelType.LARGE_UPPER && stateBelow.getBlock() != this) {
            return (BlockState)state.setValue(MODEL_TYPE, (Comparable)((Object)FridgeModelType.SMALL));
        }
        return super.updateShape(state, level, scheduledTickAccess, pos, facing, facingPos, facingState, randomSource);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return level.isClientSide() ? FridgeBlock.createTickerHelper(type, (BlockEntityType)((BlockEntityType)ModBlockEntities.fridge.get()), FridgeBlockEntity::clientTick) : FridgeBlock.createTickerHelper(type, (BlockEntityType)((BlockEntityType)ModBlockEntities.fridge.get()), FridgeBlockEntity::serverTick);
    }

    @Override
    protected boolean recolorBlock(BlockState state, LevelAccessor world, BlockPos pos, Direction facing, DyeColor color) {
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity instanceof FridgeBlockEntity) {
            FridgeBlockEntity fridge = (FridgeBlockEntity)blockEntity;
            BlockPos bottomPos = fridge.getBaseFridge().getBlockPos();
            BlockPos topPos = bottomPos.above();
            return super.recolorBlock(world.getBlockState(bottomPos), world, bottomPos, facing, color) && super.recolorBlock(world.getBlockState(topPos), world, topPos, facing, color);
        }
        return false;
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    @Override
    protected BlockState getDyedStateOf(BlockState state, @Nullable DyeColor color) {
        FridgeBlock block = color == null ? ModBlocks.fridges[0] : ModBlocks.fridges[color.ordinal()];
        return (BlockState)((BlockState)((BlockState)((BlockState)block.defaultBlockState().setValue((Property)FACING, (Comparable)((Direction)state.getValue((Property)FACING)))).setValue(MODEL_TYPE, (Comparable)((Object)((FridgeModelType)((Object)state.getValue(MODEL_TYPE)))))).setValue((Property)PRESERVATION_CHAMBER, (Comparable)((Boolean)state.getValue((Property)PRESERVATION_CHAMBER)))).setValue((Property)ICE_UNIT, (Comparable)((Boolean)state.getValue((Property)ICE_UNIT)));
    }

    public static enum FridgeModelType implements StringRepresentable
    {
        SMALL,
        LARGE_LOWER,
        LARGE_UPPER;


        public String getSerializedName() {
            return this.name().toLowerCase();
        }
    }
}

