/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.block.entity;

import net.blay09.mods.balm.api.block.entity.CustomRenderBoundingBox;
import net.blay09.mods.balm.api.container.BalmContainerProvider;
import net.blay09.mods.balm.api.container.DefaultContainer;
import net.blay09.mods.balm.api.menu.BalmMenuProvider;
import net.blay09.mods.balm.common.BalmBlockEntity;
import net.blay09.mods.cookingforblockheads.CookingForBlockheadsConfig;
import net.blay09.mods.cookingforblockheads.api.KitchenItemProvider;
import net.blay09.mods.cookingforblockheads.api.UpgradeablePreservation;
import net.blay09.mods.cookingforblockheads.block.CounterBlock;
import net.blay09.mods.cookingforblockheads.block.entity.IMutableNameable;
import net.blay09.mods.cookingforblockheads.block.entity.ModBlockEntities;
import net.blay09.mods.cookingforblockheads.block.entity.util.DoorAnimator;
import net.blay09.mods.cookingforblockheads.block.entity.util.TransferableBlockEntity;
import net.blay09.mods.cookingforblockheads.block.entity.util.TransferableContainer;
import net.blay09.mods.cookingforblockheads.capability.KitchenItemProviderHolder;
import net.blay09.mods.cookingforblockheads.item.ModItems;
import net.blay09.mods.cookingforblockheads.kitchen.ConditionalKitchenItemProvider;
import net.blay09.mods.cookingforblockheads.kitchen.ContainerKitchenItemProvider;
import net.blay09.mods.cookingforblockheads.kitchen.ConversingKitchenItemProvider;
import net.blay09.mods.cookingforblockheads.menu.CounterMenu;
import net.blay09.mods.cookingforblockheads.util.ItemUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;

public class CounterBlockEntity
extends BalmBlockEntity
implements BalmMenuProvider<BlockPos>,
IMutableNameable,
BalmContainerProvider,
CustomRenderBoundingBox,
TransferableBlockEntity<TransferableContainer>,
UpgradeablePreservation,
KitchenItemProviderHolder {
    private final int containerSize;
    private final DefaultContainer container;
    private final DoorAnimator doorAnimator;
    private boolean hasPreservationUpgrade;
    private Component customName;
    private boolean isDirty;
    private final ContainerKitchenItemProvider conservingItemProvider;
    private final ContainerKitchenItemProvider containerItemProvider;
    private final KitchenItemProvider itemProvider;

    public CounterBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType)ModBlockEntities.counter.get(), pos, state);
    }

    public CounterBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.containerSize = CookingForBlockheadsConfig.getActive().largeCounters ? 54 : 27;
        this.container = new DefaultContainer(this.containerSize){

            public void setChanged() {
                CounterBlockEntity.this.isDirty = true;
                CounterBlockEntity.this.setChanged();
            }
        };
        this.doorAnimator = new DoorAnimator((BlockEntity)this, 1, 2);
        this.conservingItemProvider = new ConversingKitchenItemProvider((Container)this.container);
        this.containerItemProvider = new ContainerKitchenItemProvider((Container)this.container);
        this.itemProvider = new ConditionalKitchenItemProvider<ContainerKitchenItemProvider>(this::hasPreservationUpgrade, this.conservingItemProvider, this.containerItemProvider);
        this.doorAnimator.setOpenRadius(2.0f);
        this.doorAnimator.setSoundEventOpen(SoundEvents.CHEST_OPEN);
        this.doorAnimator.setSoundEventClose(SoundEvents.CHEST_CLOSE);
    }

    public static void clientTick(Level level, BlockPos pos, BlockState state, CounterBlockEntity blockEntity) {
        blockEntity.clientTick(level, pos, state);
    }

    public void clientTick(Level level, BlockPos pos, BlockState state) {
        this.doorAnimator.update();
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, CounterBlockEntity blockEntity) {
        blockEntity.serverTick(level, pos, state);
    }

    public void serverTick(Level level, BlockPos pos, BlockState state) {
        if (this.isDirty) {
            this.sync();
            this.isDirty = false;
        }
    }

    public boolean triggerEvent(int id, int type) {
        return this.doorAnimator.receiveClientEvent(id, type) || super.triggerEvent(id, type);
    }

    protected void applyImplicitComponents(DataComponentGetter input) {
        Component customNameComponent = (Component)input.get(DataComponents.CUSTOM_NAME);
        if (customNameComponent != null) {
            this.customName = customNameComponent;
        }
    }

    protected void collectImplicitComponents(DataComponentMap.Builder builder) {
        builder.set(DataComponents.CUSTOM_NAME, (Object)this.customName);
    }

    public void loadAdditional(ValueInput input) {
        input.child("ItemHandler").ifPresent(it -> ContainerHelper.loadAllItems((ValueInput)it, (NonNullList)this.container.getItems()));
        this.hasPreservationUpgrade = input.getBooleanOr("HasPreservationUpgrade", false);
        this.customName = input.read("CustomNameV2", ComponentSerialization.CODEC).orElse(null);
        this.doorAnimator.setForcedOpen(input.getBooleanOr("IsForcedOpen", false));
        this.doorAnimator.setNumPlayersUsing(input.getByteOr("NumPlayersUsing", (byte)0));
    }

    public void saveAdditional(ValueOutput output) {
        ContainerHelper.saveAllItems((ValueOutput)output.child("ItemHandler"), (NonNullList)this.container.getItems());
        output.putBoolean("HasPreservationUpgrade", this.hasPreservationUpgrade);
        output.storeNullable("CustomName", ComponentSerialization.CODEC, (Object)this.customName);
    }

    public void writeUpdateTag(ValueOutput output) {
        this.saveAdditional(output);
        output.putBoolean("IsForcedOpen", this.doorAnimator.isForcedOpen());
        output.putByte("NumPlayersUsing", (byte)this.doorAnimator.getNumPlayersUsing());
    }

    public DoorAnimator getDoorAnimator() {
        return this.doorAnimator;
    }

    public Direction getFacing() {
        BlockState blockState = this.getBlockState();
        return blockState.hasProperty((Property)BlockStateProperties.FACING) ? (Direction)blockState.getValue((Property)BlockStateProperties.FACING) : Direction.NORTH;
    }

    public boolean isFlipped() {
        BlockState blockState = this.getBlockState();
        return blockState.hasProperty((Property)CounterBlock.FLIPPED) && (Boolean)blockState.getValue((Property)CounterBlock.FLIPPED) != false;
    }

    @Nullable
    public AbstractContainerMenu createMenu(int i, Inventory playerInventory, Player playerEntity) {
        return new CounterMenu(i, playerInventory, this);
    }

    public AABB getRenderBoundingBox() {
        return new AABB(this.worldPosition.offset(-1, 0, -1).getCenter(), this.worldPosition.offset(2, 1, 2).getCenter());
    }

    public Component getName() {
        return this.customName != null ? this.customName : this.getDefaultName();
    }

    @Override
    public void setCustomName(Component customName) {
        this.customName = customName;
        this.setChanged();
    }

    public boolean hasCustomName() {
        return this.customName != null;
    }

    @Nullable
    public Component getCustomName() {
        return this.customName;
    }

    public Component getDisplayName() {
        return this.getName();
    }

    @Override
    public Component getDefaultName() {
        return Component.translatable((String)"container.cookingforblockheads.counter");
    }

    public void setChanged() {
        this.isDirty = true;
        super.setChanged();
    }

    public Container getContainer() {
        return this.container;
    }

    public BlockPos getScreenOpeningData(ServerPlayer serverPlayer) {
        return this.worldPosition;
    }

    public StreamCodec<RegistryFriendlyByteBuf, BlockPos> getScreenStreamCodec() {
        return BlockPos.STREAM_CODEC.cast();
    }

    @Override
    public TransferableContainer snapshotDataForTransfer() {
        return TransferableContainer.copyAndClear((Container)this.container);
    }

    @Override
    public void restoreFromTransferSnapshot(TransferableContainer data) {
        data.applyTo((Container)this.container);
    }

    @Override
    public boolean hasPreservationUpgrade() {
        return this.hasPreservationUpgrade;
    }

    @Override
    public void setHasPreservationUpgrade(boolean hasPreservationUpgrade) {
        this.hasPreservationUpgrade = hasPreservationUpgrade;
        this.setChanged();
    }

    public void preRemoveSideEffects(BlockPos pos, BlockState state) {
        super.preRemoveSideEffects(pos, state);
        if (this.hasPreservationUpgrade()) {
            ItemUtils.spawnItemStack(this.level, (float)pos.getX() + 0.5f, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, new ItemStack((ItemLike)ModItems.preservationChamber));
        }
    }

    @Override
    public KitchenItemProvider getKitchenItemProvider() {
        return this.itemProvider;
    }
}

