/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.block.entity;

import net.blay09.mods.cookingforblockheads.CookingForBlockheadsConfig;
import net.blay09.mods.cookingforblockheads.block.entity.IMutableNameable;
import net.blay09.mods.cookingforblockheads.block.entity.MilkJarBlockEntity;
import net.blay09.mods.cookingforblockheads.block.entity.ModBlockEntities;
import net.blay09.mods.cookingforblockheads.compat.Compat;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.world.entity.animal.CowVariant;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.jetbrains.annotations.Nullable;

public class CowJarBlockEntity
extends MilkJarBlockEntity
implements IMutableNameable {
    private static final int UPDATE_INTERVAL = 20;
    private boolean isDirty;
    private int ticksSinceUpdate;
    private Component customName;
    private Holder<CowVariant> variant;
    private boolean compressedCow;
    private BlockPos jukebox;
    private int partyBpm;

    public CowJarBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType<? extends MilkJarBlockEntity>)((BlockEntityType)ModBlockEntities.cowJar.get()), pos, state);
    }

    protected void applyImplicitComponents(DataComponentGetter input) {
        Component customNameComponent = (Component)input.get(DataComponents.CUSTOM_NAME);
        if (customNameComponent != null) {
            this.customName = customNameComponent;
        }
    }

    protected void collectImplicitComponents(DataComponentMap.Builder builder) {
        builder.set(DataComponents.CUSTOM_NAME, (Object)this.customName);
    }

    @Override
    public void loadAdditional(ValueInput input) {
        super.loadAdditional(input);
        this.customName = input.read("CustomNameV2", ComponentSerialization.CODEC).orElse(null);
        this.variant = input.read("Variant", CowVariant.CODEC).orElse(null);
        this.compressedCow = input.getBooleanOr("CompressedCow", false);
    }

    @Override
    public void saveAdditional(ValueOutput output) {
        super.saveAdditional(output);
        output.storeNullable("CustomNameV2", ComponentSerialization.CODEC, (Object)this.customName);
        output.storeNullable("Variant", CowVariant.CODEC, this.variant);
        output.putBoolean("CompressedCow", this.compressedCow);
    }

    public static void clientTick(Level level, BlockPos pos, BlockState state, CowJarBlockEntity blockEntity) {
        BlockPos jukebox = blockEntity.jukebox;
        if (jukebox == null || !jukebox.closerToCenterThan((Position)pos.getCenter(), (double)3.46f) || !level.getBlockState(jukebox).is(Blocks.JUKEBOX)) {
            blockEntity.partyBpm = 0;
            blockEntity.jukebox = null;
        }
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, CowJarBlockEntity blockEntity) {
        blockEntity.serverTick(level, pos, state);
    }

    public void serverTick(Level level, BlockPos pos, BlockState state) {
        if (this.milkTank.getAmount() < 32000) {
            CookingForBlockheadsConfig config = CookingForBlockheadsConfig.getActive();
            int milkToAdd = config.cowJarMilkPerTick;
            if (this.compressedCow) {
                milkToAdd = (int)((double)milkToAdd * config.compressedCowJarMilkMultiplier);
            }
            this.milkTank.fill(Compat.getMilkFluid(), milkToAdd, false);
            this.isDirty = true;
        }
        ++this.ticksSinceUpdate;
        if (this.isDirty && this.ticksSinceUpdate > 20) {
            this.sync();
            this.ticksSinceUpdate = 0;
            this.isDirty = false;
        }
    }

    public boolean isCompressedCow() {
        return this.compressedCow;
    }

    public void setCompressedCow(boolean compressedCow) {
        this.compressedCow = compressedCow;
    }

    @Override
    public void setCustomName(Component customName) {
        this.customName = customName;
        this.setChanged();
    }

    public Component getCustomName() {
        return this.customName;
    }

    public boolean hasCustomName() {
        return this.customName != null;
    }

    public Component getDisplayName() {
        return this.getName();
    }

    public Component getName() {
        return this.customName != null ? this.customName : this.getDefaultName();
    }

    @Override
    public Component getDefaultName() {
        if (this.compressedCow) {
            return Component.translatable((String)"container.cookingforblockheads.cow_jar_compressed");
        }
        return Component.translatable((String)"container.cookingforblockheads.cow_jar");
    }

    @Nullable
    public Holder<CowVariant> getVariant() {
        return this.variant;
    }

    public void setVariant(Holder<CowVariant> variant) {
        this.variant = variant;
    }

    public boolean isPartying() {
        return this.partyBpm > 0;
    }

    public void setRecordPlayingNearby(BlockPos pos, boolean playing) {
        this.jukebox = pos;
        this.partyBpm = playing ? 85 : 0;
    }
}

