/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.block.entity;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import net.blay09.mods.balm.api.block.entity.CustomRenderBoundingBox;
import net.blay09.mods.balm.api.container.BalmContainerProvider;
import net.blay09.mods.balm.api.container.CombinedContainer;
import net.blay09.mods.balm.api.container.DefaultContainer;
import net.blay09.mods.balm.api.menu.BalmMenuProvider;
import net.blay09.mods.balm.common.BalmBlockEntity;
import net.blay09.mods.cookingforblockheads.api.CacheHint;
import net.blay09.mods.cookingforblockheads.api.IngredientToken;
import net.blay09.mods.cookingforblockheads.api.KitchenItemProvider;
import net.blay09.mods.cookingforblockheads.api.UpgradeablePreservation;
import net.blay09.mods.cookingforblockheads.block.entity.IMutableNameable;
import net.blay09.mods.cookingforblockheads.block.entity.ModBlockEntities;
import net.blay09.mods.cookingforblockheads.block.entity.util.DoorAnimator;
import net.blay09.mods.cookingforblockheads.block.entity.util.TransferableBlockEntity;
import net.blay09.mods.cookingforblockheads.block.entity.util.TransferableContainer;
import net.blay09.mods.cookingforblockheads.capability.KitchenItemProviderHolder;
import net.blay09.mods.cookingforblockheads.item.ModItems;
import net.blay09.mods.cookingforblockheads.kitchen.CombinedKitchenItemProvider;
import net.blay09.mods.cookingforblockheads.kitchen.ConditionalKitchenItemProvider;
import net.blay09.mods.cookingforblockheads.kitchen.ContainerKitchenItemProvider;
import net.blay09.mods.cookingforblockheads.kitchen.ConversingKitchenItemProvider;
import net.blay09.mods.cookingforblockheads.menu.FridgeMenu;
import net.blay09.mods.cookingforblockheads.sound.ModSounds;
import net.blay09.mods.cookingforblockheads.util.ItemUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;

public class FridgeBlockEntity
extends BalmBlockEntity
implements BalmMenuProvider<BlockPos>,
IMutableNameable,
BalmContainerProvider,
CustomRenderBoundingBox,
TransferableBlockEntity<TransferableContainer>,
UpgradeablePreservation,
KitchenItemProviderHolder {
    private final KitchenItemProvider iceUnitItemProvider = new KitchenItemProvider(this){
        private final Set<ItemStack> providedItems = Set.of(new ItemStack((ItemLike)Items.SNOWBALL), new ItemStack((ItemLike)Items.SNOW_BLOCK), new ItemStack((ItemLike)Items.ICE));

        @Override
        public IngredientToken findIngredient(Ingredient ingredient, Collection<IngredientToken> ingredientTokens, CacheHint cacheHint) {
            for (ItemStack providedItem : this.providedItems) {
                if (!ingredient.test(providedItem)) continue;
                return new IceUnitIngredientToken(providedItem);
            }
            return null;
        }

        @Override
        public IngredientToken findIngredient(ItemStack itemStack, Collection<IngredientToken> ingredientTokens, CacheHint cacheHint) {
            for (ItemStack providedItem : this.providedItems) {
                if (!ItemStack.isSameItem((ItemStack)providedItem, (ItemStack)itemStack)) continue;
                return new IceUnitIngredientToken(providedItem);
            }
            return null;
        }

        @Override
        public CacheHint getCacheHint(IngredientToken ingredientToken) {
            return CacheHint.NONE;
        }
    };
    private final DoorAnimator doorAnimator = new DoorAnimator((BlockEntity)this, 1, 2);
    public boolean hasIceUpgrade;
    public boolean hasPreservationUpgrade;
    private Component customName;
    private boolean isDirty;
    private final DefaultContainer container = new DefaultContainer(27){

        public void setChanged() {
            FridgeBlockEntity.this.isDirty = true;
            FridgeBlockEntity.this.setChanged();
        }
    };
    private final ContainerKitchenItemProvider conservingItemProvider = new ConversingKitchenItemProvider((Container)this.container);
    private final ContainerKitchenItemProvider containerItemProvider = new ContainerKitchenItemProvider((Container)this.container);
    private final KitchenItemProvider itemProvider = new CombinedKitchenItemProvider(List.of(new ConditionalKitchenItemProvider<KitchenItemProvider>(this::hasIceUpgrade, this.iceUnitItemProvider), new ConditionalKitchenItemProvider<ContainerKitchenItemProvider>(this::hasPreservationUpgrade, this.conservingItemProvider, this.containerItemProvider)));

    public FridgeBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.fridge.get(), pos, state);
        this.doorAnimator.setOpenRadius(2.0f);
        this.doorAnimator.setSoundEventOpen((SoundEvent)ModSounds.fridgeOpen.get());
        this.doorAnimator.setSoundEventClose((SoundEvent)ModSounds.fridgeClose.get());
    }

    public static void clientTick(Level level, BlockPos pos, BlockState state, FridgeBlockEntity blockEntity) {
        blockEntity.clientTick(level, pos, state);
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, FridgeBlockEntity blockEntity) {
        blockEntity.serverTick(level, pos, state);
    }

    public boolean hasIceUpgrade() {
        return this.hasIceUpgrade;
    }

    public void setHasIceUpgrade(boolean hasIceUpgrade) {
        this.hasIceUpgrade = hasIceUpgrade;
        this.markDirtyAndUpdate();
    }

    @Override
    public boolean hasPreservationUpgrade() {
        return this.getBaseFridge().hasPreservationUpgrade;
    }

    @Override
    public void setHasPreservationUpgrade(boolean hasPreservationUpgrade) {
        FridgeBlockEntity baseFridge = this.getBaseFridge();
        baseFridge.hasPreservationUpgrade = hasPreservationUpgrade;
        baseFridge.markDirtyAndUpdate();
    }

    public void clientTick(Level level, BlockPos pos, BlockState state) {
        this.doorAnimator.update();
    }

    public void serverTick(Level level, BlockPos pos, BlockState state) {
        if (this.isDirty) {
            this.sync();
            this.isDirty = false;
        }
    }

    public boolean triggerEvent(int id, int type) {
        return this.doorAnimator.receiveClientEvent(id, type) || super.triggerEvent(id, type);
    }

    protected void applyImplicitComponents(DataComponentGetter input) {
        Component customNameComponent = (Component)input.get(DataComponents.CUSTOM_NAME);
        if (customNameComponent != null) {
            this.customName = customNameComponent;
        }
    }

    protected void collectImplicitComponents(DataComponentMap.Builder builder) {
        builder.set(DataComponents.CUSTOM_NAME, (Object)this.customName);
    }

    public void loadAdditional(ValueInput input) {
        input.child("ItemHandler").ifPresent(it -> ContainerHelper.loadAllItems((ValueInput)it, (NonNullList)this.container.getItems()));
        this.hasIceUpgrade = input.getBooleanOr("HasIceUpgrade", false);
        this.hasPreservationUpgrade = input.getBooleanOr("HasPreservationUpgrade", false);
        this.customName = input.read("CustomNameV2", ComponentSerialization.CODEC).orElse(null);
        this.doorAnimator.setForcedOpen(input.getBooleanOr("IsForcedOpen", false));
        this.doorAnimator.setNumPlayersUsing(input.getByteOr("NumPlayersUsing", (byte)0));
    }

    public void saveAdditional(ValueOutput output) {
        ContainerHelper.saveAllItems((ValueOutput)output.child("ItemHandler"), (NonNullList)this.container.getItems());
        output.putBoolean("HasIceUpgrade", this.hasIceUpgrade);
        output.putBoolean("HasPreservationUpgrade", this.hasPreservationUpgrade);
        output.storeNullable("CustomNameV2", ComponentSerialization.CODEC, (Object)this.customName);
    }

    public void writeUpdateTag(ValueOutput output) {
        this.saveAdditional(output);
        output.putBoolean("IsForcedOpen", this.doorAnimator.isForcedOpen());
        output.putByte("NumPlayersUsing", (byte)this.doorAnimator.getNumPlayersUsing());
    }

    @Nullable
    public FridgeBlockEntity findNeighbourFridge() {
        BlockState state = this.getBlockState();
        BlockPos posBelow = this.worldPosition.below();
        BlockState stateBelow = this.level.getBlockState(posBelow);
        BlockPos posAbove = this.worldPosition.above();
        BlockState stateAbove = this.level.getBlockState(posAbove);
        if (stateAbove.getBlock() == state.getBlock()) {
            return (FridgeBlockEntity)this.level.getBlockEntity(posAbove);
        }
        if (stateBelow.getBlock() == state.getBlock()) {
            return (FridgeBlockEntity)this.level.getBlockEntity(posBelow);
        }
        return null;
    }

    public FridgeBlockEntity getBaseFridge() {
        FridgeBlockEntity baseFridge;
        if (!this.hasLevel()) {
            return this;
        }
        BlockState state = this.getBlockState();
        BlockState stateBelow = this.level.getBlockState(this.worldPosition.below());
        if (stateBelow.getBlock() == state.getBlock() && (baseFridge = (FridgeBlockEntity)this.level.getBlockEntity(this.worldPosition.below())) != null) {
            return baseFridge;
        }
        return this;
    }

    @Override
    public KitchenItemProvider getKitchenItemProvider() {
        return this.itemProvider;
    }

    public DoorAnimator getDoorAnimator() {
        return this.doorAnimator;
    }

    public Container getCombinedContainer() {
        FridgeBlockEntity baseFridge = this.getBaseFridge();
        FridgeBlockEntity neighbourFridge = baseFridge == this ? this.findNeighbourFridge() : this;
        if (neighbourFridge != null) {
            return new CombinedContainer(new Container[]{neighbourFridge.container, baseFridge.container});
        }
        return this.container;
    }

    public AABB getRenderBoundingBox() {
        return new AABB(this.worldPosition.offset(-1, 0, -1).getCenter(), this.worldPosition.offset(2, 2, 2).getCenter());
    }

    public void markDirtyAndUpdate() {
        BlockState state = this.level.getBlockState(this.worldPosition);
        this.level.sendBlockUpdated(this.worldPosition, state, state, 3);
        this.setChanged();
    }

    @Nullable
    public AbstractContainerMenu createMenu(int i, Inventory playerInventory, Player playerEntity) {
        return new FridgeMenu(i, playerInventory, this);
    }

    public Component getName() {
        return this.customName != null ? this.customName : this.getDefaultName();
    }

    public boolean hasCustomName() {
        return this.customName != null;
    }

    @Nullable
    public Component getCustomName() {
        return this.customName;
    }

    @Override
    public void setCustomName(Component customName) {
        this.customName = customName;
        this.setChanged();
    }

    public Component getDisplayName() {
        return this.getName();
    }

    @Override
    public Component getDefaultName() {
        return Component.translatable((String)"container.cookingforblockheads.fridge");
    }

    public Container getContainer() {
        return this.container;
    }

    public StreamCodec<RegistryFriendlyByteBuf, BlockPos> getScreenStreamCodec() {
        return BlockPos.STREAM_CODEC.cast();
    }

    public BlockPos getScreenOpeningData(ServerPlayer serverPlayer) {
        return this.worldPosition;
    }

    @Override
    public TransferableContainer snapshotDataForTransfer() {
        return TransferableContainer.copyAndClear((Container)this.container);
    }

    @Override
    public void restoreFromTransferSnapshot(TransferableContainer data) {
        data.applyTo((Container)this.container);
    }

    public void preRemoveSideEffects(BlockPos pos, BlockState state) {
        super.preRemoveSideEffects(pos, state);
        if (this.hasIceUpgrade()) {
            ItemUtils.spawnItemStack(this.level, (float)pos.getX() + 0.5f, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, new ItemStack((ItemLike)ModItems.iceUnit));
        }
        if (this.hasPreservationUpgrade()) {
            ItemUtils.spawnItemStack(this.level, (float)pos.getX() + 0.5f, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, new ItemStack((ItemLike)ModItems.preservationChamber));
        }
    }

    public record IceUnitIngredientToken(ItemStack itemStack) implements IngredientToken
    {
        @Override
        public ItemStack peek() {
            return this.itemStack;
        }

        @Override
        public ItemStack consume() {
            return this.itemStack;
        }

        @Override
        public ItemStack restore(ItemStack itemStack) {
            return ItemStack.EMPTY;
        }
    }
}

