/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.block.entity;

import net.blay09.mods.balm.api.container.BalmContainerProvider;
import net.blay09.mods.balm.api.container.DefaultContainer;
import net.blay09.mods.balm.api.menu.BalmMenuProvider;
import net.blay09.mods.balm.common.BalmBlockEntity;
import net.blay09.mods.cookingforblockheads.api.KitchenItemProvider;
import net.blay09.mods.cookingforblockheads.api.UpgradeablePreservation;
import net.blay09.mods.cookingforblockheads.block.entity.IMutableNameable;
import net.blay09.mods.cookingforblockheads.block.entity.ModBlockEntities;
import net.blay09.mods.cookingforblockheads.capability.KitchenItemProviderHolder;
import net.blay09.mods.cookingforblockheads.item.ModItems;
import net.blay09.mods.cookingforblockheads.kitchen.ConditionalKitchenItemProvider;
import net.blay09.mods.cookingforblockheads.kitchen.ContainerKitchenItemProvider;
import net.blay09.mods.cookingforblockheads.kitchen.ConversingKitchenItemProvider;
import net.blay09.mods.cookingforblockheads.menu.FruitBasketMenu;
import net.blay09.mods.cookingforblockheads.util.ItemUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.jetbrains.annotations.Nullable;

public class FruitBasketBlockEntity
extends BalmBlockEntity
implements BalmMenuProvider<BlockPos>,
IMutableNameable,
BalmContainerProvider,
UpgradeablePreservation,
KitchenItemProviderHolder {
    private boolean hasPreservationUpgrade;
    private Component customName;
    private boolean isDirty;
    private final DefaultContainer container = new DefaultContainer(27){

        public void setChanged() {
            FruitBasketBlockEntity.this.setChanged();
            FruitBasketBlockEntity.this.sync();
        }
    };
    private final ContainerKitchenItemProvider conservingItemProvider = new ConversingKitchenItemProvider((Container)this.container);
    private final ContainerKitchenItemProvider containerItemProvider = new ContainerKitchenItemProvider((Container)this.container);
    private final KitchenItemProvider itemProvider = new ConditionalKitchenItemProvider<ContainerKitchenItemProvider>(this::hasPreservationUpgrade, this.conservingItemProvider, this.containerItemProvider);

    public FruitBasketBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.fruitBasket.get(), pos, state);
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, FruitBasketBlockEntity blockEntity) {
        blockEntity.serverTick(level, pos, state);
    }

    protected void applyImplicitComponents(DataComponentGetter input) {
        Component customNameComponent = (Component)input.get(DataComponents.CUSTOM_NAME);
        if (customNameComponent != null) {
            this.customName = customNameComponent;
        }
    }

    protected void collectImplicitComponents(DataComponentMap.Builder builder) {
        builder.set(DataComponents.CUSTOM_NAME, (Object)this.customName);
    }

    public void loadAdditional(ValueInput input) {
        input.child("ItemHandler").ifPresent(it -> ContainerHelper.loadAllItems((ValueInput)it, (NonNullList)this.container.getItems()));
        this.hasPreservationUpgrade = input.getBooleanOr("HasPreservationUpgrade", false);
        this.customName = input.read("CustomNameV2", ComponentSerialization.CODEC).orElse(null);
    }

    public void saveAdditional(ValueOutput output) {
        ContainerHelper.saveAllItems((ValueOutput)output.child("ItemHandler"), (NonNullList)this.container.getItems());
        output.putBoolean("HasPreservationUpgrade", this.hasPreservationUpgrade);
        output.storeNullable("CustomName", ComponentSerialization.CODEC, (Object)this.customName);
    }

    public void writeUpdateTag(ValueOutput output) {
        this.saveAdditional(output);
    }

    public Component getName() {
        return this.customName != null ? this.customName : this.getDefaultName();
    }

    public boolean hasCustomName() {
        return this.customName != null;
    }

    @Nullable
    public Component getCustomName() {
        return this.customName;
    }

    @Override
    public void setCustomName(Component customName) {
        this.customName = customName;
        this.setChanged();
    }

    public Component getDisplayName() {
        return this.getName();
    }

    @Nullable
    public AbstractContainerMenu createMenu(int i, Inventory playerInventory, Player playerEntity) {
        return new FruitBasketMenu(i, playerInventory, this);
    }

    @Override
    public Component getDefaultName() {
        return Component.translatable((String)"container.cookingforblockheads.fruit_basket");
    }

    public Container getContainer() {
        return this.container;
    }

    public void serverTick(Level level, BlockPos pos, BlockState state) {
        if (this.isDirty) {
            this.sync();
            this.isDirty = false;
        }
    }

    public void setChanged() {
        this.isDirty = true;
        super.setChanged();
    }

    public StreamCodec<RegistryFriendlyByteBuf, BlockPos> getScreenStreamCodec() {
        return BlockPos.STREAM_CODEC.cast();
    }

    public BlockPos getScreenOpeningData(ServerPlayer serverPlayer) {
        return this.worldPosition;
    }

    @Override
    public boolean hasPreservationUpgrade() {
        return this.hasPreservationUpgrade;
    }

    @Override
    public void setHasPreservationUpgrade(boolean hasPreservationUpgrade) {
        this.hasPreservationUpgrade = hasPreservationUpgrade;
        this.setChanged();
    }

    @Override
    public KitchenItemProvider getKitchenItemProvider() {
        return this.itemProvider;
    }

    public void preRemoveSideEffects(BlockPos pos, BlockState state) {
        super.preRemoveSideEffects(pos, state);
        if (this.hasPreservationUpgrade()) {
            ItemUtils.spawnItemStack(this.level, (float)pos.getX() + 0.5f, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, new ItemStack((ItemLike)ModItems.preservationChamber));
        }
    }
}

