/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.blay09.mods.cookingforblockheads.block.CookingTableBlock;
import net.blay09.mods.cookingforblockheads.block.entity.CookingTableBlockEntity;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.state.BlockEntityRenderState;
import net.minecraft.client.renderer.feature.ModelFeatureRenderer;
import net.minecraft.client.renderer.item.ItemModelResolver;
import net.minecraft.client.renderer.item.ItemStackRenderState;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionfc;

public class CookingTableRenderer
implements BlockEntityRenderer<CookingTableBlockEntity, CookingTableRenderState> {
    private final ItemModelResolver itemModelResolver;

    public CookingTableRenderer(BlockEntityRendererProvider.Context context) {
        this.itemModelResolver = context.itemModelResolver();
    }

    public CookingTableRenderState createRenderState() {
        return new CookingTableRenderState();
    }

    public void extractRenderState(CookingTableBlockEntity blockEntity, CookingTableRenderState renderState, float delta, Vec3 vec, @Nullable ModelFeatureRenderer.CrumblingOverlay crumblingOverlay) {
        super.extractRenderState((BlockEntity)blockEntity, (BlockEntityRenderState)renderState, delta, vec, crumblingOverlay);
        renderState.facing = (Direction)blockEntity.getBlockState().getValue((Property)CookingTableBlock.FACING);
        this.itemModelResolver.updateForTopItem(renderState.item, blockEntity.getNoFilterBook(), ItemDisplayContext.FIXED, blockEntity.getLevel(), null, 0);
    }

    public void submit(CookingTableRenderState renderState, PoseStack poseStack, SubmitNodeCollector submitNodeCollector, CameraRenderState cameraRenderState) {
        if (!renderState.item.isEmpty()) {
            poseStack.pushPose();
            poseStack.translate(0.5f, 0.0f, 0.5f);
            poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(-renderState.facing.toYRot() + 180.0f));
            poseStack.translate(-0.5f, 0.0f, -0.5f);
            poseStack.translate(0.0f, 1.0725f, 0.0f);
            poseStack.mulPose((Quaternionfc)Axis.XP.rotationDegrees(90.0f));
            poseStack.scale(0.5f, 0.5f, 0.5f);
            renderState.item.submit(poseStack, submitNodeCollector, renderState.lightCoords, OverlayTexture.NO_OVERLAY, 0);
            poseStack.popPose();
        }
    }

    public static class CookingTableRenderState
    extends BlockEntityRenderState {
        public final ItemStackRenderState item = new ItemStackRenderState();
        public Direction facing = Direction.NORTH;
    }
}

