/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.blay09.mods.cookingforblockheads.block.FruitBasketBlock;
import net.blay09.mods.cookingforblockheads.block.entity.FruitBasketBlockEntity;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.state.BlockEntityRenderState;
import net.minecraft.client.renderer.feature.ModelFeatureRenderer;
import net.minecraft.client.renderer.item.ItemModelResolver;
import net.minecraft.client.renderer.item.ItemStackRenderState;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionfc;

public class FruitBasketRenderer
implements BlockEntityRenderer<FruitBasketBlockEntity, FruitBasketRenderState> {
    private final ItemModelResolver itemModelResolver;

    public FruitBasketRenderer(BlockEntityRendererProvider.Context context) {
        this.itemModelResolver = context.itemModelResolver();
    }

    public FruitBasketRenderState createRenderState() {
        return new FruitBasketRenderState();
    }

    public void extractRenderState(FruitBasketBlockEntity blockEntity, FruitBasketRenderState renderState, float delta, Vec3 vec, @Nullable ModelFeatureRenderer.CrumblingOverlay crumblingOverlay) {
        super.extractRenderState((BlockEntity)blockEntity, (BlockEntityRenderState)renderState, delta, vec, crumblingOverlay);
        renderState.facing = (Direction)blockEntity.getBlockState().getValue((Property)FruitBasketBlock.FACING);
        int id = (int)blockEntity.getBlockPos().asLong();
        renderState.items = new ArrayList<ItemStackRenderState>();
        for (int i = 0; i < blockEntity.getContainer().getContainerSize(); ++i) {
            ItemStack itemStack = blockEntity.getContainer().getItem(i);
            ItemStackRenderState itemStackRenderState = new ItemStackRenderState();
            this.itemModelResolver.updateForTopItem(itemStackRenderState, itemStack, ItemDisplayContext.FIXED, blockEntity.getLevel(), null, id + i);
            renderState.items.add(itemStackRenderState);
        }
    }

    public void submit(FruitBasketRenderState renderState, PoseStack poseStack, SubmitNodeCollector submitNodeCollector, CameraRenderState cameraRenderState) {
        poseStack.pushPose();
        poseStack.translate(0.5f, 0.0f, 0.5f);
        poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(-renderState.facing.toYRot() + 180.0f));
        poseStack.translate(-0.5f, 0.0f, -0.5f);
        poseStack.translate(0.5, 0.5, 0.5);
        poseStack.scale(0.25f, 0.25f, 0.25f);
        int itemsPerRow = 7;
        for (int i = 0; i < renderState.items.size(); ++i) {
            ItemStackRenderState itemStackRenderState = renderState.items.get(i);
            if (itemStackRenderState.isEmpty()) continue;
            int rowIndex = i % itemsPerRow;
            int colIndex = i / itemsPerRow;
            float antiZFight = (rowIndex % 2 != 0 ? 0.1f : 0.0f) + (float)i * 0.01f;
            float curX = -0.75f + (float)rowIndex * 0.25f + (colIndex == 3 ? 0.15f : 0.0f);
            float curY = -1.35f;
            float curZ = -0.75f + (float)colIndex * 0.35f + antiZFight;
            poseStack.pushPose();
            poseStack.translate(curX, curY, curZ);
            poseStack.mulPose((Quaternionfc)Axis.XP.rotationDegrees(25.0f));
            itemStackRenderState.submit(poseStack, submitNodeCollector, renderState.lightCoords, OverlayTexture.NO_OVERLAY, 0);
            poseStack.popPose();
        }
        poseStack.popPose();
    }

    public static class FruitBasketRenderState
    extends BlockEntityRenderState {
        public List<ItemStackRenderState> items = Collections.emptyList();
        public Direction facing = Direction.NORTH;
    }
}

