/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.blay09.mods.cookingforblockheads.block.MilkJarBlock;
import net.blay09.mods.cookingforblockheads.block.entity.MilkJarBlockEntity;
import net.blay09.mods.cookingforblockheads.client.ModModels;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.block.model.BlockStateModel;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.state.BlockEntityRenderState;
import net.minecraft.client.renderer.feature.ModelFeatureRenderer;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionfc;

public class MilkJarRenderer<TBlockEntity extends MilkJarBlockEntity>
implements BlockEntityRenderer<TBlockEntity, MilkJarRenderState> {
    private static final RandomSource random = RandomSource.create();

    public MilkJarRenderer(BlockEntityRendererProvider.Context context) {
    }

    public MilkJarRenderState createRenderState() {
        return new MilkJarRenderState();
    }

    public void extractRenderState(TBlockEntity blockEntity, MilkJarRenderState renderState, float delta, Vec3 vec, @Nullable ModelFeatureRenderer.CrumblingOverlay crumblingOverlay) {
        super.extractRenderState(blockEntity, (BlockEntityRenderState)renderState, delta, vec, crumblingOverlay);
        renderState.facing = (Direction)blockEntity.getBlockState().getValue((Property)MilkJarBlock.FACING);
        renderState.fluidLevel = (float)((MilkJarBlockEntity)blockEntity).getFluidTank().getAmount() / (float)((MilkJarBlockEntity)blockEntity).getFluidTank().getCapacity();
    }

    public void submit(MilkJarRenderState renderState, PoseStack poseStack, SubmitNodeCollector submitNodeCollector, CameraRenderState cameraRenderState) {
        if (renderState.fluidLevel > 0.0f) {
            poseStack.pushPose();
            poseStack.translate(0.5f, 0.0f, 0.5f);
            poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(-renderState.facing.toYRot() + 180.0f));
            poseStack.translate(-0.5f, 0.0f, -0.5f);
            poseStack.scale(1.0f, renderState.fluidLevel, 1.0f);
            submitNodeCollector.submitBlockModel(poseStack, RenderType.entityCutout((ResourceLocation)TextureAtlas.LOCATION_BLOCKS), this.getLiquidModel(), 0.0f, 0.0f, 0.0f, renderState.lightCoords, OverlayTexture.NO_OVERLAY, 0);
            poseStack.popPose();
        }
    }

    protected BlockStateModel getLiquidModel() {
        return (BlockStateModel)ModModels.milkJarLiquid.get();
    }

    public static class MilkJarRenderState
    extends BlockEntityRenderState {
        public float fluidLevel;
        public Direction facing = Direction.NORTH;
    }
}

