/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.crafting;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public record CraftableWithStatus(ItemStack itemStack, boolean missingIngredients, boolean missingUtensils) {
    public static final StreamCodec<RegistryFriendlyByteBuf, CraftableWithStatus> STREAM_CODEC = StreamCodec.composite((StreamCodec)ItemStack.STREAM_CODEC, CraftableWithStatus::itemStack, (StreamCodec)ByteBufCodecs.BOOL, CraftableWithStatus::missingIngredients, (StreamCodec)ByteBufCodecs.BOOL, CraftableWithStatus::missingUtensils, CraftableWithStatus::new);
    public static final StreamCodec<RegistryFriendlyByteBuf, List<CraftableWithStatus>> LIST_STREAM_CODEC = STREAM_CODEC.apply(ByteBufCodecs.collection(ArrayList::new));

    public static CraftableWithStatus best(@Nullable CraftableWithStatus first, @Nullable CraftableWithStatus second) {
        if (first == null) {
            return second;
        }
        if (second == null) {
            return first;
        }
        if (!first.missingIngredients && second.missingIngredients) {
            return first;
        }
        if (!second.missingIngredients && first.missingIngredients) {
            return second;
        }
        if (!first.missingUtensils && second.missingUtensils) {
            return first;
        }
        if (!second.missingUtensils && first.missingUtensils) {
            return second;
        }
        return first;
    }
}

