/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.item;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import net.blay09.mods.balm.api.DeferredObject;
import net.blay09.mods.balm.api.item.BalmItems;
import net.blay09.mods.cookingforblockheads.block.ModBlocks;
import net.blay09.mods.cookingforblockheads.item.ItemHeatingUnit;
import net.blay09.mods.cookingforblockheads.item.ItemIceUnit;
import net.blay09.mods.cookingforblockheads.item.ItemPreservationChamber;
import net.blay09.mods.cookingforblockheads.item.ItemRecipeBook;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class ModItems {
    public static DeferredObject<CreativeModeTab> creativeModeTab;
    public static Item recipeBook;
    public static Item noFilterBook;
    public static Item craftingBook;
    public static Item heatingUnit;
    public static Item iceUnit;
    public static Item preservationChamber;

    public static void initialize(BalmItems items) {
        items.registerItem(identifier -> {
            recipeBook = new ItemRecipeBook(ItemRecipeBook.RecipeBookEdition.RECIPE, ModItems.itemProperties(identifier));
            return recipeBook;
        }, ModItems.id("recipe_book"));
        items.registerItem(identifier -> {
            noFilterBook = new ItemRecipeBook(ItemRecipeBook.RecipeBookEdition.NO_FILTER, ModItems.itemProperties(identifier));
            return noFilterBook;
        }, ModItems.id("no_filter_edition"));
        items.registerItem(identifier -> {
            craftingBook = new ItemRecipeBook(ItemRecipeBook.RecipeBookEdition.CRAFTING, ModItems.itemProperties(identifier));
            return craftingBook;
        }, ModItems.id("crafting_book"));
        items.registerItem(identifier -> {
            heatingUnit = new ItemHeatingUnit(ModItems.itemProperties(identifier));
            return heatingUnit;
        }, ModItems.id("heating_unit"));
        items.registerItem(identifier -> {
            iceUnit = new ItemIceUnit(ModItems.itemProperties(identifier));
            return iceUnit;
        }, ModItems.id("ice_unit"));
        items.registerItem(identifier -> {
            preservationChamber = new ItemPreservationChamber(ModItems.itemProperties(identifier));
            return preservationChamber;
        }, ModItems.id("preservation_chamber"));
        creativeModeTab = items.registerCreativeModeTab(() -> new ItemStack((ItemLike)ModBlocks.cowJar), ModItems.id("cookingforblockheads"));
        items.setCreativeModeTabSorting(ModItems.id("cookingforblockheads"), (Comparator)new Comparator<ItemLike>(){
            private static final String[] patternStrings = new String[]{"recipe_book", "crafting_book", "cooking_table", "white_fridge", "white_oven", "sink", "counter", "cabinet", "connector", "white_kitchen_floor", "milk_jar", "cow_jar", "toaster", "tool_rack", "spice_rack", "fruit_basket", "cutting_board", "ice_unit", "preservation_chamber", "heating_unit", "no_filter_edition", ".+_cooking_table", ".+_fridge", ".+_oven", ".+_sink", ".+_counter", ".+_cabinet", ".+_kitchen_floor", ".+_connector"};
            private static final Map<String, Integer> indexMap = new HashMap<String, Integer>();
            private static final Map<Pattern, Integer> patternIndexMap = new HashMap<Pattern, Integer>();

            private static int getIndex(String name) {
                Integer index = indexMap.get(name);
                if (index != null) {
                    return index;
                }
                for (Map.Entry<Pattern, Integer> entry : patternIndexMap.entrySet()) {
                    if (!entry.getKey().matcher(name).matches()) continue;
                    return entry.getValue();
                }
                return -1;
            }

            @Override
            public int compare(ItemLike o1, ItemLike o2) {
                ResourceLocation id1 = BuiltInRegistries.ITEM.getKey((Object)o1.asItem());
                ResourceLocation id2 = BuiltInRegistries.ITEM.getKey((Object)o2.asItem());
                String name1 = id1.getPath();
                String name2 = id2.getPath();
                int index1 = 1.getIndex(name1);
                int index2 = 1.getIndex(name2);
                if (index1 != -1 && index2 != -1) {
                    return Integer.compare(index1, index2);
                }
                if (index1 != -1) {
                    return -1;
                }
                if (index2 != -1) {
                    return 1;
                }
                return name1.compareTo(name2);
            }

            static {
                for (int i = 0; i < patternStrings.length; ++i) {
                    String patternString = patternStrings[i];
                    indexMap.put(patternString, i);
                    patternIndexMap.put(Pattern.compile(patternString), i);
                }
            }
        });
    }

    private static Item.Properties itemProperties(ResourceLocation identifier) {
        return new Item.Properties().setId(ModItems.itemId(identifier));
    }

    private static ResourceKey<Item> itemId(ResourceLocation identifier) {
        return ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)identifier);
    }

    private static ResourceLocation id(String name) {
        return ResourceLocation.fromNamespaceAndPath((String)"cookingforblockheads", (String)name);
    }
}

