/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.menu;

import net.blay09.mods.cookingforblockheads.block.entity.FruitBasketBlockEntity;
import net.blay09.mods.cookingforblockheads.menu.ModMenus;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;

public class FruitBasketMenu
extends AbstractContainerMenu {
    private final FruitBasketBlockEntity fruitBasket;
    private final int numRows;

    public FruitBasketMenu(int windowId, Inventory playerInventory, FruitBasketBlockEntity fruitBasket) {
        super((MenuType)ModMenus.fruitBasket.get(), windowId);
        int j;
        int i;
        this.fruitBasket = fruitBasket;
        this.numRows = fruitBasket.getContainer().getContainerSize() / 9;
        int playerInventoryStart = this.numRows * 18;
        for (i = 0; i < this.numRows; ++i) {
            for (j = 0; j < 9; ++j) {
                this.addSlot(new Slot(fruitBasket.getContainer(), j + i * 9, 8 + j * 18, 18 + i * 18));
            }
        }
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 9; ++j) {
                this.addSlot(new Slot((Container)playerInventory, j + i * 9 + 9, 8 + j * 18, 31 + i * 18 + playerInventoryStart));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)playerInventory, i, 8 + i * 18, 89 + playerInventoryStart));
        }
    }

    public ItemStack quickMoveStack(Player player, int slotIndex) {
        ItemStack itemStack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(slotIndex);
        if (slot != null && slot.hasItem()) {
            ItemStack slotStack = slot.getItem();
            itemStack = slotStack.copy();
            if (slotIndex < this.numRows * 9 ? !this.moveItemStackTo(slotStack, this.numRows * 9, this.slots.size(), true) : !this.moveItemStackTo(slotStack, 0, this.numRows * 9, false)) {
                return ItemStack.EMPTY;
            }
            if (slotStack.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
        }
        return itemStack;
    }

    public boolean stillValid(Player player) {
        return Container.stillValidBlockEntity((BlockEntity)this.fruitBasket, (Player)player);
    }

    public int getNumRows() {
        return this.numRows;
    }
}

