/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.menu;

import com.google.common.collect.Multimap;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.container.DefaultContainer;
import net.blay09.mods.cookingforblockheads.CookingForBlockheads;
import net.blay09.mods.cookingforblockheads.api.CookingForBlockheadsAPI;
import net.blay09.mods.cookingforblockheads.api.Kitchen;
import net.blay09.mods.cookingforblockheads.api.KitchenRecipeGroup;
import net.blay09.mods.cookingforblockheads.api.KitchenRecipeHandler;
import net.blay09.mods.cookingforblockheads.crafting.CraftableWithStatus;
import net.blay09.mods.cookingforblockheads.crafting.CraftingContext;
import net.blay09.mods.cookingforblockheads.crafting.CraftingOperation;
import net.blay09.mods.cookingforblockheads.crafting.KitchenImpl;
import net.blay09.mods.cookingforblockheads.crafting.RecipeWithStatus;
import net.blay09.mods.cookingforblockheads.menu.comparator.ComparatorName;
import net.blay09.mods.cookingforblockheads.menu.comparator.FavoriteComparator;
import net.blay09.mods.cookingforblockheads.menu.slot.AbstractFakeSlot;
import net.blay09.mods.cookingforblockheads.menu.slot.CraftMatrixFakeSlot;
import net.blay09.mods.cookingforblockheads.menu.slot.CraftableListingFakeSlot;
import net.blay09.mods.cookingforblockheads.network.message.AvailableCraftablesListMessage;
import net.blay09.mods.cookingforblockheads.network.message.CraftRecipeMessage;
import net.blay09.mods.cookingforblockheads.network.message.KitchenFeedbackMessage;
import net.blay09.mods.cookingforblockheads.network.message.RequestAvailableCraftablesMessage;
import net.blay09.mods.cookingforblockheads.network.message.RequestSelectionRecipesMessage;
import net.blay09.mods.cookingforblockheads.network.message.SelectionRecipesListMessage;
import net.blay09.mods.cookingforblockheads.registry.CookingForBlockheadsRegistry;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.display.FurnaceRecipeDisplay;
import net.minecraft.world.item.crafting.display.RecipeDisplay;
import net.minecraft.world.item.crafting.display.RecipeDisplayEntry;
import net.minecraft.world.item.crafting.display.RecipeDisplayId;
import net.minecraft.world.item.crafting.display.ShapedCraftingRecipeDisplay;
import net.minecraft.world.item.crafting.display.ShapelessCraftingRecipeDisplay;
import net.minecraft.world.item.crafting.display.SlotDisplay;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class KitchenMenu
extends AbstractContainerMenu {
    public final Player player;
    private final KitchenImpl kitchen;
    private final List<CraftableListingFakeSlot> recipeListingSlots = new ArrayList<CraftableListingFakeSlot>();
    private final List<CraftMatrixFakeSlot> matrixSlots = new ArrayList<CraftMatrixFakeSlot>();
    private final NonNullList<ItemStack> lockedInputs = NonNullList.withSize((int)9, (Object)ItemStack.EMPTY);
    private final List<CraftableWithStatus> filteredCraftables = new ArrayList<CraftableWithStatus>();
    private final List<CraftableWithStatus> history = new ArrayList<CraftableWithStatus>();
    private String currentSearch;
    private Comparator<CraftableWithStatus> currentSorting = new FavoriteComparator(new ComparatorName());
    private List<CraftableWithStatus> craftables = new ArrayList<CraftableWithStatus>();
    private boolean craftablesDirty = true;
    private boolean recipesDirty = true;
    private boolean scrollOffsetDirty;
    private int scrollOffset;
    private CraftableWithStatus selectedCraftable;
    private List<RecipeWithStatus> recipesForSelection;
    private int recipesForSelectionIndex;

    public KitchenMenu(MenuType<KitchenMenu> containerType, int windowId, Player player, KitchenImpl kitchen) {
        super(containerType, windowId);
        AbstractFakeSlot slot;
        int j;
        int i;
        this.player = player;
        this.kitchen = kitchen;
        DefaultContainer fakeInventory = new DefaultContainer(21);
        for (i = 0; i < 4; ++i) {
            for (j = 0; j < 3; ++j) {
                slot = new CraftableListingFakeSlot((Container)fakeInventory, j + i * 3, 102 + j * 18, 11 + i * 18);
                this.recipeListingSlots.add((CraftableListingFakeSlot)slot);
                this.addSlot(slot);
            }
        }
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 3; ++j) {
                slot = new CraftMatrixFakeSlot(this, (Container)fakeInventory, j + i * 3, 24 + j * 18, 20 + i * 18);
                this.matrixSlots.add((CraftMatrixFakeSlot)slot);
                this.addSlot(slot);
            }
        }
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 9; ++j) {
                this.addSlot(new Slot((Container)player.getInventory(), j + i * 9 + 9, 8 + j * 18, 92 + i * 18){

                    public void setChanged() {
                        KitchenMenu.this.craftablesDirty = true;
                        KitchenMenu.this.recipesDirty = true;
                    }
                });
            }
        }
        for (i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)player.getInventory(), i, 8 + i * 18, 150){

                public void setChanged() {
                    KitchenMenu.this.craftablesDirty = true;
                    KitchenMenu.this.recipesDirty = true;
                }
            });
        }
    }

    public void clicked(int slotNumber, int dragType, ClickType clickType, Player player) {
        Slot slot;
        boolean handled = false;
        if (slotNumber >= 0 && slotNumber < this.slots.size() && (slot = (Slot)this.slots.get(slotNumber)) instanceof CraftableListingFakeSlot) {
            CraftableListingFakeSlot craftableSlot = (CraftableListingFakeSlot)slot;
            if (player.level().isClientSide()) {
                if (this.isSelectedSlot(craftableSlot)) {
                    if (clickType == ClickType.PICKUP || clickType == ClickType.PICKUP_ALL || clickType == ClickType.QUICK_MOVE || clickType == ClickType.CLONE) {
                        this.requestCraft(clickType == ClickType.QUICK_MOVE, clickType == ClickType.CLONE);
                        handled = true;
                    }
                } else {
                    this.clearHistory();
                    this.selectCraftable(craftableSlot.getCraftable());
                    handled = true;
                }
            }
        }
        if (!handled) {
            super.clicked(slotNumber, dragType, clickType, player);
        }
    }

    public void broadcastChanges() {
        super.broadcastChanges();
        if (this.craftablesDirty) {
            this.broadcastAvailableRecipes();
            this.craftablesDirty = false;
        }
        if (this.recipesDirty) {
            if (this.selectedCraftable != null) {
                this.broadcastRecipesForResultItem(this.selectedCraftable.itemStack());
            }
            this.recipesDirty = false;
        }
    }

    public boolean stillValid(Player player) {
        return true;
    }

    public void slotsChanged(Container inventory) {
    }

    public ItemStack quickMoveStack(Player player, int slotIndex) {
        ItemStack itemStack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(slotIndex);
        if (slot != null && slot.hasItem()) {
            ItemStack slotStack = slot.getItem();
            itemStack = slotStack.copy();
            if (slotIndex >= 48 && slotIndex < 57 ? !this.moveItemStackTo(slotStack, 21, 48, true) : slotIndex >= 21 && slotIndex < 48 && !this.moveItemStackTo(slotStack, 48, 57, false)) {
                return ItemStack.EMPTY;
            }
            if (slotStack.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
        }
        return itemStack;
    }

    public void selectCraftable(@Nullable CraftableWithStatus recipe) {
        this.selectedCraftable = recipe;
        this.resetSelectedRecipe();
        this.updateCraftableSlots();
        if (recipe != null) {
            if (this.player.level().isClientSide()) {
                this.lockedInputs.clear();
                this.requestSelectionRecipes(recipe);
            }
        } else {
            this.resetSelectedRecipe();
            this.updateMatrixSlots();
        }
    }

    public void resetSelectedRecipe() {
        this.recipesForSelection = null;
        this.recipesForSelectionIndex = 0;
        this.updateMatrixSlots();
    }

    public void requestCraftables() {
        Balm.getNetworking().sendToServer((CustomPacketPayload)new RequestAvailableCraftablesMessage());
    }

    public void handleRequestCraftables() {
        this.craftablesDirty = true;
    }

    public void requestSelectionRecipes(CraftableWithStatus craftable) {
        Balm.getNetworking().sendToServer((CustomPacketPayload)new RequestSelectionRecipesMessage(craftable.itemStack(), (List<ItemStack>)this.lockedInputs));
    }

    public void handleRequestSelectionRecipes(ItemStack resultItem, List<ItemStack> lockedInputs) {
        this.selectedCraftable = this.findCraftableForResultItem(resultItem);
        this.lockedInputs.clear();
        for (int i = 0; i < lockedInputs.size(); ++i) {
            this.lockedInputs.set(i, (Object)lockedInputs.get(i));
        }
        this.recipesDirty = true;
    }

    private void requestCraft(boolean craftFullStack, boolean addToInventory) {
        RecipeWithStatus selectedRecipe = this.getSelectedRecipe();
        if (selectedRecipe != null) {
            Balm.getNetworking().sendToServer((CustomPacketPayload)new CraftRecipeMessage(selectedRecipe.recipeDisplayEntry().id(), (List<ItemStack>)this.lockedInputs, craftFullStack, addToInventory));
        }
    }

    public List<CraftableWithStatus> getAvailableCraftables() {
        HashMap<ResourceLocation, CraftableWithStatus> result = new HashMap<ResourceLocation, CraftableWithStatus>();
        CraftingContext context = new CraftingContext(this.kitchen, this.player);
        Multimap<ResourceLocation, RecipeHolder<?>> recipesByItemId = CookingForBlockheadsRegistry.getRecipesByItemId();
        for (ResourceLocation itemId : recipesByItemId.keySet()) {
            for (RecipeHolder recipeHolder : recipesByItemId.get((Object)itemId)) {
                CraftableWithStatus craftableWithStatus = this.craftableWithStatusFromRecipe(context, recipeHolder);
                if (craftableWithStatus == null) continue;
                result.compute(itemId, (k, v) -> CraftableWithStatus.best(v, craftableWithStatus));
            }
        }
        return result.values().stream().toList();
    }

    @Nullable
    private <C extends RecipeInput, T extends Recipe<C>> CraftableWithStatus craftableWithStatusFromRecipe(CraftingContext context, RecipeHolder<?> recipeHolder) {
        Recipe recipe = recipeHolder.value();
        KitchenRecipeHandler recipeHandler = CookingForBlockheadsAPI.getKitchenRecipeHandler(recipe);
        ItemStack resultItem = recipeHandler.predictResultItem((Recipe)recipeHolder);
        if (this.isGroupItem(resultItem)) {
            return null;
        }
        CraftingOperation operation = context.createOperation(recipeHolder).prepare();
        if (!this.kitchen.isRecipeAvailable(operation)) {
            return null;
        }
        List<Ingredient> missingIngredients = operation.getMissingIngredients();
        List<Ingredient> missingUtensils = operation.getMissingIngredients();
        return new CraftableWithStatus(resultItem, !missingIngredients.isEmpty(), !missingUtensils.isEmpty());
    }

    private boolean isGroupItem(ItemStack resultItem) {
        ResourceLocation itemId = BuiltInRegistries.ITEM.getKey((Object)resultItem.getItem());
        for (KitchenRecipeGroup group : CookingForBlockheadsRegistry.getGroups()) {
            ResourceLocation groupItemId = BuiltInRegistries.ITEM.getKey((Object)group.getParentItem());
            if (groupItemId.equals((Object)itemId)) continue;
            for (Ingredient ingredient : group.getChildren()) {
                if (!ingredient.test(resultItem)) continue;
                return true;
            }
        }
        return false;
    }

    private Collection<RecipeHolder<?>> getRecipesFor(ItemStack resultItem) {
        ArrayList recipes = new ArrayList(CookingForBlockheadsRegistry.getRecipesFor(resultItem));
        recipes.addAll(CookingForBlockheadsRegistry.getRecipesInGroup(resultItem));
        return recipes;
    }

    public void broadcastAvailableRecipes() {
        this.craftables = this.getAvailableCraftables();
        Balm.getNetworking().sendTo(this.player, (CustomPacketPayload)new AvailableCraftablesListMessage(this.craftables));
    }

    public void broadcastRecipesForResultItem(ItemStack resultItem) {
        ArrayList<RecipeWithStatus> result = new ArrayList<RecipeWithStatus>();
        RecipeManager recipeManager = this.player.level().getServer().getRecipeManager();
        CraftingContext context = new CraftingContext(this.kitchen, this.player);
        Collection<RecipeHolder<?>> recipesForResult = this.getRecipesFor(resultItem);
        for (RecipeHolder<?> recipe : recipesForResult) {
            CraftingOperation operation = context.createOperation(recipe).withLockedInputs(this.lockedInputs).prepare();
            recipeManager.listDisplaysForRecipe(recipe.id(), recipeDisplayEntry -> result.add(new RecipeWithStatus((RecipeDisplayEntry)recipeDisplayEntry, operation.getMissingIngredients(), operation.getMissingIngredientsMask(), (List<ItemStack>)operation.getLockedInputs())));
        }
        this.recipesForSelection = result;
        Balm.getNetworking().sendTo(this.player, (CustomPacketPayload)new SelectionRecipesListMessage(result));
    }

    public void craft(RecipeDisplayId recipeDisplayId, NonNullList<ItemStack> lockedInputs, boolean craftFullStack, boolean addToInventory) {
        Level level = this.player.level();
        RecipeManager.ServerDisplayInfo serverDisplayInfo = level.getServer().getRecipeManager().getRecipeFromDisplay(recipeDisplayId);
        if (serverDisplayInfo == null) {
            CookingForBlockheads.logger.error("Received invalid recipe from client: {}", (Object)recipeDisplayId);
            return;
        }
        RecipeHolder recipe = serverDisplayInfo.parent();
        if (!this.kitchen.canProcess(recipe.value().getType())) {
            CookingForBlockheads.logger.error("Received invalid craft request, unprocessable recipe {}", (Object)recipeDisplayId);
            return;
        }
        CraftingContext context = new CraftingContext(this.kitchen, this.player);
        context.addListener(operation -> {
            Optional<Component> feedback = operation.getFeedback();
            feedback.ifPresent(component -> Balm.getNetworking().sendTo(this.player, (CustomPacketPayload)new KitchenFeedbackMessage((Component)component)));
        });
        CraftingOperation operation2 = context.createOperation(recipe).withLockedInputs(lockedInputs);
        KitchenRecipeHandler recipeHandler = CookingForBlockheadsAPI.getKitchenRecipeHandler(recipe.value());
        ItemStack resultItem = recipeHandler.predictResultItem((Recipe)recipe);
        int repeats = craftFullStack ? resultItem.getMaxStackSize() / resultItem.getCount() : 1;
        for (int i = 0; i < repeats; ++i) {
            ItemStack itemStack;
            operation2.prepare();
            if (!operation2.canCraft()) break;
            ItemStack carried = this.getCarried();
            if (!(carried.isEmpty() || ItemStack.isSameItemSameComponents((ItemStack)carried, (ItemStack)resultItem) && carried.getCount() < carried.getMaxStackSize())) {
                if (!craftFullStack && !addToInventory) break;
                addToInventory = true;
            }
            if ((itemStack = operation2.craft(this, this.player.level().registryAccess())).isEmpty()) break;
            if (addToInventory) {
                if (this.player.getInventory().add(itemStack)) continue;
                this.player.drop(itemStack, false);
                continue;
            }
            if (carried.isEmpty()) {
                this.setCarried(itemStack);
                continue;
            }
            if (ItemStack.isSameItemSameComponents((ItemStack)carried, (ItemStack)itemStack) && carried.getCount() < carried.getMaxStackSize()) {
                carried.grow(itemStack.getCount());
                continue;
            }
            if (this.player.getInventory().add(itemStack)) continue;
            this.player.drop(itemStack, false);
        }
        this.craftablesDirty = true;
        this.recipesDirty = true;
    }

    public void setCraftables(List<CraftableWithStatus> craftables) {
        int previousSelectionIndex = this.selectedCraftable != null ? this.filteredCraftables.indexOf(this.selectedCraftable) : -1;
        this.craftables = craftables;
        this.updateFilteredRecipes();
        if (previousSelectionIndex != -1) {
            Iterator<CraftableWithStatus> it = this.filteredCraftables.iterator();
            CraftableWithStatus found = null;
            while (it.hasNext()) {
                CraftableWithStatus recipe = it.next();
                if (!ItemStack.isSameItemSameComponents((ItemStack)recipe.itemStack(), (ItemStack)this.selectedCraftable.itemStack())) continue;
                found = recipe;
                it.remove();
                break;
            }
            while (previousSelectionIndex > this.filteredCraftables.size()) {
                this.filteredCraftables.add(null);
            }
            this.filteredCraftables.add(previousSelectionIndex, found);
            this.selectedCraftable = found;
        }
        this.updateCraftableSlots();
        this.setScrollOffsetDirty(true);
    }

    public void updateCraftableSlots() {
        int i = this.scrollOffset * 3;
        for (CraftableListingFakeSlot slot : this.recipeListingSlots) {
            if (i < this.filteredCraftables.size()) {
                CraftableWithStatus craftable = this.filteredCraftables.get(i);
                slot.setCraftable(craftable);
                ++i;
                continue;
            }
            slot.setCraftable(null);
        }
    }

    private void updateMatrixSlots() {
        RecipeWithStatus selectedRecipe = this.getSelectedRecipe();
        if (selectedRecipe != null) {
            this.updateMatrixSlots(selectedRecipe);
        } else {
            for (int i = 0; i < this.matrixSlots.size(); ++i) {
                CraftMatrixFakeSlot matrixSlot = this.matrixSlots.get(i);
                matrixSlot.setIngredient(i, null, ItemStack.EMPTY);
                matrixSlot.setMissing(true);
            }
        }
    }

    private void updateMatrixSlots(RecipeWithStatus recipe) {
        RecipeDisplay recipeDisplay = recipe.recipeDisplayEntry().display();
        NonNullList matrix = NonNullList.withSize((int)9, (Object)SlotDisplay.Empty.INSTANCE);
        boolean[] missingMatrix = new boolean[9];
        int[] ingredientIndexMatrix = new int[9];
        RecipeDisplay recipeDisplay2 = recipeDisplay;
        Objects.requireNonNull(recipeDisplay2);
        RecipeDisplay recipeDisplay3 = recipeDisplay2;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ShapedCraftingRecipeDisplay.class, ShapelessCraftingRecipeDisplay.class, FurnaceRecipeDisplay.class}, (Object)recipeDisplay3, n)) {
            case 0: {
                ShapedCraftingRecipeDisplay shapedCraftingRecipeDisplay = (ShapedCraftingRecipeDisplay)recipeDisplay3;
                List ingredients = shapedCraftingRecipeDisplay.ingredients();
                int i = 0;
                while (i < ingredients.size()) {
                    SlotDisplay ingredient = (SlotDisplay)ingredients.get(i);
                    int recipeWidth = shapedCraftingRecipeDisplay.width();
                    int origX = i % recipeWidth;
                    int origY = i / recipeWidth;
                    int offsetX = recipeWidth == 1 ? 1 : 0;
                    int matrixSlot = origY * 3 + origX + offsetX;
                    matrix.set(matrixSlot, (Object)ingredient);
                    missingMatrix[matrixSlot] = (recipe.missingIngredientsMask() & 1 << i) == 1 << i;
                    ingredientIndexMatrix[matrixSlot] = i++;
                }
                break;
            }
            case 1: {
                ShapelessCraftingRecipeDisplay shapelessCraftingRecipeDisplay = (ShapelessCraftingRecipeDisplay)recipeDisplay3;
                List ingredients = shapelessCraftingRecipeDisplay.ingredients();
                for (int i = 0; i < ingredients.size(); ++i) {
                    SlotDisplay ingredient = (SlotDisplay)ingredients.get(i);
                    matrix.set(i, (Object)ingredient);
                    missingMatrix[i] = (recipe.missingIngredientsMask() & 1 << i) == 1 << i;
                    ingredientIndexMatrix[i] = i;
                }
                break;
            }
            case 2: {
                FurnaceRecipeDisplay furnaceRecipeDisplay = (FurnaceRecipeDisplay)recipeDisplay3;
                SlotDisplay ingredient = furnaceRecipeDisplay.ingredient();
                int matrixSlot = 4;
                matrix.set(4, (Object)ingredient);
                missingMatrix[4] = (recipe.missingIngredientsMask() & 1) == 1;
                ingredientIndexMatrix[4] = 0;
                break;
            }
        }
        for (int i = 0; i < this.matrixSlots.size(); ++i) {
            CraftMatrixFakeSlot matrixSlot = this.matrixSlots.get(i);
            List<ItemStack> lockedInputs = recipe.lockedInputs();
            int ingredientIndex = ingredientIndexMatrix[i];
            ItemStack lockedInput = lockedInputs.get(ingredientIndex);
            matrixSlot.setIngredient(ingredientIndex, (SlotDisplay)matrix.get(i), lockedInput);
            matrixSlot.setMissing(missingMatrix[i]);
        }
    }

    public void setSortComparator(Comparator<CraftableWithStatus> comparator) {
        this.currentSorting = new FavoriteComparator(comparator);
        this.filteredCraftables.removeIf(Objects::isNull);
        this.filteredCraftables.sort(this.currentSorting);
        this.updateCraftableSlots();
    }

    public int getItemListCount() {
        return this.filteredCraftables.size();
    }

    public void setScrollOffset(int scrollOffset) {
        this.scrollOffset = scrollOffset;
        this.updateCraftableSlots();
    }

    public void search(@Nullable String term) {
        this.currentSearch = term;
        this.updateFilteredRecipes();
        this.setScrollOffset(0);
    }

    private void updateFilteredRecipes() {
        this.filteredCraftables.clear();
        for (CraftableWithStatus craftable : this.craftables) {
            if (!this.searchMatches(craftable.itemStack())) continue;
            this.filteredCraftables.add(craftable);
        }
        this.filteredCraftables.sort(this.currentSorting);
    }

    private boolean searchMatches(ItemStack resultItem) {
        if (this.currentSearch == null || this.currentSearch.trim().isEmpty()) {
            return true;
        }
        String lowerCaseSearch = this.currentSearch.toLowerCase();
        if (resultItem.getDisplayName().getString().toLowerCase(Locale.ENGLISH).contains(lowerCaseSearch)) {
            return true;
        }
        List tooltips = resultItem.getTooltipLines(Item.TooltipContext.EMPTY, this.player, (TooltipFlag)TooltipFlag.Default.NORMAL);
        for (Component tooltip : tooltips) {
            if (!tooltip.getString().toLowerCase(Locale.ENGLISH).contains(lowerCaseSearch)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public RecipeWithStatus getSelectedRecipe() {
        return this.recipesForSelection != null ? this.recipesForSelection.get(this.recipesForSelectionIndex) : null;
    }

    public boolean isSelectedSlot(CraftableListingFakeSlot slot) {
        return this.selectedCraftable != null && slot.getCraftable() != null && ItemStack.isSameItemSameComponents((ItemStack)slot.getCraftable().itemStack(), (ItemStack)this.selectedCraftable.itemStack());
    }

    public boolean isScrollOffsetDirty() {
        return this.scrollOffsetDirty;
    }

    public void setScrollOffsetDirty(boolean dirty) {
        this.scrollOffsetDirty = dirty;
    }

    public void setRecipesForSelection(List<RecipeWithStatus> recipes) {
        this.recipesForSelection = !recipes.isEmpty() ? recipes : null;
        this.recipesForSelectionIndex = this.recipesForSelection != null ? Math.max(0, Math.min(this.recipesForSelection.size() - 1, this.recipesForSelectionIndex)) : 0;
        this.updateMatrixSlots();
    }

    public void nextRecipe(int dir) {
        if (this.recipesForSelection != null) {
            this.recipesForSelectionIndex = Math.max(0, Math.min(this.recipesForSelection.size() - 1, this.recipesForSelectionIndex + dir));
            this.updateCraftableSlots();
        }
        this.updateMatrixSlots();
    }

    public boolean selectionHasRecipeVariants() {
        return this.recipesForSelection != null && this.recipesForSelection.size() > 1;
    }

    public boolean selectionHasPreviousRecipe() {
        return this.recipesForSelectionIndex > 0;
    }

    public boolean selectionHasNextRecipe() {
        return this.recipesForSelection != null && this.recipesForSelectionIndex < this.recipesForSelection.size() - 1;
    }

    public List<CraftMatrixFakeSlot> getMatrixSlots() {
        return this.matrixSlots;
    }

    @Nullable
    public CraftableWithStatus findCraftableForResultItem(ItemStack resultItem) {
        return this.craftables.stream().filter(it -> ItemStack.isSameItemSameComponents((ItemStack)it.itemStack(), (ItemStack)resultItem)).findAny().orElse(null);
    }

    public Kitchen getKitchen() {
        return this.kitchen;
    }

    public void setLockedInput(int i, ItemStack lockedInput) {
        this.lockedInputs.set(i, (Object)lockedInput);
        if (this.selectedCraftable != null) {
            this.requestSelectionRecipes(this.selectedCraftable);
        }
    }

    public int getRecipesForSelectionIndex() {
        return this.filteredCraftables.indexOf(this.selectedCraftable);
    }

    public void clearHistory() {
        this.history.clear();
    }

    public void pushHistory() {
        if (this.selectedCraftable != null) {
            this.history.add(this.selectedCraftable);
        }
    }

    public void popHistory() {
        if (!this.history.isEmpty()) {
            CraftableWithStatus entry = this.history.removeLast();
            this.selectCraftable(entry);
        }
    }
}

