/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.blay09.mods.cookingforblockheads.recipe.ModRecipes;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.PlacementInfo;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeBookCategory;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.Level;

public class OvenRecipe
implements Recipe<SingleRecipeInput> {
    private final Ingredient ingredient;
    private final ItemStack resultItem;

    public OvenRecipe(Ingredient ingredient, ItemStack resultItem) {
        this.ingredient = ingredient;
        this.resultItem = resultItem;
    }

    public boolean matches(SingleRecipeInput recipeInput, Level level) {
        return this.ingredient.test(recipeInput.item());
    }

    public ItemStack assemble(SingleRecipeInput recipeInput, HolderLookup.Provider provider) {
        return this.resultItem.copy();
    }

    public RecipeSerializer<OvenRecipe> getSerializer() {
        return ModRecipes.ovenRecipeSerializer;
    }

    public RecipeType<OvenRecipe> getType() {
        return ModRecipes.ovenRecipeType;
    }

    public PlacementInfo placementInfo() {
        return PlacementInfo.create((Ingredient)this.ingredient);
    }

    public RecipeBookCategory recipeBookCategory() {
        return ModRecipes.ovenRecipeBookCategory;
    }

    static class Serializer
    implements RecipeSerializer<OvenRecipe> {
        private static final MapCodec<ItemStack> RESULT_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BuiltInRegistries.ITEM.holderByNameCodec().fieldOf("item").orElse((Object)BuiltInRegistries.ITEM.wrapAsHolder((Object)Items.AIR)).forGetter(ItemStack::getItemHolder), (App)ExtraCodecs.POSITIVE_INT.fieldOf("count").orElse((Object)1).forGetter(ItemStack::getCount), (App)DataComponentPatch.CODEC.optionalFieldOf("components", (Object)DataComponentPatch.EMPTY).forGetter(ItemStack::getComponentsPatch)).apply((Applicative)instance, ItemStack::new));
        private static final MapCodec<OvenRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Ingredient.CODEC.fieldOf("ingredient").forGetter(recipe -> recipe.ingredient), (App)RESULT_CODEC.fieldOf("result").forGetter(recipe -> recipe.resultItem)).apply((Applicative)instance, OvenRecipe::new));
        private static final StreamCodec<RegistryFriendlyByteBuf, OvenRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        Serializer() {
        }

        public MapCodec<OvenRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, OvenRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        private static OvenRecipe fromNetwork(RegistryFriendlyByteBuf buf) {
            Ingredient ingredient = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buf);
            ItemStack resultItem = (ItemStack)ItemStack.OPTIONAL_STREAM_CODEC.decode((Object)buf);
            return new OvenRecipe(ingredient, resultItem);
        }

        private static void toNetwork(RegistryFriendlyByteBuf buf, OvenRecipe recipe) {
            Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buf, (Object)recipe.ingredient);
            ItemStack.OPTIONAL_STREAM_CODEC.encode((Object)buf, (Object)recipe.resultItem);
        }
    }
}

