/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.cookingforblockheads.block.BaseKitchenBlock;
import net.blay09.mods.cookingforblockheads.block.ModBlocks;
import net.blay09.mods.cookingforblockheads.block.entity.FridgeBlockEntity;
import net.blay09.mods.cookingforblockheads.block.entity.ModBlockEntities;
import net.blay09.mods.cookingforblockheads.item.ModItems;
import net.minecraft.class_10225;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2498;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2746;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_3542;
import net.minecraft.class_3619;
import net.minecraft.class_3726;
import net.minecraft.class_3908;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5558;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;

public class FridgeBlock
extends BaseKitchenBlock {
    public static final MapCodec<FridgeBlock> CODEC = RecordCodecBuilder.mapCodec(it -> it.group((App)class_1767.field_41600.fieldOf("color").forGetter(FridgeBlock::getColor), (App)FridgeBlock.method_54096()).apply((Applicative)it, FridgeBlock::new));
    public static final class_2754<FridgeModelType> MODEL_TYPE = class_2754.method_11850((String)"model", FridgeModelType.class);
    public static final class_2746 PRESERVATION_CHAMBER = class_2746.method_11825((String)"preservation_chamber");
    public static final class_2746 ICE_UNIT = class_2746.method_11825((String)"ice_unit");
    private static final class_265 BOUNDING_BOX_X = class_2248.method_9541((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0);
    private static final class_265 BOUNDING_BOX_Z = class_2248.method_9541((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0);
    private final class_1767 color;

    public FridgeBlock(class_1767 color, class_4970.class_2251 properties) {
        super(properties.method_50012(class_3619.field_15972).method_9626(class_2498.field_11533).method_9629(5.0f, 10.0f));
        this.color = color;
        this.method_9590((class_2680)((class_2680)((class_2680)this.method_9595().method_11664()).method_11657((class_2769)PRESERVATION_CHAMBER, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)ICE_UNIT, (Comparable)Boolean.valueOf(false)));
    }

    public class_1767 getColor() {
        return this.color;
    }

    @Override
    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        if (((class_2350)state.method_11654((class_2769)FACING)).method_10166() == class_2350.class_2351.field_11048) {
            return BOUNDING_BOX_X;
        }
        return BOUNDING_BOX_Z;
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{FACING, MODEL_TYPE, FLIPPED, PRESERVATION_CHAMBER, ICE_UNIT});
    }

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new FridgeBlockEntity(pos, state);
    }

    protected class_1269 method_55765(class_1799 itemStack, class_2680 state, class_1937 level, class_2338 pos, class_1657 player, class_1268 hand, class_3965 blockHitResult) {
        if (itemStack.method_7960()) {
            return class_1269.field_52423;
        }
        class_2586 blockEntity = level.method_8321(pos);
        if (!(blockEntity instanceof FridgeBlockEntity)) {
            return class_1269.field_5814;
        }
        FridgeBlockEntity fridge = (FridgeBlockEntity)blockEntity;
        if (itemStack.method_7909() == ModItems.preservationChamber || itemStack.method_7909() == ModItems.iceUnit) {
            return class_1269.field_5811;
        }
        if (this.tryRecolorBlock(state, itemStack, level, pos, player, blockHitResult)) {
            return class_1269.field_5812;
        }
        class_2350 frontFace = (class_2350)state.method_11654((class_2769)FACING);
        if (blockHitResult.method_17780() == frontFace && fridge.getBaseFridge().getDoorAnimator().isForcedOpen()) {
            itemStack = fridge.insertItemStacked(itemStack, false);
            player.method_6122(hand, itemStack);
            return class_1269.field_5812;
        }
        if (class_2248.method_9503((class_1792)itemStack.method_7909()) instanceof FridgeBlock && blockHitResult.method_17780() != frontFace) {
            return class_1269.field_5814;
        }
        return super.method_55765(itemStack, state, level, pos, player, hand, blockHitResult);
    }

    public class_1269 method_55766(class_2680 state, class_1937 level, class_2338 pos, class_1657 player, class_3965 blockHitResult) {
        class_2586 blockEntity = level.method_8321(pos);
        if (!(blockEntity instanceof FridgeBlockEntity)) {
            return class_1269.field_5814;
        }
        FridgeBlockEntity fridge = (FridgeBlockEntity)blockEntity;
        class_2350 frontFace = (class_2350)state.method_11654((class_2769)FACING);
        if (blockHitResult.method_17780() == frontFace && player.method_5715()) {
            fridge.getBaseFridge().getDoorAnimator().toggleForcedOpen();
            return class_1269.field_5812;
        }
        if (!level.method_8608()) {
            Balm.getNetworking().openMenu(player, (class_3908)fridge);
        }
        return class_1269.field_5812;
    }

    public boolean method_9558(class_2680 state, class_4538 level, class_2338 pos) {
        boolean below = level.method_8320(pos.method_10074()).method_26204() == this;
        boolean above = level.method_8320(pos.method_10084()).method_26204() == this;
        return !(below && above || below && level.method_8320(pos.method_10087(2)).method_26204() == this || above && level.method_8320(pos.method_10086(2)).method_26204() == this || !super.method_9558(state, level, pos));
    }

    @Override
    public class_2680 method_9605(class_1750 context) {
        class_2680 state = super.method_9605(context);
        class_1937 level = context.method_8045();
        class_2338 pos = context.method_8037();
        class_2338 posBelow = pos.method_10074();
        class_2680 stateBelow = level.method_8320(posBelow);
        class_2338 posAbove = pos.method_10084();
        class_2680 stateAbove = level.method_8320(posAbove);
        if (stateBelow.method_26204() == this && stateBelow.method_11654(MODEL_TYPE) == FridgeModelType.SMALL) {
            state = (class_2680)state.method_11657(MODEL_TYPE, (Comparable)((Object)FridgeModelType.LARGE_UPPER));
        } else if (stateAbove.method_26204() == this && stateAbove.method_11654(MODEL_TYPE) == FridgeModelType.SMALL) {
            state = (class_2680)state.method_11657(MODEL_TYPE, (Comparable)((Object)FridgeModelType.LARGE_LOWER));
        }
        return (class_2680)state.method_11657((class_2769)FLIPPED, (Comparable)Boolean.valueOf(this.shouldBePlacedFlipped(context, (class_2350)state.method_11654((class_2769)FACING))));
    }

    protected class_2680 method_9559(class_2680 state, class_4538 level, class_10225 scheduledTickAccess, class_2338 pos, class_2350 facing, class_2338 facingPos, class_2680 facingState, class_5819 randomSource) {
        class_2338 posBelow = pos.method_10074();
        class_2680 stateBelow = level.method_8320(posBelow);
        class_2338 posAbove = pos.method_10084();
        class_2680 stateAbove = level.method_8320(posAbove);
        if (stateBelow.method_26204() == this && stateBelow.method_11654(MODEL_TYPE) == FridgeModelType.LARGE_LOWER) {
            return (class_2680)((class_2680)state.method_11657(MODEL_TYPE, (Comparable)((Object)FridgeModelType.LARGE_UPPER))).method_11657((class_2769)FACING, (Comparable)((class_2350)stateBelow.method_11654((class_2769)FACING)));
        }
        if (stateAbove.method_26204() == this && stateAbove.method_11654(MODEL_TYPE) == FridgeModelType.LARGE_UPPER) {
            return (class_2680)state.method_11657(MODEL_TYPE, (Comparable)((Object)FridgeModelType.LARGE_LOWER));
        }
        if (state.method_11654(MODEL_TYPE) == FridgeModelType.LARGE_LOWER && stateAbove.method_26204() != this) {
            return (class_2680)state.method_11657(MODEL_TYPE, (Comparable)((Object)FridgeModelType.SMALL));
        }
        if (state.method_11654(MODEL_TYPE) == FridgeModelType.LARGE_UPPER && stateBelow.method_26204() != this) {
            return (class_2680)state.method_11657(MODEL_TYPE, (Comparable)((Object)FridgeModelType.SMALL));
        }
        return super.method_9559(state, level, scheduledTickAccess, pos, facing, facingPos, facingState, randomSource);
    }

    @Nullable
    public <T extends class_2586> class_5558<T> method_31645(class_1937 level, class_2680 state, class_2591<T> type) {
        return level.method_8608() ? FridgeBlock.method_31618(type, (class_2591)((class_2591)ModBlockEntities.fridge.get()), FridgeBlockEntity::clientTick) : FridgeBlock.method_31618(type, (class_2591)((class_2591)ModBlockEntities.fridge.get()), FridgeBlockEntity::serverTick);
    }

    @Override
    protected boolean recolorBlock(class_2680 state, class_1936 world, class_2338 pos, class_2350 facing, class_1767 color) {
        class_2586 blockEntity = world.method_8321(pos);
        if (blockEntity instanceof FridgeBlockEntity) {
            FridgeBlockEntity fridge = (FridgeBlockEntity)blockEntity;
            class_2338 bottomPos = fridge.getBaseFridge().method_11016();
            class_2338 topPos = bottomPos.method_10084();
            return super.recolorBlock(world.method_8320(bottomPos), world, bottomPos, facing, color) && super.recolorBlock(world.method_8320(topPos), world, topPos, facing, color);
        }
        return false;
    }

    protected MapCodec<? extends class_2237> method_53969() {
        return CODEC;
    }

    @Override
    protected class_2680 getDyedStateOf(class_2680 state, @Nullable class_1767 color) {
        FridgeBlock block = color == null ? ModBlocks.fridges[0] : ModBlocks.fridges[color.ordinal()];
        return (class_2680)((class_2680)((class_2680)((class_2680)block.method_9564().method_11657((class_2769)FACING, (Comparable)((class_2350)state.method_11654((class_2769)FACING)))).method_11657(MODEL_TYPE, (Comparable)((Object)((FridgeModelType)((Object)state.method_11654(MODEL_TYPE)))))).method_11657((class_2769)PRESERVATION_CHAMBER, (Comparable)((Boolean)state.method_11654((class_2769)PRESERVATION_CHAMBER)))).method_11657((class_2769)ICE_UNIT, (Comparable)((Boolean)state.method_11654((class_2769)ICE_UNIT)));
    }

    public static enum FridgeModelType implements class_3542
    {
        SMALL,
        LARGE_LOWER,
        LARGE_UPPER;


        public String method_15434() {
            return this.name().toLowerCase();
        }
    }
}

