/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Random;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.container.ContainerUtils;
import net.blay09.mods.cookingforblockheads.block.BaseKitchenBlock;
import net.blay09.mods.cookingforblockheads.block.ModBlocks;
import net.blay09.mods.cookingforblockheads.block.entity.ModBlockEntities;
import net.blay09.mods.cookingforblockheads.block.entity.OvenBlockEntity;
import net.blay09.mods.cookingforblockheads.item.ModItems;
import net.blay09.mods.cookingforblockheads.tag.ModItemTags;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1767;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2498;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2746;
import net.minecraft.class_2769;
import net.minecraft.class_3908;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_5558;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;

public class OvenBlock
extends BaseKitchenBlock {
    public static final MapCodec<OvenBlock> CODEC = RecordCodecBuilder.mapCodec(it -> it.group((App)class_1767.field_41600.fieldOf("color").forGetter(OvenBlock::getColor), (App)OvenBlock.method_54096()).apply((Applicative)it, OvenBlock::new));
    public static class_2746 ACTIVE = class_2746.method_11825((String)"active");
    private static final Random random = new Random();
    private final class_1767 color;

    public OvenBlock(class_1767 color, class_4970.class_2251 properties) {
        super(properties.method_9626(class_2498.field_11533).method_9629(5.0f, 10.0f));
        this.color = color;
        this.method_9590((class_2680)((class_2680)this.method_9595().method_11664()).method_11657((class_2769)ACTIVE, (Comparable)Boolean.valueOf(false)));
    }

    public class_1767 getColor() {
        return this.color;
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{FACING, ACTIVE});
    }

    protected class_1269 method_55765(class_1799 itemStack, class_2680 state, class_1937 level, class_2338 pos, class_1657 player, class_1268 hand, class_3965 blockHitResult) {
        if (itemStack.method_7960()) {
            return class_1269.field_52423;
        }
        class_2586 blockEntity = level.method_8321(pos);
        if (!(blockEntity instanceof OvenBlockEntity)) {
            return class_1269.field_5814;
        }
        OvenBlockEntity oven = (OvenBlockEntity)blockEntity;
        if (itemStack.method_7909() == ModItems.heatingUnit) {
            return class_1269.field_5811;
        }
        if (this.tryRecolorBlock(state, itemStack, level, pos, player, blockHitResult)) {
            return class_1269.field_5812;
        }
        if (blockHitResult.method_17780() == class_2350.field_11036 && itemStack.method_31573(ModItemTags.UTENSILS)) {
            OvenBlockEntity tileOven;
            class_2350 stateFacing = (class_2350)state.method_11654((class_2769)FACING);
            double hx = blockHitResult.method_17784().field_1352;
            double hz = blockHitResult.method_17784().field_1350;
            switch (stateFacing) {
                case field_11043: {
                    hx = 1.0 - blockHitResult.method_17784().field_1352;
                    hz = 1.0 - blockHitResult.method_17784().field_1350;
                    break;
                }
                case field_11039: {
                    hz = 1.0 - blockHitResult.method_17784().field_1352;
                    hx = blockHitResult.method_17784().field_1350;
                    break;
                }
                case field_11034: {
                    hz = blockHitResult.method_17784().field_1352;
                    hx = 1.0 - blockHitResult.method_17784().field_1350;
                }
            }
            int index = -1;
            if (hx < 0.5 && hz < 0.5) {
                index = 1;
            } else if (hx >= 0.5 && hz < 0.5) {
                index = 0;
            } else if (hx < 0.5 && hz >= 0.5) {
                index = 3;
            } else if (hx >= 0.5 && hz >= 0.5) {
                index = 2;
            }
            if (index != -1 && (tileOven = (OvenBlockEntity)level.method_8321(pos)) != null && tileOven.getToolItem(index).method_7960()) {
                class_1799 toolItem = itemStack.method_7971(1);
                tileOven.setToolItem(index, toolItem);
            }
            return class_1269.field_5812;
        }
        if (blockHitResult.method_17780() == state.method_11654((class_2769)FACING) && oven.getDoorAnimator().isForcedOpen()) {
            itemStack = ContainerUtils.insertItemStacked((class_1263)oven.getInputContainer(), (class_1799)itemStack, (boolean)false);
            if (!itemStack.method_7960()) {
                itemStack = ContainerUtils.insertItemStacked((class_1263)oven.getFuelContainer(), (class_1799)itemStack, (boolean)false);
            }
            player.method_6122(hand, itemStack);
            return class_1269.field_5812;
        }
        return super.method_55765(itemStack, state, level, pos, player, hand, blockHitResult);
    }

    public class_1269 method_55766(class_2680 state, class_1937 level, class_2338 pos, class_1657 player, class_3965 rayTraceResult) {
        class_2586 blockEntity = level.method_8321(pos);
        if (!(blockEntity instanceof OvenBlockEntity)) {
            return class_1269.field_5814;
        }
        OvenBlockEntity oven = (OvenBlockEntity)blockEntity;
        if (rayTraceResult.method_17780() == state.method_11654((class_2769)FACING) && player.method_5715()) {
            oven.getDoorAnimator().toggleForcedOpen();
            return class_1269.field_5812;
        }
        if (!level.method_8608()) {
            Balm.getNetworking().openMenu(player, (class_3908)oven);
        }
        return class_1269.field_5812;
    }

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new OvenBlockEntity(pos, state);
    }

    public void method_9496(class_2680 state, class_1937 level, class_2338 pos, class_5819 random) {
        OvenBlockEntity tileEntity = (OvenBlockEntity)level.method_8321(pos);
        if (tileEntity != null && tileEntity.isBurning()) {
            class_2350 facing = (class_2350)state.method_11654((class_2769)FACING);
            float x = (float)pos.method_10263() + 0.5f;
            float y = (float)pos.method_10264() + 0.0f + OvenBlock.random.nextFloat() * 6.0f / 16.0f;
            float z = (float)pos.method_10260() + 0.5f;
            float f3 = 0.52f;
            float f4 = OvenBlock.random.nextFloat() * 0.6f - 0.3f;
            if (facing == class_2350.field_11039) {
                level.method_8406((class_2394)class_2398.field_11251, (double)(x - f3), (double)y, (double)(z + f4), 0.0, 0.0, 0.0);
            } else if (facing == class_2350.field_11034) {
                level.method_8406((class_2394)class_2398.field_11251, (double)(x + f3), (double)y, (double)(z + f4), 0.0, 0.0, 0.0);
            } else if (facing == class_2350.field_11043) {
                level.method_8406((class_2394)class_2398.field_11251, (double)(x + f4), (double)y, (double)(z - f3), 0.0, 0.0, 0.0);
            } else if (facing == class_2350.field_11035) {
                level.method_8406((class_2394)class_2398.field_11251, (double)(x + f4), (double)y, (double)(z + f3), 0.0, 0.0, 0.0);
            }
        }
    }

    @Nullable
    public <T extends class_2586> class_5558<T> method_31645(class_1937 level, class_2680 state, class_2591<T> type) {
        return level.method_8608() ? OvenBlock.method_31618(type, (class_2591)((class_2591)ModBlockEntities.oven.get()), OvenBlockEntity::clientTick) : OvenBlock.method_31618(type, (class_2591)((class_2591)ModBlockEntities.oven.get()), OvenBlockEntity::serverTick);
    }

    protected MapCodec<? extends class_2237> method_53969() {
        return CODEC;
    }

    @Override
    protected class_2680 getDyedStateOf(class_2680 state, @Nullable class_1767 color) {
        OvenBlock block = color == null ? ModBlocks.ovens[0] : ModBlocks.ovens[color.ordinal()];
        return (class_2680)((class_2680)block.method_9564().method_11657((class_2769)FACING, (Comparable)((class_2350)state.method_11654((class_2769)FACING)))).method_11657((class_2769)ACTIVE, (Comparable)((Boolean)state.method_11654((class_2769)ACTIVE)));
    }
}

