/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.block.entity;

import net.blay09.mods.cookingforblockheads.CookingForBlockheadsConfig;
import net.blay09.mods.cookingforblockheads.block.entity.IMutableNameable;
import net.blay09.mods.cookingforblockheads.block.entity.MilkJarBlockEntity;
import net.blay09.mods.cookingforblockheads.block.entity.ModBlockEntities;
import net.blay09.mods.cookingforblockheads.compat.Compat;
import net.minecraft.class_10731;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2561;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_6880;
import net.minecraft.class_8824;
import net.minecraft.class_9323;
import net.minecraft.class_9334;
import net.minecraft.class_9473;
import org.jetbrains.annotations.Nullable;

public class CowJarBlockEntity
extends MilkJarBlockEntity
implements IMutableNameable {
    private static final int UPDATE_INTERVAL = 20;
    private boolean isDirty;
    private int ticksSinceUpdate;
    private class_2561 customName;
    private class_6880<class_10731> variant;
    private boolean compressedCow;
    private class_2338 jukebox;
    private int partyBpm;

    public CowJarBlockEntity(class_2338 pos, class_2680 state) {
        super((class_2591<? extends MilkJarBlockEntity>)((class_2591)ModBlockEntities.cowJar.get()), pos, state);
    }

    protected void method_57568(class_9473 input) {
        class_2561 customNameComponent = (class_2561)input.method_58694(class_9334.field_49631);
        if (customNameComponent != null) {
            this.customName = customNameComponent;
        }
    }

    protected void method_57567(class_9323.class_9324 builder) {
        builder.method_57840(class_9334.field_49631, (Object)this.customName);
    }

    @Override
    public void method_11014(class_11368 input) {
        super.method_11014(input);
        this.customName = input.method_71426("CustomNameV2", class_8824.field_46597).orElse(null);
        this.variant = input.method_71426("Variant", class_10731.field_56427).orElse(null);
        this.compressedCow = input.method_71433("CompressedCow", false);
    }

    @Override
    public void method_11007(class_11372 output) {
        super.method_11007(output);
        output.method_71477("CustomNameV2", class_8824.field_46597, (Object)this.customName);
        output.method_71477("Variant", class_10731.field_56427, this.variant);
        output.method_71472("CompressedCow", this.compressedCow);
    }

    public static void clientTick(class_1937 level, class_2338 pos, class_2680 state, CowJarBlockEntity blockEntity) {
        class_2338 jukebox = blockEntity.jukebox;
        if (jukebox == null || !jukebox.method_19769((class_2374)pos.method_46558(), (double)3.46f) || !level.method_8320(jukebox).method_27852(class_2246.field_10223)) {
            blockEntity.partyBpm = 0;
            blockEntity.jukebox = null;
        }
    }

    public static void serverTick(class_1937 level, class_2338 pos, class_2680 state, CowJarBlockEntity blockEntity) {
        blockEntity.serverTick(level, pos, state);
    }

    public void serverTick(class_1937 level, class_2338 pos, class_2680 state) {
        if (this.milkTank.getAmount() < 32000) {
            CookingForBlockheadsConfig config = CookingForBlockheadsConfig.getActive();
            int milkToAdd = config.cowJarMilkPerTick;
            if (this.compressedCow) {
                milkToAdd = (int)((double)milkToAdd * config.compressedCowJarMilkMultiplier);
            }
            this.milkTank.fill(Compat.getMilkFluid(), milkToAdd, false);
            this.isDirty = true;
        }
        ++this.ticksSinceUpdate;
        if (this.isDirty && this.ticksSinceUpdate > 20) {
            this.sync();
            this.ticksSinceUpdate = 0;
            this.isDirty = false;
        }
    }

    public boolean isCompressedCow() {
        return this.compressedCow;
    }

    public void setCompressedCow(boolean compressedCow) {
        this.compressedCow = compressedCow;
    }

    @Override
    public void setCustomName(class_2561 customName) {
        this.customName = customName;
        this.method_5431();
    }

    public class_2561 method_5797() {
        return this.customName;
    }

    public boolean method_16914() {
        return this.customName != null;
    }

    public class_2561 method_5476() {
        return this.method_5477();
    }

    public class_2561 method_5477() {
        return this.customName != null ? this.customName : this.getDefaultName();
    }

    @Override
    public class_2561 getDefaultName() {
        if (this.compressedCow) {
            return class_2561.method_43471((String)"container.cookingforblockheads.cow_jar_compressed");
        }
        return class_2561.method_43471((String)"container.cookingforblockheads.cow_jar");
    }

    @Nullable
    public class_6880<class_10731> getVariant() {
        return this.variant;
    }

    public void setVariant(class_6880<class_10731> variant) {
        this.variant = variant;
    }

    public boolean isPartying() {
        return this.partyBpm > 0;
    }

    public void setRecordPlayingNearby(class_2338 pos, boolean playing) {
        this.jukebox = pos;
        this.partyBpm = playing ? 85 : 0;
    }
}

