/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.block.entity;

import java.util.Collection;
import net.blay09.mods.balm.api.fluid.BalmFluidTankProvider;
import net.blay09.mods.balm.api.fluid.DefaultFluidTank;
import net.blay09.mods.balm.api.fluid.FluidTank;
import net.blay09.mods.balm.common.BalmBlockEntity;
import net.blay09.mods.cookingforblockheads.api.CacheHint;
import net.blay09.mods.cookingforblockheads.api.IngredientToken;
import net.blay09.mods.cookingforblockheads.api.KitchenItemProvider;
import net.blay09.mods.cookingforblockheads.block.entity.ModBlockEntities;
import net.blay09.mods.cookingforblockheads.capability.KitchenItemProviderHolder;
import net.blay09.mods.cookingforblockheads.compat.Compat;
import net.blay09.mods.cookingforblockheads.tag.ModItemTags;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_2338;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3611;
import net.minecraft.class_6880;
import net.minecraft.class_7923;

public class MilkJarBlockEntity
extends BalmBlockEntity
implements BalmFluidTankProvider,
KitchenItemProviderHolder {
    protected static final int MILK_CAPACITY = 32000;
    protected final DefaultFluidTank milkTank = new DefaultFluidTank(32000){

        public boolean canFill(class_3611 fluid) {
            return fluid.method_15780(Compat.getMilkFluid()) && super.canFill(fluid);
        }

        public void setChanged() {
            MilkJarBlockEntity.this.method_5431();
            MilkJarBlockEntity.this.sync();
        }
    };
    private final MilkJarItemProvider itemProvider = new MilkJarItemProvider(this);

    public MilkJarBlockEntity(class_2338 pos, class_2680 state) {
        this((class_2591<? extends MilkJarBlockEntity>)((class_2591)ModBlockEntities.milkJar.get()), pos, state);
    }

    protected MilkJarBlockEntity(class_2591<? extends MilkJarBlockEntity> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    public void method_11007(class_11372 output) {
        this.milkTank.serialize(output.method_71461("FluidTank"));
    }

    public void method_11014(class_11368 input) {
        input.method_71420("FluidTank").ifPresent(arg_0 -> ((DefaultFluidTank)this.milkTank).deserialize(arg_0));
    }

    public void writeUpdateTag(class_11372 output) {
        this.method_11007(output);
    }

    public FluidTank getFluidTank() {
        return this.milkTank;
    }

    @Override
    public KitchenItemProvider getKitchenItemProvider() {
        return this.itemProvider;
    }

    private record MilkJarItemProvider(MilkJarBlockEntity milkJar) implements KitchenItemProvider
    {
        @Override
        public IngredientToken findIngredient(class_1856 ingredient, Collection<IngredientToken> ingredientTokens, CacheHint cacheHint) {
            for (class_6880 milkItem : class_7923.field_41178.method_40286(ModItemTags.MILK)) {
                if (!ingredient.method_65798(milkItem)) continue;
                int milkUnitsUsed = ingredientTokens.size();
                int milkUnitsAvailable = this.milkJar.getFluidTank().getAmount() / 1000 - milkUnitsUsed;
                if (milkUnitsAvailable > 1) {
                    return new MilkJarIngredientToken(this.milkJar, new class_1799(milkItem));
                }
                return null;
            }
            return null;
        }

        @Override
        public IngredientToken findIngredient(class_1799 itemStack, Collection<IngredientToken> ingredientTokens, CacheHint cacheHint) {
            if (!itemStack.method_31573(ModItemTags.MILK)) {
                return null;
            }
            int milkUnitsUsed = ingredientTokens.size();
            int milkUnitsAvailable = this.milkJar.getFluidTank().getAmount() / 1000 - milkUnitsUsed;
            if (milkUnitsAvailable > 1) {
                return new MilkJarIngredientToken(this.milkJar, itemStack);
            }
            return null;
        }

        @Override
        public CacheHint getCacheHint(IngredientToken ingredientToken) {
            return CacheHint.NONE;
        }
    }

    private record MilkJarIngredientToken(MilkJarBlockEntity milkJar, class_1799 itemStack) implements IngredientToken
    {
        @Override
        public class_1799 peek() {
            int drained = this.milkJar.getFluidTank().drain(Compat.getMilkFluid(), 1000, true);
            return drained >= 1000 ? this.itemStack : class_1799.field_8037;
        }

        @Override
        public class_1799 consume() {
            int drained = this.milkJar.getFluidTank().drain(Compat.getMilkFluid(), 1000, false);
            return drained >= 1000 ? this.itemStack : class_1799.field_8037;
        }

        @Override
        public class_1799 restore(class_1799 itemStack) {
            if (itemStack.method_31573(ModItemTags.MILK)) {
                this.milkJar.getFluidTank().fill(Compat.getMilkFluid(), 1000, false);
            }
            return class_1799.field_8037;
        }
    }
}

