/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.block.entity;

import java.util.List;
import java.util.Optional;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.block.entity.CustomRenderBoundingBox;
import net.blay09.mods.balm.api.container.BalmContainerProvider;
import net.blay09.mods.balm.api.container.CombinedContainer;
import net.blay09.mods.balm.api.container.ContainerUtils;
import net.blay09.mods.balm.api.container.DefaultContainer;
import net.blay09.mods.balm.api.container.SubContainer;
import net.blay09.mods.balm.api.energy.BalmEnergyStorageProvider;
import net.blay09.mods.balm.api.energy.DefaultEnergyStorage;
import net.blay09.mods.balm.api.energy.EnergyStorage;
import net.blay09.mods.balm.api.menu.BalmMenuProvider;
import net.blay09.mods.balm.api.tag.BalmItemTags;
import net.blay09.mods.balm.common.BalmBlockEntity;
import net.blay09.mods.cookingforblockheads.CookingForBlockheadsConfig;
import net.blay09.mods.cookingforblockheads.api.IngredientToken;
import net.blay09.mods.cookingforblockheads.api.KitchenItemProcessor;
import net.blay09.mods.cookingforblockheads.api.KitchenItemProvider;
import net.blay09.mods.cookingforblockheads.api.KitchenOperation;
import net.blay09.mods.cookingforblockheads.api.event.OvenCookedEvent;
import net.blay09.mods.cookingforblockheads.block.OvenBlock;
import net.blay09.mods.cookingforblockheads.block.entity.IMutableNameable;
import net.blay09.mods.cookingforblockheads.block.entity.ModBlockEntities;
import net.blay09.mods.cookingforblockheads.block.entity.util.DoorAnimator;
import net.blay09.mods.cookingforblockheads.block.entity.util.TransferableBlockEntity;
import net.blay09.mods.cookingforblockheads.block.entity.util.TransferableContainer;
import net.blay09.mods.cookingforblockheads.capability.KitchenItemProcessorHolder;
import net.blay09.mods.cookingforblockheads.capability.KitchenItemProviderHolder;
import net.blay09.mods.cookingforblockheads.item.ModItems;
import net.blay09.mods.cookingforblockheads.kitchen.ContainerKitchenItemProvider;
import net.blay09.mods.cookingforblockheads.menu.OvenMenu;
import net.blay09.mods.cookingforblockheads.recipe.ModRecipes;
import net.blay09.mods.cookingforblockheads.sound.ModSounds;
import net.blay09.mods.cookingforblockheads.util.ItemUtils;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_124;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1860;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_238;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3913;
import net.minecraft.class_3956;
import net.minecraft.class_7225;
import net.minecraft.class_8786;
import net.minecraft.class_8824;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import net.minecraft.class_9323;
import net.minecraft.class_9334;
import net.minecraft.class_9473;
import net.minecraft.class_9695;
import net.minecraft.class_9696;
import net.minecraft.server.MinecraftServer;
import org.apache.commons.lang3.ArrayUtils;
import org.jetbrains.annotations.Nullable;

public class OvenBlockEntity
extends BalmBlockEntity
implements KitchenItemProcessor,
BalmMenuProvider<class_2338>,
IMutableNameable,
BalmContainerProvider,
BalmEnergyStorageProvider,
CustomRenderBoundingBox,
TransferableBlockEntity<TransferableContainer>,
KitchenItemProviderHolder,
KitchenItemProcessorHolder {
    private static final int COOK_TIME = 200;
    private final DefaultEnergyStorage energyStorage = new DefaultEnergyStorage(10000){

        public int fill(int maxReceive, boolean simulate) {
            if (!simulate) {
                OvenBlockEntity.this.method_5431();
            }
            return super.fill(maxReceive, simulate);
        }

        public int drain(int maxExtract, boolean simulate) {
            if (!simulate) {
                OvenBlockEntity.this.method_5431();
            }
            return super.drain(maxExtract, simulate);
        }
    };
    private final DoorAnimator doorAnimator = new DoorAnimator((class_2586)this, 1, 2);
    public int[] slotCookTime = new int[9];
    public int furnaceBurnTime;
    public int currentItemBurnTime;
    private final class_3913 dataAccess = new class_3913(){

        public int method_17390(int id) {
            if (id == 0) {
                return OvenBlockEntity.this.furnaceBurnTime;
            }
            if (id == 1) {
                return OvenBlockEntity.this.currentItemBurnTime;
            }
            if (id >= 2 && id <= 11) {
                return OvenBlockEntity.this.slotCookTime[id - 2];
            }
            return 0;
        }

        public void method_17391(int id, int value) {
            if (id == 0) {
                OvenBlockEntity.this.furnaceBurnTime = value;
            } else if (id == 1) {
                OvenBlockEntity.this.currentItemBurnTime = value;
            } else if (id >= 2 && id <= 11) {
                OvenBlockEntity.this.slotCookTime[id - 2] = value;
            }
        }

        public int method_17389() {
            return 11;
        }
    };
    private class_2561 customName;
    private boolean isFirstTick = true;
    private boolean isDirty;
    private final DefaultContainer container = new DefaultContainer(20){

        public boolean method_5437(int slot, class_1799 itemStack) {
            if (slot < 3) {
                return !OvenBlockEntity.this.getSmeltingResult(itemStack).method_7960();
            }
            if (slot == 3) {
                return OvenBlockEntity.isItemFuel(OvenBlockEntity.this.field_11863, itemStack);
            }
            return true;
        }

        public void slotChanged(int slot) {
            if (slot >= 7 && slot < 16) {
                OvenBlockEntity.this.slotCookTime[slot - 7] = 0;
            }
            OvenBlockEntity.this.isDirty = true;
            OvenBlockEntity.this.method_5431();
        }
    };
    private final SubContainer inputContainer = new SubContainer((class_1263)this.container, 0, 3);
    private final SubContainer fuelContainer = new SubContainer((class_1263)this.container, 3, 4);
    private final SubContainer outputContainer = new SubContainer((class_1263)this.container, 4, 7);
    private final SubContainer processingContainer = new SubContainer((class_1263)this.container, 7, 16);
    private final SubContainer toolsContainer = new SubContainer((class_1263)this.container, 16, 20);
    private final KitchenItemProvider itemProvider = new ContainerKitchenItemProvider((class_1263)new CombinedContainer(new class_1263[]{this.toolsContainer, this.outputContainer}));
    private boolean hasPowerUpgrade;
    private class_2350 facing;

    public OvenBlockEntity(class_2338 pos, class_2680 state) {
        super((class_2591)ModBlockEntities.oven.get(), pos, state);
        this.doorAnimator.setSoundEventOpen((class_3414)ModSounds.ovenOpen.get());
        this.doorAnimator.setSoundEventClose((class_3414)ModSounds.ovenClose.get());
    }

    public static void clientTick(class_1937 level, class_2338 pos, class_2680 state, OvenBlockEntity blockEntity) {
        blockEntity.clientTick(level, pos, state);
    }

    public static void serverTick(class_1937 level, class_2338 pos, class_2680 state, OvenBlockEntity blockEntity) {
        blockEntity.serverTick(level, pos, state);
    }

    public static boolean isItemFuel(class_1937 level, class_1799 itemStack) {
        if (CookingForBlockheadsConfig.getActive().ovenRequiresCookingOil) {
            return itemStack.method_31573(BalmItemTags.COOKING_OIL);
        }
        return OvenBlockEntity.getBurnTime(level, itemStack) > 0;
    }

    protected static int getBurnTime(class_1937 level, class_1799 itemStack) {
        if (itemStack.method_7960()) {
            return 0;
        }
        if (CookingForBlockheadsConfig.getActive().ovenRequiresCookingOil && itemStack.method_31573(BalmItemTags.COOKING_OIL)) {
            return 800;
        }
        return level.method_61269().method_61755(itemStack);
    }

    public boolean method_11004(int id, int type) {
        return this.doorAnimator.receiveClientEvent(id, type) || super.method_11004(id, type);
    }

    public void clientTick(class_1937 level, class_2338 pos, class_2680 state) {
        this.doorAnimator.update();
    }

    public void serverTick(class_1937 level, class_2338 pos, class_2680 state) {
        if (this.isFirstTick && state.method_28498((class_2769)OvenBlock.FACING)) {
            this.facing = (class_2350)state.method_11654((class_2769)OvenBlock.FACING);
            this.isFirstTick = false;
        }
        if (this.isDirty) {
            this.sync();
            this.isDirty = false;
        }
        boolean hasChanged = false;
        int burnPotential = 200 - this.furnaceBurnTime;
        if (this.hasPowerUpgrade && burnPotential > 0 && this.shouldConsumeFuel()) {
            this.furnaceBurnTime += this.energyStorage.drain(burnPotential, false);
        }
        if (this.furnaceBurnTime > 0) {
            --this.furnaceBurnTime;
        }
        if (!level.method_8608()) {
            class_1799 itemStack;
            if (this.furnaceBurnTime == 0 && this.shouldConsumeFuel()) {
                for (int i = 0; i < this.fuelContainer.method_5439(); ++i) {
                    class_1799 fuelItem = this.fuelContainer.method_5438(i);
                    if (fuelItem.method_7960()) continue;
                    this.currentItemBurnTime = this.furnaceBurnTime = (int)Math.max(1.0, (double)OvenBlockEntity.getBurnTime(level, fuelItem) * CookingForBlockheadsConfig.getActive().ovenFuelTimeMultiplier);
                    if (this.furnaceBurnTime == 0) break;
                    class_1799 containerItem = Balm.getHooks().getCraftingRemainingItem(fuelItem);
                    fuelItem.method_7934(1);
                    if (fuelItem.method_7960()) {
                        this.fuelContainer.method_5447(i, containerItem);
                    }
                    hasChanged = true;
                    break;
                }
            }
            int firstEmptySlot = -1;
            int firstTransferSlot = -1;
            for (int i = 0; i < this.processingContainer.method_5439(); ++i) {
                itemStack = this.processingContainer.method_5438(i);
                if (!itemStack.method_7960()) {
                    if (this.slotCookTime[i] != -1) {
                        class_1799 smeltingResult;
                        double maxCookTime = 200.0 * CookingForBlockheadsConfig.getActive().ovenCookTimeMultiplier;
                        if ((double)this.slotCookTime[i] >= maxCookTime && firstTransferSlot == -1) {
                            firstTransferSlot = i;
                            continue;
                        }
                        if (this.furnaceBurnTime > 0) {
                            int n = i;
                            this.slotCookTime[n] = this.slotCookTime[n] + 1;
                        }
                        if (!((double)this.slotCookTime[i] >= maxCookTime) || (smeltingResult = this.getSmeltingResult(itemStack)).method_7960()) continue;
                        class_1799 resultStack = smeltingResult.method_7972();
                        this.processingContainer.method_5447(i, resultStack);
                        Balm.getEvents().fireEvent((Object)new OvenCookedEvent(level, this.field_11867, resultStack));
                        this.slotCookTime[i] = -1;
                        if (firstTransferSlot != -1) continue;
                        firstTransferSlot = i;
                        continue;
                    }
                    if (firstTransferSlot != -1) continue;
                    firstTransferSlot = i;
                    continue;
                }
                if (firstEmptySlot != -1) continue;
                firstEmptySlot = i;
            }
            if (firstTransferSlot != -1) {
                class_1799 transferStack = this.processingContainer.method_5438(firstTransferSlot);
                transferStack = ContainerUtils.insertItemStacked((class_1263)this.outputContainer, (class_1799)transferStack, (boolean)false);
                this.processingContainer.method_5447(firstTransferSlot, transferStack);
                if (transferStack.method_7960()) {
                    this.slotCookTime[firstTransferSlot] = 0;
                }
                hasChanged = true;
            }
            if (firstEmptySlot != -1) {
                for (int j = 0; j < this.inputContainer.method_5439(); ++j) {
                    itemStack = this.inputContainer.method_5438(j);
                    if (itemStack.method_7960()) continue;
                    this.processingContainer.method_5447(firstEmptySlot, itemStack.method_7971(1));
                    if (itemStack.method_7947() > 0) break;
                    this.inputContainer.method_5447(j, class_1799.field_8037);
                    break;
                }
            }
        }
        if (hasChanged) {
            this.method_5431();
        }
    }

    public class_1799 getSmeltingResult(class_1799 itemStack) {
        class_9696 recipeInput = new class_9696(itemStack);
        class_1799 ovenRecipeResult = this.getSmeltingResult(ModRecipes.ovenRecipeType, recipeInput);
        if (!ovenRecipeResult.method_7960()) {
            return ovenRecipeResult;
        }
        return this.getSmeltingResult(class_3956.field_17546, recipeInput);
    }

    public <T extends class_9695> class_1799 getSmeltingResult(class_3956<? extends class_1860<T>> recipeType, T recipeInput) {
        class_1799 result;
        class_8786 recipe;
        MinecraftServer server = this.field_11863.method_8503();
        if (server != null && (recipe = (class_8786)server.method_3772().method_8132(recipeType, recipeInput, this.field_11863).orElse(null)) != null && !(result = recipe.comp_1933().method_8116(recipeInput, (class_7225.class_7874)this.field_11863.method_30349())).method_7960() && result.method_57826(class_9334.field_50075)) {
            return result;
        }
        return class_1799.field_8037;
    }

    private boolean shouldConsumeFuel() {
        for (int i = 0; i < this.processingContainer.method_5439(); ++i) {
            class_1799 cookingStack = this.processingContainer.method_5438(i);
            if (cookingStack.method_7960() || this.slotCookTime[i] == -1) continue;
            return true;
        }
        return false;
    }

    protected void method_57568(class_9473 input) {
        class_2561 customNameComponent = (class_2561)input.method_58694(class_9334.field_49631);
        if (customNameComponent != null) {
            this.customName = customNameComponent;
        }
    }

    protected void method_57567(class_9323.class_9324 builder) {
        builder.method_57840(class_9334.field_49631, (Object)this.customName);
    }

    public void method_11014(class_11368 input) {
        input.method_71420("ItemHandler").ifPresent(it -> class_1262.method_5429((class_11368)it, (class_2371)this.container.getItems()));
        this.furnaceBurnTime = input.method_71432("BurnTime", (short)0);
        this.currentItemBurnTime = input.method_71432("CurrentItemBurnTime", (short)0);
        this.slotCookTime = input.method_71442("CookTimes").orElseGet(() -> new int[9]);
        if (this.slotCookTime.length != 9) {
            this.slotCookTime = new int[9];
        }
        this.hasPowerUpgrade = input.method_71433("HasPowerUpgrade", false);
        this.energyStorage.setEnergy(input.method_71424("EnergyStored", 0));
        this.customName = input.method_71426("CustomNameV2", class_8824.field_46597).orElse(null);
    }

    public void method_11007(class_11372 output) {
        class_1262.method_5426((class_11372)output.method_71461("ItemHandler"), (class_2371)this.container.getItems());
        output.method_71471("BurnTime", (short)this.furnaceBurnTime);
        output.method_71471("CurrentItemBurnTime", (short)this.currentItemBurnTime);
        output.method_71473("CookTimes", ArrayUtils.clone((int[])this.slotCookTime));
        output.method_71472("HasPowerUpgrade", this.hasPowerUpgrade);
        output.method_71465("EnergyStored", this.energyStorage.getEnergy());
        output.method_71477("CustomNameV2", class_8824.field_46597, (Object)this.customName);
    }

    public void writeUpdateTag(class_11372 output) {
        this.method_11007(output);
        output.method_71472("IsForcedOpen", this.doorAnimator.isForcedOpen());
        output.method_71462("NumPlayersUsing", (byte)this.doorAnimator.getNumPlayersUsing());
    }

    public boolean hasPowerUpgrade() {
        return this.hasPowerUpgrade;
    }

    public void setHasPowerUpgrade(boolean hasPowerUpgrade) {
        this.hasPowerUpgrade = hasPowerUpgrade;
        this.method_5431();
    }

    public boolean isBurning() {
        return this.furnaceBurnTime > 0;
    }

    public float getBurnTimeProgress() {
        if (this.currentItemBurnTime == 0 && this.furnaceBurnTime > 0) {
            return 1.0f;
        }
        return (float)this.furnaceBurnTime / (float)this.currentItemBurnTime;
    }

    public float getCookProgress(int i) {
        return (float)this.slotCookTime[i] / (float)(200.0 * CookingForBlockheadsConfig.getActive().ovenCookTimeMultiplier);
    }

    @Override
    public boolean canProcess(class_3956<?> recipeType) {
        return recipeType == class_3956.field_17546;
    }

    @Override
    public KitchenOperation processRecipe(class_1860<?> recipe, List<IngredientToken> ingredientTokens) {
        for (IngredientToken ingredientToken : ingredientTokens) {
            class_1799 itemStack = ingredientToken.consume();
            class_1799 restStack = ContainerUtils.insertItemStacked((class_1263)this.inputContainer, (class_1799)itemStack, (boolean)false);
            if (restStack.method_7960()) continue;
            ingredientToken.restore(restStack);
        }
        return OvenOperation.INSTANCE;
    }

    public DoorAnimator getDoorAnimator() {
        return this.doorAnimator;
    }

    public class_1799 getToolItem(int i) {
        return this.toolsContainer.method_5438(i);
    }

    public void setToolItem(int i, class_1799 itemStack) {
        this.toolsContainer.method_5447(i, itemStack);
    }

    public class_1263 getContainer(class_2350 side) {
        if (CookingForBlockheadsConfig.getActive().disallowOvenAutomation) {
            return null;
        }
        if (side == null) {
            return this.getInternalContainer();
        }
        return switch (side) {
            case class_2350.field_11036 -> this.inputContainer;
            case class_2350.field_11033 -> this.outputContainer;
            default -> this.fuelContainer;
        };
    }

    @Override
    public KitchenItemProvider getKitchenItemProvider() {
        return this.itemProvider;
    }

    @Override
    public KitchenItemProcessor getKitchenItemProcessor() {
        return this;
    }

    public class_1263 getInputContainer() {
        return this.inputContainer;
    }

    public class_1263 getFuelContainer() {
        return this.fuelContainer;
    }

    public class_2350 getFacing() {
        return this.facing == null ? class_2350.field_11043 : this.facing;
    }

    @Nullable
    public class_1703 createMenu(int i, class_1661 playerInventory, class_1657 playerEntity) {
        return new OvenMenu(i, playerInventory, this);
    }

    public class_238 getRenderBoundingBox() {
        return new class_238(this.field_11867.method_10069(-1, 0, -1).method_46558(), this.field_11867.method_10069(2, 1, 2).method_46558());
    }

    public class_2561 method_5477() {
        return this.customName != null ? this.customName : this.getDefaultName();
    }

    public boolean method_16914() {
        return this.customName != null;
    }

    @Nullable
    public class_2561 method_5797() {
        return this.customName;
    }

    @Override
    public void setCustomName(class_2561 customName) {
        this.customName = customName;
        this.method_5431();
    }

    public class_2561 method_5476() {
        return this.method_5477();
    }

    @Override
    public class_2561 getDefaultName() {
        return class_2561.method_43471((String)"container.cookingforblockheads.oven");
    }

    public class_1263 getInternalContainer() {
        return this.container;
    }

    public class_1263 getContainer() {
        if (CookingForBlockheadsConfig.getActive().disallowOvenAutomation) {
            return null;
        }
        return this.container;
    }

    public class_3913 getContainerData() {
        return this.dataAccess;
    }

    public EnergyStorage getEnergyStorage() {
        return this.energyStorage;
    }

    public class_9139<class_9129, class_2338> getScreenStreamCodec() {
        return class_2338.field_48404.method_56430();
    }

    public class_2338 getScreenOpeningData(class_3222 serverPlayer) {
        return this.field_11867;
    }

    @Override
    public TransferableContainer snapshotDataForTransfer() {
        return TransferableContainer.copyAndClear((class_1263)this.container);
    }

    @Override
    public void restoreFromTransferSnapshot(TransferableContainer data) {
        data.applyTo((class_1263)this.container);
    }

    public void method_66473(class_2338 pos, class_2680 state) {
        super.method_66473(pos, state);
        if (this.hasPowerUpgrade()) {
            ItemUtils.spawnItemStack(this.field_11863, (float)pos.method_10263() + 0.5f, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5, new class_1799((class_1935)ModItems.heatingUnit));
        }
    }

    private static class OvenOperation
    implements KitchenOperation {
        public static final KitchenOperation INSTANCE = new OvenOperation();

        private OvenOperation() {
        }

        @Override
        public Optional<class_2561> getFeedback() {
            return Optional.of(class_2561.method_43471((String)"gui.cookingforblockheads.moved_to_oven").method_27692(class_124.field_1054));
        }
    }
}

