/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.block.entity;

import java.util.Collection;
import net.blay09.mods.balm.api.fluid.BalmFluidTankProvider;
import net.blay09.mods.balm.api.fluid.DefaultFluidTank;
import net.blay09.mods.balm.api.fluid.FluidTank;
import net.blay09.mods.balm.common.BalmBlockEntity;
import net.blay09.mods.cookingforblockheads.CookingForBlockheadsConfig;
import net.blay09.mods.cookingforblockheads.api.CacheHint;
import net.blay09.mods.cookingforblockheads.api.IngredientToken;
import net.blay09.mods.cookingforblockheads.api.KitchenItemProvider;
import net.blay09.mods.cookingforblockheads.block.entity.ModBlockEntities;
import net.blay09.mods.cookingforblockheads.block.entity.util.TransferableBlockEntity;
import net.blay09.mods.cookingforblockheads.capability.KitchenItemProviderHolder;
import net.blay09.mods.cookingforblockheads.compat.Compat;
import net.blay09.mods.cookingforblockheads.tag.ModItemTags;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_6880;
import net.minecraft.class_7923;

public class SinkBlockEntity
extends BalmBlockEntity
implements BalmFluidTankProvider,
TransferableBlockEntity<Integer>,
KitchenItemProviderHolder {
    private static final int SYNC_INTERVAL = 10;
    private final SinkItemProvider itemProvider = new SinkItemProvider(this);
    private int ticksSinceSync;
    private boolean isDirty;
    private final DefaultFluidTank sinkTank = new DefaultFluidTank(16000){

        public class_3611 getFluid() {
            if (!CookingForBlockheadsConfig.getActive().sinkRequiresWater) {
                return class_3612.field_15910;
            }
            return super.getFluid();
        }

        public int getAmount() {
            if (!CookingForBlockheadsConfig.getActive().sinkRequiresWater) {
                return Integer.MAX_VALUE;
            }
            return super.getAmount();
        }

        public int getCapacity() {
            if (!CookingForBlockheadsConfig.getActive().sinkRequiresWater) {
                return Integer.MAX_VALUE;
            }
            return super.getCapacity();
        }

        public int drain(class_3611 fluid, int maxDrain, boolean simulate) {
            if (!CookingForBlockheadsConfig.getActive().sinkRequiresWater && fluid == class_3612.field_15910) {
                return maxDrain;
            }
            if (fluid.method_15780(class_3612.field_15906) || !fluid.method_15780(fluid)) {
                return 0;
            }
            SinkBlockEntity.this.method_5431();
            return super.drain(fluid, maxDrain, simulate);
        }

        public int fill(class_3611 fluid, int maxFill, boolean simulate) {
            if (!CookingForBlockheadsConfig.getActive().sinkRequiresWater) {
                return maxFill;
            }
            SinkBlockEntity.this.method_5431();
            return super.fill(fluid, maxFill, simulate);
        }
    };

    public SinkBlockEntity(class_2338 pos, class_2680 state) {
        super((class_2591)ModBlockEntities.sink.get(), pos, state);
    }

    public static void serverTick(class_1937 level, class_2338 pos, class_2680 state, SinkBlockEntity blockEntity) {
        blockEntity.serverTick(level, pos, state);
    }

    public void method_11007(class_11372 output) {
        this.sinkTank.serialize(output.method_71461("FluidTank"));
    }

    public void method_11014(class_11368 input) {
        input.method_71420("FluidTank").ifPresent(arg_0 -> ((DefaultFluidTank)this.sinkTank).deserialize(arg_0));
    }

    public void writeUpdateTag(class_11372 output) {
        this.method_11007(output);
    }

    @Override
    public KitchenItemProvider getKitchenItemProvider() {
        return this.itemProvider;
    }

    public void serverTick(class_1937 level, class_2338 pos, class_2680 state) {
        ++this.ticksSinceSync;
        if (this.ticksSinceSync >= 10) {
            this.ticksSinceSync = 0;
            if (this.isDirty) {
                this.sync();
                this.isDirty = false;
            }
        }
    }

    public void method_5431() {
        super.method_5431();
        this.isDirty = true;
    }

    public FluidTank getFluidTank() {
        return this.sinkTank;
    }

    @Override
    public Integer snapshotDataForTransfer() {
        return this.sinkTank.getAmount();
    }

    @Override
    public void restoreFromTransferSnapshot(Integer data) {
        this.sinkTank.setFluid((class_3611)class_3612.field_15910, data.intValue());
    }

    private record SinkItemProvider(SinkBlockEntity sink) implements KitchenItemProvider
    {
        @Override
        public IngredientToken findIngredient(class_1856 ingredient, Collection<IngredientToken> ingredientTokens, CacheHint cacheHint) {
            for (class_6880 waterItem : class_7923.field_41178.method_40286(ModItemTags.WATER)) {
                if (!ingredient.method_65798(waterItem)) continue;
                int waterUnitsUsed = ingredientTokens.size();
                int waterUnitsAvailable = this.sink.getFluidTank().getAmount() / 1000 - waterUnitsUsed;
                if (waterUnitsAvailable > 1) {
                    return new SinkIngredientToken(this.sink, new class_1799(waterItem));
                }
                return null;
            }
            return null;
        }

        @Override
        public IngredientToken findIngredient(class_1799 itemStack, Collection<IngredientToken> ingredientTokens, CacheHint cacheHint) {
            if (!itemStack.method_31573(ModItemTags.WATER)) {
                return null;
            }
            int waterUnitsUsed = ingredientTokens.size();
            int waterUnitsAvailable = this.sink.getFluidTank().getAmount() / 1000 - waterUnitsUsed;
            if (waterUnitsAvailable > 1) {
                return new SinkIngredientToken(this.sink, itemStack);
            }
            return null;
        }

        @Override
        public CacheHint getCacheHint(IngredientToken ingredientToken) {
            return CacheHint.NONE;
        }
    }

    private record SinkIngredientToken(SinkBlockEntity milkJar, class_1799 itemStack) implements IngredientToken
    {
        @Override
        public class_1799 peek() {
            int drained = this.milkJar.getFluidTank().drain(Compat.getMilkFluid(), 1000, true);
            return drained >= 1000 ? this.itemStack : class_1799.field_8037;
        }

        @Override
        public class_1799 consume() {
            int drained = this.milkJar.getFluidTank().drain(Compat.getMilkFluid(), 1000, false);
            return drained >= 1000 ? this.itemStack : class_1799.field_8037;
        }

        @Override
        public class_1799 restore(class_1799 itemStack) {
            this.milkJar.getFluidTank().fill(Compat.getMilkFluid(), 1000, false);
            return class_1799.field_8037;
        }
    }
}

