/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.block.entity;

import java.util.Optional;
import net.blay09.mods.balm.api.container.DefaultContainer;
import net.blay09.mods.balm.common.BalmBlockEntity;
import net.blay09.mods.cookingforblockheads.CookingForBlockheadsConfig;
import net.blay09.mods.cookingforblockheads.block.ModBlocks;
import net.blay09.mods.cookingforblockheads.block.ToasterBlock;
import net.blay09.mods.cookingforblockheads.block.entity.ModBlockEntities;
import net.blay09.mods.cookingforblockheads.component.ModComponents;
import net.blay09.mods.cookingforblockheads.recipe.ModRecipes;
import net.blay09.mods.cookingforblockheads.recipe.ToasterRecipe;
import net.blay09.mods.cookingforblockheads.sound.ModSounds;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2561;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3902;
import net.minecraft.class_7225;
import net.minecraft.class_9331;
import net.minecraft.class_9334;
import net.minecraft.class_9695;
import net.minecraft.class_9696;
import net.minecraft.server.MinecraftServer;

public class ToasterBlockEntity
extends BalmBlockEntity {
    private static final int UPDATE_INTERVAL = 20;
    private static final int TOAST_TICKS = 1200;
    private final DefaultContainer container = new DefaultContainer(2){

        public void method_5431() {
            ToasterBlockEntity.this.method_5431();
            ToasterBlockEntity.this.sync();
        }
    };
    private boolean isDirty;
    private int ticksSinceUpdate;
    private boolean active;
    private int toastTicks;

    public ToasterBlockEntity(class_2338 pos, class_2680 state) {
        super((class_2591)ModBlockEntities.toaster.get(), pos, state);
    }

    public boolean method_11004(int id, int type) {
        if (id == 0) {
            this.field_11863.method_8396(null, this.field_11867, (class_3414)ModSounds.toasterStart.get(), class_3419.field_15245, 1.0f, 1.0f);
            return true;
        }
        if (id == 1) {
            this.field_11863.method_8396(null, this.field_11867, (class_3414)ModSounds.toasterStop.get(), class_3419.field_15245, 1.0f, 1.0f);
            return true;
        }
        if (id == 2) {
            class_2680 state = this.field_11863.method_8320(this.field_11867);
            this.field_11863.method_8413(this.field_11867, state, state, 3);
            return true;
        }
        return super.method_11004(id, type);
    }

    public void method_11014(class_11368 input) {
        input.method_71420("ItemHandler").ifPresent(it -> class_1262.method_5429((class_11368)it, (class_2371)this.container.getItems()));
        this.active = input.method_71433("Active", false);
        this.toastTicks = input.method_71424("ToastTicks", 0);
    }

    public void method_11007(class_11372 output) {
        class_1262.method_5426((class_11372)output.method_71461("ItemHandler"), (class_2371)this.container.getItems());
        output.method_71472("Active", this.active);
        output.method_71465("ToastTicks", this.toastTicks);
    }

    public void writeUpdateTag(class_11372 output) {
        this.method_11007(output);
    }

    public static void serverTick(class_1937 level, class_2338 pos, class_2680 state, ToasterBlockEntity blockEntity) {
        blockEntity.serverTick(level, pos, state);
    }

    public void serverTick(class_1937 level, class_2338 pos, class_2680 state) {
        if (this.active) {
            --this.toastTicks;
            if (this.toastTicks <= 0 && !level.method_8608()) {
                for (int i = 0; i < this.container.method_5439(); ++i) {
                    class_1799 inputStack = this.container.method_5438(i);
                    if (inputStack.method_7960()) continue;
                    class_1799 outputStack = this.toastItem(inputStack);
                    class_1542 itemEntity = new class_1542(level, (double)((float)this.field_11867.method_10263() + 0.5f), (double)((float)this.field_11867.method_10264() + 0.75f), (double)((float)this.field_11867.method_10260() + 0.5f), outputStack);
                    itemEntity.method_18800(0.0, (double)0.1f, 0.0);
                    level.method_8649((class_1297)itemEntity);
                    this.container.method_5447(i, class_1799.field_8037);
                }
                this.setActive(false);
            }
            this.isDirty = true;
        }
        ++this.ticksSinceUpdate;
        if (this.isDirty && this.ticksSinceUpdate > 20) {
            this.sync();
            this.ticksSinceUpdate = 0;
            this.isDirty = false;
        }
    }

    public void setActive(boolean active) {
        this.active = active;
        if (active) {
            this.toastTicks = 1200;
            this.field_11863.method_8427(this.field_11867, ModBlocks.toaster, 0, 0);
        } else {
            this.toastTicks = 0;
            this.field_11863.method_8427(this.field_11867, ModBlocks.toaster, 1, 0);
        }
        this.field_11863.method_8427(this.field_11867, ModBlocks.toaster, 2, 0);
        class_2680 state = this.field_11863.method_8320(this.field_11867);
        this.field_11863.method_8501(this.field_11867, (class_2680)state.method_11657((class_2769)ToasterBlock.ACTIVE, (Comparable)Boolean.valueOf(active)));
        this.isDirty = true;
        this.method_5431();
    }

    public boolean isActive() {
        return this.active;
    }

    public float getToastProgress() {
        return 1.0f - (float)this.toastTicks / 1200.0f;
    }

    public class_1263 getContainer() {
        return this.container;
    }

    public boolean isBurningToast() {
        boolean firstToasted = this.container.method_5438(0).method_57826((class_9331)ModComponents.toasted.get());
        boolean secondToasted = this.container.method_5438(1).method_57826((class_9331)ModComponents.toasted.get());
        return firstToasted || secondToasted;
    }

    private class_1799 toastItem(class_1799 itemStack) {
        class_9696 recipeInput = new class_9696(itemStack);
        Optional toastRecipe = this.field_11863.method_8503().method_3772().method_8132(ModRecipes.toasterRecipeType, (class_9695)recipeInput, this.field_11863);
        class_1799 outputItem = toastRecipe.map(recipeHolder -> ((ToasterRecipe)recipeHolder.comp_1933()).assemble(recipeInput, (class_7225.class_7874)this.field_11863.method_30349())).orElse(itemStack);
        if (outputItem.method_31574(class_1802.field_8229)) {
            return this.toastBread(outputItem);
        }
        return outputItem;
    }

    private class_1799 toastBread(class_1799 itemStack) {
        boolean alreadyToasted = itemStack.method_57826((class_9331)ModComponents.toasted.get());
        if (alreadyToasted) {
            if (CookingForBlockheadsConfig.getActive().allowVeryToastedBread) {
                class_1799 veryToasted = new class_1799((class_1935)class_1802.field_8665);
                veryToasted.method_57379(class_9334.field_49631, (Object)class_2561.method_43471((String)"tooltip.cookingforblockheads.very_toasted"));
                return veryToasted;
            }
            return itemStack;
        }
        class_1799 toasted = itemStack.method_7972();
        toasted.method_57379(class_9334.field_49631, (Object)class_2561.method_43469((String)"tooltip.cookingforblockheads.toasted", (Object[])new Object[]{itemStack.method_7964()}));
        toasted.method_57379((class_9331)ModComponents.toasted.get(), (Object)class_3902.field_17274);
        return toasted;
    }

    public boolean canToast(class_1799 itemStack) {
        MinecraftServer server = this.field_11863.method_8503();
        if (server == null) {
            return false;
        }
        return server.method_3772().method_8132(ModRecipes.toasterRecipeType, (class_9695)new class_9696(itemStack), this.field_11863).map(it -> true).orElseGet(() -> itemStack.method_31574(class_1802.field_8229));
    }
}

