/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.block.entity.util;

import net.blay09.mods.cookingforblockheads.menu.IContainerWithDoor;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_238;
import net.minecraft.class_2586;
import net.minecraft.class_3414;
import net.minecraft.class_3419;

public class DoorAnimator {
    private final class_2586 blockEntity;
    private final int eventNumPlayers;
    private final int eventForcedOpen;
    private float angle;
    private float prevAngle;
    private int numPlayersUsing;
    private int ticksSinceSync;
    private class_3414 soundEventOpen;
    private class_3414 soundEventClose;
    private float openRadius = 2.5f;
    private boolean isForcedOpen;

    public DoorAnimator(class_2586 tileEntity, int eventNumPlayers, int eventForcedOpen) {
        this.blockEntity = tileEntity;
        this.eventNumPlayers = eventNumPlayers;
        this.eventForcedOpen = eventForcedOpen;
    }

    public void setSoundEventOpen(class_3414 soundEventOpen) {
        this.soundEventOpen = soundEventOpen;
    }

    public void setSoundEventClose(class_3414 soundEventClose) {
        this.soundEventClose = soundEventClose;
    }

    public void setOpenRadius(float openRadius) {
        this.openRadius = openRadius;
    }

    public void update() {
        ++this.ticksSinceSync;
        int x = this.blockEntity.method_11016().method_10263();
        int y = this.blockEntity.method_11016().method_10264();
        int z = this.blockEntity.method_11016().method_10260();
        if (!this.blockEntity.method_10997().method_8608() && this.numPlayersUsing != 0 && (this.ticksSinceSync + x + y + z) % 200 == 0) {
            this.numPlayersUsing = 0;
            float range = 5.0f;
            for (class_1657 player : this.blockEntity.method_10997().method_18467(class_1657.class, new class_238((double)((float)x - range), (double)((float)y - range), (double)((float)z - range), (double)((float)(x + 1) + range), (double)((float)(y + 1) + range), (double)((float)(z + 1) + range)))) {
                if (!(player.field_7512 instanceof IContainerWithDoor) || !((IContainerWithDoor)player.field_7512).isTileEntity(this.blockEntity)) continue;
                ++this.numPlayersUsing;
            }
        }
        this.prevAngle = this.angle;
        if ((this.isForcedOpen || this.numPlayersUsing > 0) && this.angle == 0.0f && this.soundEventOpen != null) {
            this.blockEntity.method_10997().method_8486((double)x, (double)y, (double)z, this.soundEventOpen, class_3419.field_15245, 0.5f, this.blockEntity.method_10997().field_9229.method_43057() * 0.1f + 0.9f, false);
        }
        float angleSpeed = 0.1f;
        if ((this.numPlayersUsing == 0 || !this.isForcedOpen) && this.angle > 0.0f || (this.isForcedOpen || this.numPlayersUsing > 0) && this.angle < 1.0f) {
            float angleBefore = this.angle;
            this.angle = this.numPlayersUsing > 0 || this.isForcedOpen ? (this.angle += angleSpeed) : (this.angle -= angleSpeed);
            this.angle = Math.min(this.angle, 1.0f);
            float playCloseSound = 0.5f;
            if (this.angle < playCloseSound && angleBefore >= playCloseSound && this.soundEventClose != null) {
                this.blockEntity.method_10997().method_8486((double)x, (double)y, (double)z, this.soundEventClose, class_3419.field_15245, 0.5f, this.blockEntity.method_10997().field_9229.method_43057() * 0.1f + 0.9f, false);
            }
            this.angle = Math.max(this.angle, 0.0f);
        }
    }

    public void toggleForcedOpen() {
        this.setForcedOpen(!this.isForcedOpen);
    }

    public boolean isForcedOpen() {
        return this.isForcedOpen;
    }

    public void setForcedOpen(boolean isForcedOpen) {
        this.isForcedOpen = isForcedOpen;
        class_1937 level = this.blockEntity.method_10997();
        if (level != null) {
            level.method_8427(this.blockEntity.method_11016(), this.blockEntity.method_11010().method_26204(), 2, isForcedOpen ? 1 : 0);
        }
    }

    public boolean receiveClientEvent(int id, int type) {
        if (id == this.eventNumPlayers) {
            this.numPlayersUsing = type;
            return true;
        }
        if (id == this.eventForcedOpen) {
            this.isForcedOpen = type == 1;
            return true;
        }
        return false;
    }

    public void openContainer(class_1657 player) {
        if (!player.method_7325()) {
            this.numPlayersUsing = Math.max(0, this.numPlayersUsing + 1);
            this.fireBlockEvent();
        }
    }

    public void closeContainer(class_1657 player) {
        if (!player.method_7325()) {
            --this.numPlayersUsing;
            this.fireBlockEvent();
        }
    }

    private void fireBlockEvent() {
        class_1937 level = this.blockEntity.method_10997();
        class_2248 block = this.blockEntity.method_11010().method_26204();
        if (level != null) {
            level.method_8427(this.blockEntity.method_11016(), block, this.eventNumPlayers, this.numPlayersUsing);
            level.method_8408(this.blockEntity.method_11016(), block);
            level.method_8408(this.blockEntity.method_11016().method_10074(), block);
        }
    }

    public float getRenderAngle(float partialTicks) {
        float renderAngle = this.prevAngle + (this.angle - this.prevAngle) * partialTicks;
        renderAngle = 1.0f - renderAngle;
        renderAngle = 1.0f - renderAngle * renderAngle * renderAngle;
        return (float)(Math.PI / (double)this.openRadius * (double)renderAngle);
    }

    public int getNumPlayersUsing() {
        return this.numPlayersUsing;
    }

    public void setNumPlayersUsing(int numPlayersUsing) {
        this.numPlayersUsing = numPlayersUsing;
    }
}

