/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.client.render;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.blay09.mods.cookingforblockheads.block.CounterBlock;
import net.blay09.mods.cookingforblockheads.block.entity.CounterBlockEntity;
import net.blay09.mods.cookingforblockheads.client.ModModels;
import net.blay09.mods.cookingforblockheads.client.render.RenderUtils;
import net.minecraft.class_10442;
import net.minecraft.class_10444;
import net.minecraft.class_1059;
import net.minecraft.class_1087;
import net.minecraft.class_11659;
import net.minecraft.class_11683;
import net.minecraft.class_11954;
import net.minecraft.class_12075;
import net.minecraft.class_1767;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2248;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4608;
import net.minecraft.class_5614;
import net.minecraft.class_7833;
import net.minecraft.class_811;
import net.minecraft.class_827;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionfc;

public class CounterRenderer<T extends CounterBlockEntity>
implements class_827<T, CounterRenderState> {
    private static final float doorOriginX = 0.84375f;
    private static final float doorOriginZ = 0.09375f;
    private final class_10442 itemModelResolver;

    protected float getDoorOriginX() {
        return 0.84375f;
    }

    protected float getDoorOriginZ() {
        return 0.09375f;
    }

    protected float getBottomShelfOffsetY() {
        return -0.85f;
    }

    protected float getTopShelfOffsetY() {
        return 0.35f;
    }

    protected class_1087 getDoorModel(@Nullable class_1767 blockColor, boolean isFlipped) {
        int colorIndex = blockColor != null ? blockColor.method_7789() + 1 : 0;
        return isFlipped ? (class_1087)ModModels.counterDoorsFlipped.get(colorIndex).get() : (class_1087)ModModels.counterDoors.get(colorIndex).get();
    }

    public CounterRenderer(class_5614.class_5615 context) {
        this.itemModelResolver = context.comp_4536();
    }

    public CounterRenderState createRenderState() {
        return new CounterRenderState();
    }

    public void extractRenderState(T blockEntity, CounterRenderState renderState, float delta, class_243 vec, @Nullable class_11683.class_11792 crumblingOverlay) {
        class_1767 class_17672;
        super.method_74331(blockEntity, (class_11954)renderState, delta, vec, crumblingOverlay);
        class_2248 class_22482 = renderState.field_62674.method_26204();
        if (class_22482 instanceof CounterBlock) {
            CounterBlock counterBlock = (CounterBlock)class_22482;
            class_17672 = counterBlock.getColor();
        } else {
            class_17672 = null;
        }
        renderState.dye = class_17672;
        renderState.doorAngle = ((CounterBlockEntity)blockEntity).getDoorAnimator().getRenderAngle(delta);
        renderState.flipped = ((CounterBlockEntity)blockEntity).isFlipped();
        int id = (int)blockEntity.method_11016().method_10063();
        renderState.items = new ArrayList<class_10444>();
        for (int i = 0; i < ((CounterBlockEntity)blockEntity).getContainer().method_5439(); ++i) {
            class_1799 itemStack = ((CounterBlockEntity)blockEntity).getContainer().method_5438(i);
            class_10444 itemStackRenderState = new class_10444();
            this.itemModelResolver.method_65598(itemStackRenderState, itemStack, class_811.field_4319, blockEntity.method_10997(), null, id + i);
            renderState.items.add(itemStackRenderState);
        }
    }

    public void submit(CounterRenderState renderState, class_4587 poseStack, class_11659 submitNodeCollector, class_12075 cameraRenderState) {
        poseStack.method_22903();
        float doorOriginX = this.getDoorOriginX();
        float doorOriginZ = this.getDoorOriginZ();
        float doorDirection = -1.0f;
        if (renderState.flipped) {
            doorOriginX = 1.0f - doorOriginX;
            doorDirection = 1.0f;
        }
        RenderUtils.applyBlockAngle(poseStack, renderState.field_62674);
        poseStack.method_46416(-0.5f, 0.0f, -0.5f);
        poseStack.method_46416(doorOriginX, 0.0f, doorOriginZ);
        poseStack.method_22907((Quaternionfc)class_7833.field_40716.rotationDegrees(doorDirection * (float)Math.toDegrees(renderState.doorAngle)));
        poseStack.method_46416(-doorOriginX, 0.0f, -doorOriginZ);
        class_1087 model = this.getDoorModel(renderState.dye, renderState.flipped);
        submitNodeCollector.method_73484(poseStack, class_1921.method_23576((class_2960)class_1059.field_5275), model, 0.0f, 0.0f, 0.0f, renderState.field_62676, class_4608.field_21444, 0);
        poseStack.method_22909();
        if (renderState.doorAngle > 0.0f) {
            poseStack.method_22903();
            poseStack.method_22904(0.0, 0.5, 0.0);
            RenderUtils.applyBlockAngle(poseStack, renderState.field_62674);
            poseStack.method_22905(0.3f, 0.3f, 0.3f);
            int itemsPerShelf = renderState.items.size() / 2;
            int itemsPerRow = itemsPerShelf / 2;
            for (int i = renderState.items.size() - 1; i >= 0; --i) {
                class_10444 itemStackRenderState = renderState.items.get(i);
                if (itemStackRenderState.method_65606()) continue;
                int shelfIndex = i % itemsPerShelf;
                int rowIndex = i % itemsPerRow;
                float spacing = 2.0f / (float)itemsPerRow;
                float offsetX = ((float)rowIndex - (float)itemsPerRow / 2.0f) * -spacing + (shelfIndex >= itemsPerRow ? -0.2f : 0.0f);
                float offsetY = i < itemsPerShelf ? this.getTopShelfOffsetY() : this.getBottomShelfOffsetY();
                float offsetZ = shelfIndex < itemsPerRow ? 0.5f : -0.5f;
                poseStack.method_22903();
                poseStack.method_46416(offsetX, offsetY, offsetZ);
                poseStack.method_22907((Quaternionfc)class_7833.field_40716.rotationDegrees(45.0f));
                itemStackRenderState.method_65604(poseStack, submitNodeCollector, renderState.field_62676, class_4608.field_21444, 0);
                poseStack.method_22909();
            }
            poseStack.method_22909();
        }
    }

    public static class CounterRenderState
    extends class_11954 {
        public List<class_10444> items = Collections.emptyList();
        @Nullable
        public class_1767 dye;
        public float doorAngle;
        public boolean flipped;
    }
}

