/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.client.render;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Optional;
import net.blay09.mods.cookingforblockheads.block.BaseKitchenBlock;
import net.blay09.mods.cookingforblockheads.block.entity.CowJarBlockEntity;
import net.blay09.mods.cookingforblockheads.client.ModModels;
import net.blay09.mods.cookingforblockheads.client.render.MilkJarRenderer;
import net.blay09.mods.cookingforblockheads.client.render.RenderUtils;
import net.minecraft.class_10042;
import net.minecraft.class_10602;
import net.minecraft.class_10693;
import net.minecraft.class_10731;
import net.minecraft.class_10733;
import net.minecraft.class_1087;
import net.minecraft.class_11659;
import net.minecraft.class_12075;
import net.minecraft.class_12079;
import net.minecraft.class_1657;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_3879;
import net.minecraft.class_4587;
import net.minecraft.class_4608;
import net.minecraft.class_560;
import net.minecraft.class_5602;
import net.minecraft.class_5614;
import net.minecraft.class_7833;
import net.minecraft.class_7924;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionfc;

public class CowJarRenderer
extends MilkJarRenderer<CowJarBlockEntity> {
    private final Map<class_10731.class_10732, class_10602<class_560>> models;

    public CowJarRenderer(class_5614.class_5615 context) {
        super(context);
        this.models = CowJarRenderer.bakeModels(context);
    }

    private static Map<class_10731.class_10732, class_10602<class_560>> bakeModels(class_5614.class_5615 context) {
        return Maps.newEnumMap(Map.of(class_10731.class_10732.field_56429, new class_10602((class_3879)new class_560(context.method_32140(class_5602.field_27698)), (class_3879)new class_560(context.method_32140(class_5602.field_52959))), class_10731.class_10732.field_56431, new class_10602((class_3879)new class_560(context.method_32140(class_5602.field_56496)), (class_3879)new class_560(context.method_32140(class_5602.field_56497))), class_10731.class_10732.field_56430, new class_10602((class_3879)new class_560(context.method_32140(class_5602.field_56494)), (class_3879)new class_560(context.method_32140(class_5602.field_56495)))));
    }

    @Override
    public MilkJarRenderer.MilkJarRenderState createRenderState() {
        return new CowJarRenderState();
    }

    private Optional<class_10731> getDefaultCowVariant(@Nullable class_1937 level) {
        if (level == null) {
            return Optional.empty();
        }
        return level.method_30349().method_46759(class_7924.field_56510).flatMap(it -> it.method_31189(class_10733.field_56438));
    }

    private boolean shouldCreepyStare(@Nullable class_1937 level) {
        return level != null && level.method_30273() == 0 && level.method_23886();
    }

    private void headbang(@Nullable class_1937 level, CowJarRenderState renderState, int bpm) {
        long gameTime = level != null ? level.method_8510() : 0L;
        float headbangIntensity = 25.0f;
        float headbangSpeed = (float)bpm * (float)Math.PI / 600.0f;
        renderState.cow.field_53448 = (float)Math.sin((float)gameTime * headbangSpeed) * headbangIntensity;
        renderState.cow.field_53447 = (float)Math.cos((float)gameTime * headbangSpeed * 0.7f) * 10.0f;
    }

    private void creepyStare(class_1937 level, class_2338 pos, class_2680 state, float delta, CowJarRenderState renderState) {
        class_1657 nearestPlayer = level.method_18459((double)((float)pos.method_10263() + 0.5f), (double)((float)pos.method_10264() + 0.5f), (double)((float)pos.method_10260() + 0.5f), 16.0, false);
        if (nearestPlayer != null) {
            float relativeYaw;
            class_243 cowPos = new class_243((double)((float)pos.method_10263() + 0.5f), (double)((float)pos.method_10264() + 0.5f), (double)((float)pos.method_10260() + 0.5f));
            class_243 playerPos = nearestPlayer.method_5836(delta);
            class_243 direction = playerPos.method_1020(cowPos);
            float blockYaw = ((class_2350)state.method_11654(BaseKitchenBlock.FACING)).method_10144();
            double yaw = Math.atan2(-direction.field_1352, direction.field_1350);
            float yawDegrees = (float)Math.toDegrees(yaw);
            for (relativeYaw = yawDegrees - blockYaw; relativeYaw > 180.0f; relativeYaw -= 360.0f) {
            }
            while (relativeYaw < -180.0f) {
                relativeYaw += 360.0f;
            }
            renderState.cow.field_53447 = class_3532.method_15363((float)relativeYaw, (float)-90.0f, (float)90.0f);
            double horizontalDistance = Math.sqrt(direction.field_1352 * direction.field_1352 + direction.field_1350 * direction.field_1350);
            double pitch = Math.atan2(-direction.field_1351, horizontalDistance);
            float pitchDegrees = (float)Math.toDegrees(pitch);
            renderState.cow.field_53448 = class_3532.method_15363((float)pitchDegrees, (float)-60.0f, (float)60.0f);
        } else {
            renderState.cow.field_53448 = 0.0f;
            renderState.cow.field_53447 = 0.0f;
        }
    }

    private void theCowIsAlive(@Nullable class_1937 level, class_2338 pos, class_2680 state, float delta, CowJarRenderState renderState, CowJarBlockEntity blockEntity) {
        if (blockEntity.isPartying()) {
            this.headbang(level, renderState, 85);
            return;
        }
        if (this.shouldCreepyStare(level)) {
            this.creepyStare(level, pos, state, delta, renderState);
            return;
        }
        renderState.cow.field_53448 = 0.0f;
        renderState.cow.field_53447 = 0.0f;
    }

    @Override
    public void extractRenderState(CowJarBlockEntity blockEntity, MilkJarRenderer.MilkJarRenderState renderState, float delta, class_243 vec, // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable class_11683.class_11792 crumblingOverlay) {
        super.extractRenderState(blockEntity, renderState, delta, vec, crumblingOverlay);
        if (renderState instanceof CowJarRenderState) {
            CowJarRenderState cowJarRenderState = (CowJarRenderState)renderState;
            this.theCowIsAlive(blockEntity.method_10997(), blockEntity.method_11016(), blockEntity.method_11010(), delta, cowJarRenderState, blockEntity);
            cowJarRenderState.variant = blockEntity.getVariant() != null ? (class_10731)blockEntity.getVariant().comp_349() : (class_10731)this.getDefaultCowVariant(blockEntity.method_10997()).orElse(null);
        }
    }

    @Override
    public void submit(MilkJarRenderer.MilkJarRenderState renderState, class_4587 poseStack, class_11659 submitNodeCollector, class_12075 cameraRenderState) {
        super.submit(renderState, poseStack, submitNodeCollector, cameraRenderState);
        if (renderState instanceof CowJarRenderState) {
            CowJarRenderState cowJarRenderState = (CowJarRenderState)renderState;
            if (cowJarRenderState.variant != null) {
                poseStack.method_22903();
                poseStack.method_46416(0.5f, 0.5f, 0.5f);
                poseStack.method_22907((Quaternionfc)class_7833.field_40718.rotationDegrees(180.0f));
                poseStack.method_46416(-0.5f, -0.5f, -0.5f);
                RenderUtils.applyBlockAngle(poseStack, renderState.field_62674, 180.0f);
                poseStack.method_46416(0.0f, 0.675f, 0.0f);
                float scale = 0.2f;
                poseStack.method_22905(scale, scale, scale);
                class_10693 modelAndTexture = cowJarRenderState.variant.comp_3632();
                class_560 model = (class_560)this.models.get(modelAndTexture.comp_3572()).method_66533(cowJarRenderState.cow.field_53457);
                class_12079.class_10726 textureAsset = modelAndTexture.comp_3573();
                submitNodeCollector.method_73489((class_3879)model, (Object)cowJarRenderState.cow, poseStack, class_1921.method_23576((class_2960)textureAsset.comp_3627()), renderState.field_62676, class_4608.field_21444, 0, renderState.field_62677);
                poseStack.method_22909();
            }
        }
    }

    @Override
    protected class_1087 getLiquidModel() {
        return (class_1087)ModModels.cowJarLiquid.get();
    }

    public static class CowJarRenderState
    extends MilkJarRenderer.MilkJarRenderState {
        public final class_10042 cow = new class_10042();
        @Nullable
        public class_10731 variant;
    }
}

