/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.client.render;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.blay09.mods.cookingforblockheads.block.FridgeBlock;
import net.blay09.mods.cookingforblockheads.block.entity.FridgeBlockEntity;
import net.blay09.mods.cookingforblockheads.client.ModModels;
import net.blay09.mods.cookingforblockheads.client.render.RenderUtils;
import net.minecraft.class_10442;
import net.minecraft.class_10444;
import net.minecraft.class_1059;
import net.minecraft.class_1087;
import net.minecraft.class_11659;
import net.minecraft.class_11683;
import net.minecraft.class_11954;
import net.minecraft.class_12075;
import net.minecraft.class_1767;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2248;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4608;
import net.minecraft.class_5614;
import net.minecraft.class_7833;
import net.minecraft.class_811;
import net.minecraft.class_827;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionfc;

public class FridgeRenderer
implements class_827<FridgeBlockEntity, FridgeRenderState> {
    private final class_10442 itemModelResolver;

    public FridgeRenderer(class_5614.class_5615 context) {
        this.itemModelResolver = context.comp_4536();
    }

    public FridgeRenderState createRenderState() {
        return new FridgeRenderState();
    }

    public void extractRenderState(FridgeBlockEntity blockEntity, FridgeRenderState renderState, float delta, class_243 vec, @Nullable class_11683.class_11792 crumblingOverlay) {
        class_1767 class_17672;
        super.method_74331((class_2586)blockEntity, (class_11954)renderState, delta, vec, crumblingOverlay);
        class_2248 class_22482 = renderState.field_62674.method_26204();
        if (class_22482 instanceof FridgeBlock) {
            FridgeBlock fridgeBlock = (FridgeBlock)class_22482;
            class_17672 = fridgeBlock.getColor();
        } else {
            class_17672 = class_1767.field_7952;
        }
        renderState.dye = class_17672;
        renderState.doorAngle = blockEntity.getDoorAnimator().getRenderAngle(delta);
        renderState.modelType = (FridgeBlock.FridgeModelType)((Object)blockEntity.method_11010().method_11654(FridgeBlock.MODEL_TYPE));
        renderState.skip = renderState.modelType == FridgeBlock.FridgeModelType.LARGE_UPPER;
        renderState.flipped = (Boolean)blockEntity.method_11010().method_11654((class_2769)FridgeBlock.FLIPPED);
        int id = (int)blockEntity.method_11016().method_10063();
        renderState.items = new ArrayList<class_10444>();
        for (int i = 0; i < blockEntity.getContainer().method_5439(); ++i) {
            class_1799 itemStack = blockEntity.getContainer().method_5438(i);
            class_10444 itemStackRenderState = new class_10444();
            this.itemModelResolver.method_65598(itemStackRenderState, itemStack, class_811.field_4319, blockEntity.method_10997(), null, id + i);
            renderState.items.add(itemStackRenderState);
        }
    }

    public void submit(FridgeRenderState renderState, class_4587 poseStack, class_11659 submitNodeCollector, class_12075 cameraRenderState) {
        class_1087 lowerModel;
        if (renderState.skip) {
            return;
        }
        boolean isLarge = renderState.modelType == FridgeBlock.FridgeModelType.LARGE_LOWER;
        poseStack.method_22903();
        RenderUtils.applyBlockAngle(poseStack, renderState.field_62674);
        poseStack.method_46416(-0.5f, 0.0f, -0.5f);
        float originX = 0.90625f;
        float originZ = 0.09375f;
        if (renderState.flipped) {
            originX = 1.0f - originX;
        }
        poseStack.method_46416(originX, 0.0f, originZ);
        poseStack.method_22907((Quaternionfc)class_7833.field_40715.rotationDegrees((float)Math.toDegrees(renderState.flipped ? (double)(-renderState.doorAngle) : (double)renderState.doorAngle)));
        poseStack.method_46416(-originX, 0.0f, -originZ);
        int colorIndex = renderState.dye.method_7789();
        class_1087 upperModel = null;
        if (isLarge) {
            lowerModel = renderState.flipped ? (class_1087)ModModels.fridgeDoorsLargeLowerFlipped.get(colorIndex).get() : (class_1087)ModModels.fridgeDoorsLargeLower.get(colorIndex).get();
            upperModel = renderState.flipped ? (class_1087)ModModels.fridgeDoorsLargeUpperFlipped.get(colorIndex).get() : (class_1087)ModModels.fridgeDoorsLargeUpper.get(colorIndex).get();
        } else {
            lowerModel = renderState.flipped ? (class_1087)ModModels.fridgeDoorsFlipped.get(colorIndex).get() : (class_1087)ModModels.fridgeDoors.get(colorIndex).get();
        }
        submitNodeCollector.method_73484(poseStack, class_1921.method_23576((class_2960)class_1059.field_5275), lowerModel, 1.0f, 1.0f, 1.0f, renderState.field_62676, class_4608.field_21444, 0);
        if (upperModel != null) {
            poseStack.method_46416(0.0f, 1.0f, 0.0f);
            submitNodeCollector.method_73484(poseStack, class_1921.method_23576((class_2960)class_1059.field_5275), upperModel, 1.0f, 1.0f, 1.0f, renderState.field_62676, class_4608.field_21444, 0);
        }
        poseStack.method_22909();
        if (renderState.doorAngle > 0.0f) {
            poseStack.method_22903();
            poseStack.method_22904(0.0, 0.5, 0.0);
            RenderUtils.applyBlockAngle(poseStack, renderState.field_62674);
            poseStack.method_22905(0.3f, 0.3f, 0.3f);
            float topY = renderState.modelType == FridgeBlock.FridgeModelType.LARGE_LOWER ? 3.25f : 0.45f;
            for (int i = renderState.items.size() - 1; i >= 0; --i) {
                float offsetZ;
                float offsetY;
                float offsetX;
                class_10444 itemStackRenderState = renderState.items.get(i);
                if (itemStackRenderState.method_65606()) continue;
                if (renderState.modelType == FridgeBlock.FridgeModelType.LARGE_LOWER) {
                    rowIndex = i % 18;
                    offsetX = 0.7f - (float)(rowIndex % 9) * 0.175f;
                    offsetY = topY - (float)((int)((float)i / 18.0f)) * 1.25f;
                    offsetZ = 0.5f - (float)((int)((float)rowIndex / 9.0f)) * 0.9f;
                } else {
                    rowIndex = i % 13;
                    offsetX = 0.7f;
                    float spacing = 0.175f;
                    if (rowIndex / 9 > 0) {
                        offsetX -= 0.2f;
                        spacing *= 2.0f;
                    }
                    offsetX -= (float)(rowIndex % 9) * spacing;
                    offsetY = topY - (float)((int)((float)i / 14.0f)) * 1.25f;
                    offsetZ = 0.5f - (float)((int)((float)rowIndex / 9.0f)) * 0.9f;
                }
                poseStack.method_22903();
                poseStack.method_46416(offsetX, offsetY, offsetZ);
                poseStack.method_22907((Quaternionfc)class_7833.field_40716.rotationDegrees(45.0f));
                itemStackRenderState.method_65604(poseStack, submitNodeCollector, renderState.field_62676, class_4608.field_21444, 0);
                poseStack.method_22909();
            }
            poseStack.method_22909();
        }
    }

    public static class FridgeRenderState
    extends class_11954 {
        public boolean skip;
        public List<class_10444> items = Collections.emptyList();
        public FridgeBlock.FridgeModelType modelType = FridgeBlock.FridgeModelType.SMALL;
        public class_1767 dye = class_1767.field_7952;
        public float doorAngle;
        public boolean flipped;
    }
}

