/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.crafting;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.blay09.mods.cookingforblockheads.api.CacheHint;
import net.blay09.mods.cookingforblockheads.api.Kitchen;
import net.blay09.mods.cookingforblockheads.api.KitchenItemProcessor;
import net.blay09.mods.cookingforblockheads.api.KitchenItemProvider;
import net.blay09.mods.cookingforblockheads.api.KitchenOperation;
import net.blay09.mods.cookingforblockheads.crafting.CraftingOperation;
import net.minecraft.class_1657;
import net.minecraft.class_1856;
import net.minecraft.class_8786;
import org.jetbrains.annotations.Nullable;

public class CraftingContext {
    private final List<KitchenItemProvider> itemProviders;
    private final List<KitchenItemProcessor> itemProcessors;
    private final Map<class_1856, Integer> cachedProviderIndexByIngredient = new HashMap<class_1856, Integer>();
    private final Map<CraftingOperation.IngredientTokenKey, CacheHint> cacheHintsByIngredient = new HashMap<CraftingOperation.IngredientTokenKey, CacheHint>();
    private final List<Consumer<KitchenOperation>> listeners = new ArrayList<Consumer<KitchenOperation>>();

    public CraftingContext(Kitchen kitchen, @Nullable class_1657 player) {
        this.itemProviders = kitchen.getItemProviders(player);
        this.itemProcessors = kitchen.getItemProcessors();
    }

    public CraftingOperation createOperation(class_8786<?> recipe) {
        return new CraftingOperation(this, recipe);
    }

    public List<KitchenItemProvider> getItemProviders() {
        return this.itemProviders;
    }

    public List<KitchenItemProcessor> getItemProcessors() {
        return this.itemProcessors;
    }

    public int getCachedItemProviderIndexFor(class_1856 ingredient) {
        return this.cachedProviderIndexByIngredient.getOrDefault(ingredient, -1);
    }

    public CacheHint getCacheHintFor(CraftingOperation.IngredientTokenKey ingredientTokenKey) {
        return this.cacheHintsByIngredient.getOrDefault(ingredientTokenKey, CacheHint.NONE);
    }

    public void cache(CraftingOperation.IngredientTokenKey ingredientTokenKey, int itemProviderIndex, CacheHint cacheHint) {
        this.cacheHintsByIngredient.put(ingredientTokenKey, cacheHint);
        this.cachedProviderIndexByIngredient.put(ingredientTokenKey.ingredient(), itemProviderIndex);
    }

    public void addListener(Consumer<KitchenOperation> listener) {
        this.listeners.add(listener);
    }

    public void notify(KitchenOperation operation) {
        for (Consumer<KitchenOperation> listener : this.listeners) {
            listener.accept(operation);
        }
    }
}

