/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.crafting;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.blay09.mods.cookingforblockheads.api.CacheHint;
import net.blay09.mods.cookingforblockheads.api.CookingForBlockheadsAPI;
import net.blay09.mods.cookingforblockheads.api.IngredientToken;
import net.blay09.mods.cookingforblockheads.api.KitchenItemProvider;
import net.blay09.mods.cookingforblockheads.api.KitchenRecipeHandler;
import net.blay09.mods.cookingforblockheads.crafting.CraftingContext;
import net.blay09.mods.cookingforblockheads.registry.CookingForBlockheadsRegistry;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_2371;
import net.minecraft.class_5455;
import net.minecraft.class_8786;
import org.jetbrains.annotations.Nullable;

public class CraftingOperation {
    private final CraftingContext context;
    private final class_8786<?> recipe;
    private final Multimap<IngredientTokenKey, IngredientToken> tokensByIngredient = ArrayListMultimap.create();
    private final List<IngredientToken> ingredientTokens = new ArrayList<IngredientToken>();
    private final List<class_1856> missingIngredients = new ArrayList<class_1856>();
    private class_2371<class_1799> lockedInputs;
    private int missingIngredientsMask;

    public CraftingOperation(CraftingContext context, class_8786<?> recipe) {
        this.context = context;
        this.recipe = recipe;
    }

    public CraftingOperation withLockedInputs(@Nullable class_2371<class_1799> lockedInputs) {
        this.lockedInputs = lockedInputs;
        return this;
    }

    public CraftingOperation prepare() {
        this.tokensByIngredient.clear();
        this.ingredientTokens.clear();
        this.missingIngredients.clear();
        this.missingIngredientsMask = 0;
        KitchenRecipeHandler recipeMapper = CookingForBlockheadsAPI.getKitchenRecipeHandler(this.recipe.comp_1933());
        List<Optional<class_1856>> ingredients = recipeMapper.getIngredients((class_1860)this.recipe);
        for (int i = 0; i < ingredients.size(); ++i) {
            class_1799 lockedInput;
            if (ingredients.get(i).isEmpty()) {
                this.ingredientTokens.add(IngredientToken.EMPTY);
                continue;
            }
            class_1856 ingredient = ingredients.get(i).get();
            IngredientToken ingredientToken = this.accountForIngredient(ingredient, lockedInput = this.lockedInputs != null ? (class_1799)this.lockedInputs.get(i) : class_1799.field_8037);
            if (ingredientToken != null) {
                if (ingredient.method_8105().count() <= 1L) continue;
                if (this.lockedInputs == null) {
                    this.lockedInputs = class_2371.method_10213((int)ingredients.size(), (Object)class_1799.field_8037);
                }
                this.lockedInputs.set(i, (Object)ingredientToken.peek());
                continue;
            }
            this.missingIngredients.add(ingredient);
            this.missingIngredientsMask |= 1 << i;
        }
        return this;
    }

    @Nullable
    private IngredientToken accountForIngredient(class_1856 ingredient, class_1799 lockedInput) {
        KitchenItemProvider itemProvider;
        IngredientToken ingredientToken;
        List<KitchenItemProvider> itemProviders = this.context.getItemProviders();
        int cachedProviderIndex = this.context.getCachedItemProviderIndexFor(ingredient);
        if (cachedProviderIndex != -1 && (ingredientToken = this.accountForIngredient(cachedProviderIndex, itemProvider = itemProviders.get(cachedProviderIndex), ingredient, lockedInput, true)) != null) {
            return ingredientToken;
        }
        for (int j = 0; j < itemProviders.size(); ++j) {
            KitchenItemProvider itemProvider2 = itemProviders.get(j);
            IngredientToken ingredientToken2 = this.accountForIngredient(j, itemProvider2, ingredient, lockedInput, false);
            if (ingredientToken2 == null) continue;
            return ingredientToken2;
        }
        return null;
    }

    @Nullable
    private IngredientToken accountForIngredient(int itemProviderIndex, KitchenItemProvider itemProvider, class_1856 ingredient, class_1799 lockedInput, boolean useCache) {
        CacheHint cacheHint;
        IngredientTokenKey ingredientTokenKey = new IngredientTokenKey(itemProviderIndex, ingredient);
        Collection scopedIngredientTokens = this.tokensByIngredient.get((Object)ingredientTokenKey);
        IngredientToken ingredientToken = this.findIngredient(itemProvider, ingredient, lockedInput, scopedIngredientTokens, cacheHint = useCache ? this.context.getCacheHintFor(ingredientTokenKey) : CacheHint.NONE);
        if (ingredientToken != null) {
            this.tokensByIngredient.put((Object)ingredientTokenKey, (Object)ingredientToken);
            this.context.cache(ingredientTokenKey, itemProviderIndex, itemProvider.getCacheHint(ingredientToken));
            this.ingredientTokens.add(ingredientToken);
            return ingredientToken;
        }
        return null;
    }

    @Nullable
    private IngredientToken findIngredient(KitchenItemProvider itemProvider, class_1856 ingredient, class_1799 lockedInput, Collection<IngredientToken> ingredientTokens, CacheHint cacheHint) {
        IngredientToken ingredientToken = lockedInput.method_7960() ? itemProvider.findIngredient(ingredient, ingredientTokens, cacheHint) : itemProvider.findIngredient(lockedInput, ingredientTokens, cacheHint);
        return ingredientToken;
    }

    public boolean canCraft() {
        return this.missingIngredients.isEmpty();
    }

    public class_1799 craft(class_1703 menu, class_5455 registryAccess) {
        return this.craft(menu, registryAccess, this.recipe);
    }

    private class_1799 craft(class_1703 menu, class_5455 registryAccess, class_8786<?> recipe) {
        Object recipeTypeHandler = CookingForBlockheadsRegistry.getKitchenRecipeHandler(recipe.comp_1933());
        if (recipeTypeHandler == null) {
            return class_1799.field_8037;
        }
        return recipeTypeHandler.assemble(this.context, recipe, this.ingredientTokens, registryAccess);
    }

    public class_2371<class_1799> getLockedInputs() {
        return this.lockedInputs;
    }

    public List<class_1856> getMissingIngredients() {
        return this.missingIngredients;
    }

    public int getMissingIngredientsMask() {
        return this.missingIngredientsMask;
    }

    public record IngredientTokenKey(int providerIndex, class_1856 ingredient) {
        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            IngredientTokenKey that = (IngredientTokenKey)o;
            return this.providerIndex == that.providerIndex && Objects.equals(this.ingredient, that.ingredient);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.providerIndex, this.ingredient);
        }
    }
}

