/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.crafting;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.cookingforblockheads.api.Kitchen;
import net.blay09.mods.cookingforblockheads.api.KitchenItemProcessor;
import net.blay09.mods.cookingforblockheads.api.KitchenItemProvider;
import net.blay09.mods.cookingforblockheads.block.entity.CookingTableBlockEntity;
import net.blay09.mods.cookingforblockheads.capability.ModCapabilities;
import net.blay09.mods.cookingforblockheads.crafting.CraftingOperation;
import net.blay09.mods.cookingforblockheads.item.ModItems;
import net.blay09.mods.cookingforblockheads.kitchen.ContainerKitchenItemProvider;
import net.blay09.mods.cookingforblockheads.tag.ModBlockTags;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3956;
import org.jetbrains.annotations.Nullable;

public class KitchenImpl
implements Kitchen {
    private final class_1799 activatingItemStack;
    private final class_2680 activatingBlockState;
    private final class_2586 activatingBlockEntity;
    private final Set<class_2338> checkedPos = new HashSet<class_2338>();
    private final List<KitchenItemProvider> itemProviderList = new ArrayList<KitchenItemProvider>();
    private final List<KitchenItemProcessor> itemProcessorList = new ArrayList<KitchenItemProcessor>();

    public KitchenImpl(class_1799 itemStack) {
        this.activatingItemStack = itemStack;
        this.activatingBlockState = class_2246.field_10124.method_9564();
        this.activatingBlockEntity = null;
    }

    public KitchenImpl(class_1937 level, class_2338 pos) {
        this.activatingBlockState = level.method_8320(pos);
        this.activatingItemStack = class_1799.field_8037;
        this.activatingBlockEntity = level.method_8321(pos);
        this.findNeighbourCraftingBlocks(level, pos, true);
    }

    private void findNeighbourCraftingBlocks(class_1937 level, class_2338 pos, boolean extendedUpSearch) {
        for (class_2350 direction : class_2350.values()) {
            int upSearch = extendedUpSearch && direction == class_2350.field_11036 ? 2 : 1;
            for (int n = 1; n <= upSearch; ++n) {
                class_2338 position = pos.method_10079(direction, n);
                if (this.checkedPos.contains(position)) continue;
                this.checkedPos.add(position);
                class_2680 state = level.method_8320(position);
                class_2586 blockEntity = level.method_8321(position);
                if (blockEntity != null) {
                    KitchenItemProcessor itemProcessor;
                    KitchenItemProvider itemProvider = (KitchenItemProvider)Balm.getCapabilities().getCapability(blockEntity, ModCapabilities.KITCHEN_ITEM_PROVIDER);
                    if (itemProvider != null) {
                        this.itemProviderList.add(itemProvider);
                    }
                    if ((itemProcessor = (KitchenItemProcessor)Balm.getCapabilities().getCapability(blockEntity, ModCapabilities.KITCHEN_ITEM_PROCESSOR)) != null) {
                        this.itemProcessorList.add(itemProcessor);
                    }
                    if (itemProvider == null && itemProcessor == null && !state.method_26164(ModBlockTags.KITCHEN_CONNECTORS)) continue;
                    this.findNeighbourCraftingBlocks(level, position, true);
                    continue;
                }
                if (!state.method_26164(ModBlockTags.KITCHEN_CONNECTORS)) continue;
                this.findNeighbourCraftingBlocks(level, position, false);
            }
        }
    }

    @Override
    public List<KitchenItemProvider> getItemProviders(@Nullable class_1657 player) {
        ArrayList<KitchenItemProvider> sourceInventories = new ArrayList<KitchenItemProvider>(this.itemProviderList);
        if (player != null) {
            sourceInventories.add(new ContainerKitchenItemProvider((class_1263)player.method_31548()));
        }
        return sourceInventories;
    }

    @Override
    public List<KitchenItemProcessor> getItemProcessors() {
        return this.itemProcessorList;
    }

    @Override
    public boolean canProcess(class_3956<?> recipeType) {
        if (recipeType == class_3956.field_17545) {
            return this.activatingBlockState.method_26164(ModBlockTags.COOKING_TABLES) || this.activatingItemStack.method_31574(ModItems.craftingBook);
        }
        return this.itemProcessorList.stream().anyMatch(it -> it.canProcess(recipeType));
    }

    public boolean isRecipeAvailable(CraftingOperation operation) {
        CookingTableBlockEntity cookingTable;
        class_2586 class_25862;
        boolean isNoFilter;
        boolean bl = isNoFilter = this.activatingItemStack.method_31574(ModItems.noFilterBook) || (class_25862 = this.activatingBlockEntity) instanceof CookingTableBlockEntity && (cookingTable = (CookingTableBlockEntity)class_25862).hasNoFilterBook();
        if (isNoFilter) {
            return true;
        }
        return operation.canCraft();
    }
}

