/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.kitchen;

import java.util.Collection;
import net.blay09.mods.balm.api.container.ContainerUtils;
import net.blay09.mods.cookingforblockheads.api.CacheHint;
import net.blay09.mods.cookingforblockheads.api.IngredientToken;
import net.blay09.mods.cookingforblockheads.api.KitchenItemProvider;
import net.minecraft.class_1263;
import net.minecraft.class_1799;
import net.minecraft.class_1856;

public class ContainerKitchenItemProvider
implements KitchenItemProvider {
    private final class_1263 container;

    public ContainerKitchenItemProvider(class_1263 container) {
        this.container = container;
    }

    @Override
    public IngredientToken findIngredient(class_1856 ingredient, Collection<IngredientToken> ingredientTokens, CacheHint cacheHint) {
        class_1799 slotStack;
        if (cacheHint instanceof ContainerIngredientToken) {
            ContainerIngredientToken containerIngredientToken = (ContainerIngredientToken)cacheHint;
            slotStack = this.container.method_5438(containerIngredientToken.slot);
            if (ingredient.method_8093(slotStack) && this.hasUsesLeft(containerIngredientToken.slot, slotStack, ingredientTokens)) {
                return containerIngredientToken;
            }
        }
        for (int i = 0; i < this.container.method_5439(); ++i) {
            slotStack = this.container.method_5438(i);
            if (!ingredient.method_8093(slotStack) || !this.hasUsesLeft(i, slotStack, ingredientTokens)) continue;
            return new ContainerIngredientToken(i);
        }
        return null;
    }

    @Override
    public IngredientToken findIngredient(class_1799 itemStack, Collection<IngredientToken> ingredientTokens, CacheHint cacheHint) {
        class_1799 slotStack;
        if (cacheHint instanceof ContainerIngredientToken) {
            ContainerIngredientToken containerIngredientToken = (ContainerIngredientToken)cacheHint;
            slotStack = this.container.method_5438(containerIngredientToken.slot);
            if (class_1799.method_31577((class_1799)slotStack, (class_1799)itemStack) && this.hasUsesLeft(containerIngredientToken.slot, slotStack, ingredientTokens)) {
                return containerIngredientToken;
            }
        }
        for (int i = 0; i < this.container.method_5439(); ++i) {
            slotStack = this.container.method_5438(i);
            if (!class_1799.method_31577((class_1799)slotStack, (class_1799)itemStack) || !this.hasUsesLeft(i, slotStack, ingredientTokens)) continue;
            return new ContainerIngredientToken(i);
        }
        return null;
    }

    protected int getUsesLeft(int slot, class_1799 slotStack, Collection<IngredientToken> ingredientTokens) {
        int usesLeft = slotStack.method_7947();
        for (IngredientToken ingredientToken : ingredientTokens) {
            if (!(ingredientToken instanceof ContainerIngredientToken)) continue;
            ContainerIngredientToken containerIngredientToken = (ContainerIngredientToken)ingredientToken;
            if (containerIngredientToken.slot != slot) continue;
            --usesLeft;
        }
        return usesLeft;
    }

    @Override
    public CacheHint getCacheHint(IngredientToken ingredientToken) {
        CacheHint cacheHint;
        if (ingredientToken instanceof ContainerIngredientToken) {
            ContainerIngredientToken containerIngredientToken = (ContainerIngredientToken)ingredientToken;
            cacheHint = containerIngredientToken;
        } else {
            cacheHint = CacheHint.NONE;
        }
        return cacheHint;
    }

    private boolean hasUsesLeft(int slot, class_1799 slotStack, Collection<IngredientToken> ingredientTokens) {
        return this.getUsesLeft(slot, slotStack, ingredientTokens) > 0;
    }

    public class ContainerIngredientToken
    implements IngredientToken,
    CacheHint {
        private final int slot;

        public ContainerIngredientToken(int slot) {
            this.slot = slot;
        }

        @Override
        public class_1799 peek() {
            return ContainerKitchenItemProvider.this.container.method_5438(this.slot);
        }

        @Override
        public class_1799 consume() {
            return ContainerUtils.extractItem((class_1263)ContainerKitchenItemProvider.this.container, (int)this.slot, (int)1, (boolean)false);
        }

        @Override
        public class_1799 restore(class_1799 itemStack) {
            class_1799 restItem = ContainerUtils.insertItem((class_1263)ContainerKitchenItemProvider.this.container, (int)this.slot, (class_1799)itemStack, (boolean)false);
            if (!restItem.method_7960()) {
                return ContainerUtils.insertItemStacked((class_1263)ContainerKitchenItemProvider.this.container, (class_1799)restItem, (boolean)false);
            }
            return class_1799.field_8037;
        }
    }
}

