/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.menu;

import com.google.common.collect.Multimap;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.container.DefaultContainer;
import net.blay09.mods.cookingforblockheads.CookingForBlockheads;
import net.blay09.mods.cookingforblockheads.api.CookingForBlockheadsAPI;
import net.blay09.mods.cookingforblockheads.api.Kitchen;
import net.blay09.mods.cookingforblockheads.api.KitchenRecipeGroup;
import net.blay09.mods.cookingforblockheads.api.KitchenRecipeHandler;
import net.blay09.mods.cookingforblockheads.crafting.CraftableWithStatus;
import net.blay09.mods.cookingforblockheads.crafting.CraftingContext;
import net.blay09.mods.cookingforblockheads.crafting.CraftingOperation;
import net.blay09.mods.cookingforblockheads.crafting.KitchenImpl;
import net.blay09.mods.cookingforblockheads.crafting.RecipeWithStatus;
import net.blay09.mods.cookingforblockheads.menu.comparator.ComparatorName;
import net.blay09.mods.cookingforblockheads.menu.comparator.FavoriteComparator;
import net.blay09.mods.cookingforblockheads.menu.slot.AbstractFakeSlot;
import net.blay09.mods.cookingforblockheads.menu.slot.CraftMatrixFakeSlot;
import net.blay09.mods.cookingforblockheads.menu.slot.CraftableListingFakeSlot;
import net.blay09.mods.cookingforblockheads.network.message.AvailableCraftablesListMessage;
import net.blay09.mods.cookingforblockheads.network.message.CraftRecipeMessage;
import net.blay09.mods.cookingforblockheads.network.message.KitchenFeedbackMessage;
import net.blay09.mods.cookingforblockheads.network.message.RequestAvailableCraftablesMessage;
import net.blay09.mods.cookingforblockheads.network.message.RequestSelectionRecipesMessage;
import net.blay09.mods.cookingforblockheads.network.message.SelectionRecipesListMessage;
import net.blay09.mods.cookingforblockheads.registry.CookingForBlockheadsRegistry;
import net.minecraft.class_10294;
import net.minecraft.class_10295;
import net.minecraft.class_10297;
import net.minecraft.class_10298;
import net.minecraft.class_10300;
import net.minecraft.class_10301;
import net.minecraft.class_10302;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1713;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1863;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3917;
import net.minecraft.class_7923;
import net.minecraft.class_8710;
import net.minecraft.class_8786;
import net.minecraft.class_9695;
import org.jetbrains.annotations.Nullable;

public class KitchenMenu
extends class_1703 {
    public final class_1657 player;
    private final KitchenImpl kitchen;
    private final List<CraftableListingFakeSlot> recipeListingSlots = new ArrayList<CraftableListingFakeSlot>();
    private final List<CraftMatrixFakeSlot> matrixSlots = new ArrayList<CraftMatrixFakeSlot>();
    private final class_2371<class_1799> lockedInputs = class_2371.method_10213((int)9, (Object)class_1799.field_8037);
    private final List<CraftableWithStatus> filteredCraftables = new ArrayList<CraftableWithStatus>();
    private final List<CraftableWithStatus> history = new ArrayList<CraftableWithStatus>();
    private String currentSearch;
    private Comparator<CraftableWithStatus> currentSorting = new FavoriteComparator(new ComparatorName());
    private List<CraftableWithStatus> craftables = new ArrayList<CraftableWithStatus>();
    private boolean craftablesDirty = true;
    private boolean recipesDirty = true;
    private boolean scrollOffsetDirty;
    private int scrollOffset;
    private CraftableWithStatus selectedCraftable;
    private List<RecipeWithStatus> recipesForSelection;
    private int recipesForSelectionIndex;

    public KitchenMenu(class_3917<KitchenMenu> containerType, int windowId, class_1657 player, KitchenImpl kitchen) {
        super(containerType, windowId);
        AbstractFakeSlot slot;
        int j;
        int i;
        this.player = player;
        this.kitchen = kitchen;
        DefaultContainer fakeInventory = new DefaultContainer(21);
        for (i = 0; i < 4; ++i) {
            for (j = 0; j < 3; ++j) {
                slot = new CraftableListingFakeSlot((class_1263)fakeInventory, j + i * 3, 102 + j * 18, 11 + i * 18);
                this.recipeListingSlots.add((CraftableListingFakeSlot)slot);
                this.method_7621(slot);
            }
        }
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 3; ++j) {
                slot = new CraftMatrixFakeSlot(this, (class_1263)fakeInventory, j + i * 3, 24 + j * 18, 20 + i * 18);
                this.matrixSlots.add((CraftMatrixFakeSlot)slot);
                this.method_7621(slot);
            }
        }
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 9; ++j) {
                this.method_7621(new class_1735((class_1263)player.method_31548(), j + i * 9 + 9, 8 + j * 18, 92 + i * 18){

                    public void method_7668() {
                        KitchenMenu.this.craftablesDirty = true;
                        KitchenMenu.this.recipesDirty = true;
                    }
                });
            }
        }
        for (i = 0; i < 9; ++i) {
            this.method_7621(new class_1735((class_1263)player.method_31548(), i, 8 + i * 18, 150){

                public void method_7668() {
                    KitchenMenu.this.craftablesDirty = true;
                    KitchenMenu.this.recipesDirty = true;
                }
            });
        }
    }

    public void method_7593(int slotNumber, int dragType, class_1713 clickType, class_1657 player) {
        class_1735 slot;
        boolean handled = false;
        if (slotNumber >= 0 && slotNumber < this.field_7761.size() && (slot = (class_1735)this.field_7761.get(slotNumber)) instanceof CraftableListingFakeSlot) {
            CraftableListingFakeSlot craftableSlot = (CraftableListingFakeSlot)slot;
            if (player.method_73183().method_8608()) {
                if (this.isSelectedSlot(craftableSlot)) {
                    if (clickType == class_1713.field_7790 || clickType == class_1713.field_7793 || clickType == class_1713.field_7794 || clickType == class_1713.field_7796) {
                        this.requestCraft(clickType == class_1713.field_7794, clickType == class_1713.field_7796);
                        handled = true;
                    }
                } else {
                    this.clearHistory();
                    this.selectCraftable(craftableSlot.getCraftable());
                    handled = true;
                }
            }
        }
        if (!handled) {
            super.method_7593(slotNumber, dragType, clickType, player);
        }
    }

    public void method_7623() {
        super.method_7623();
        if (this.craftablesDirty) {
            this.broadcastAvailableRecipes();
            this.craftablesDirty = false;
        }
        if (this.recipesDirty) {
            if (this.selectedCraftable != null) {
                this.broadcastRecipesForResultItem(this.selectedCraftable.itemStack());
            }
            this.recipesDirty = false;
        }
    }

    public boolean method_7597(class_1657 player) {
        return true;
    }

    public void method_7609(class_1263 inventory) {
    }

    public class_1799 method_7601(class_1657 player, int slotIndex) {
        class_1799 itemStack = class_1799.field_8037;
        class_1735 slot = (class_1735)this.field_7761.get(slotIndex);
        if (slot != null && slot.method_7681()) {
            class_1799 slotStack = slot.method_7677();
            itemStack = slotStack.method_7972();
            if (slotIndex >= 48 && slotIndex < 57 ? !this.method_7616(slotStack, 21, 48, true) : slotIndex >= 21 && slotIndex < 48 && !this.method_7616(slotStack, 48, 57, false)) {
                return class_1799.field_8037;
            }
            if (slotStack.method_7960()) {
                slot.method_7673(class_1799.field_8037);
            } else {
                slot.method_7668();
            }
        }
        return itemStack;
    }

    public void selectCraftable(@Nullable CraftableWithStatus recipe) {
        this.selectedCraftable = recipe;
        this.resetSelectedRecipe();
        this.updateCraftableSlots();
        if (recipe != null) {
            if (this.player.method_73183().method_8608()) {
                this.lockedInputs.clear();
                this.requestSelectionRecipes(recipe);
            }
        } else {
            this.resetSelectedRecipe();
            this.updateMatrixSlots();
        }
    }

    public void resetSelectedRecipe() {
        this.recipesForSelection = null;
        this.recipesForSelectionIndex = 0;
        this.updateMatrixSlots();
    }

    public void requestCraftables() {
        Balm.getNetworking().sendToServer((class_8710)new RequestAvailableCraftablesMessage());
    }

    public void handleRequestCraftables() {
        this.craftablesDirty = true;
    }

    public void requestSelectionRecipes(CraftableWithStatus craftable) {
        Balm.getNetworking().sendToServer((class_8710)new RequestSelectionRecipesMessage(craftable.itemStack(), (List<class_1799>)this.lockedInputs));
    }

    public void handleRequestSelectionRecipes(class_1799 resultItem, List<class_1799> lockedInputs) {
        this.selectedCraftable = this.findCraftableForResultItem(resultItem);
        this.lockedInputs.clear();
        for (int i = 0; i < lockedInputs.size(); ++i) {
            this.lockedInputs.set(i, (Object)lockedInputs.get(i));
        }
        this.recipesDirty = true;
    }

    private void requestCraft(boolean craftFullStack, boolean addToInventory) {
        RecipeWithStatus selectedRecipe = this.getSelectedRecipe();
        if (selectedRecipe != null) {
            Balm.getNetworking().sendToServer((class_8710)new CraftRecipeMessage(selectedRecipe.recipeDisplayEntry().comp_3262(), (List<class_1799>)this.lockedInputs, craftFullStack, addToInventory));
        }
    }

    public List<CraftableWithStatus> getAvailableCraftables() {
        HashMap<class_2960, CraftableWithStatus> result = new HashMap<class_2960, CraftableWithStatus>();
        CraftingContext context = new CraftingContext(this.kitchen, this.player);
        Multimap<class_2960, class_8786<?>> recipesByItemId = CookingForBlockheadsRegistry.getRecipesByItemId();
        for (class_2960 itemId : recipesByItemId.keySet()) {
            for (class_8786 recipeHolder : recipesByItemId.get((Object)itemId)) {
                CraftableWithStatus craftableWithStatus = this.craftableWithStatusFromRecipe(context, recipeHolder);
                if (craftableWithStatus == null) continue;
                result.compute(itemId, (k, v) -> CraftableWithStatus.best(v, craftableWithStatus));
            }
        }
        return result.values().stream().toList();
    }

    @Nullable
    private <C extends class_9695, T extends class_1860<C>> CraftableWithStatus craftableWithStatusFromRecipe(CraftingContext context, class_8786<?> recipeHolder) {
        class_1860 recipe = recipeHolder.comp_1933();
        KitchenRecipeHandler recipeHandler = CookingForBlockheadsAPI.getKitchenRecipeHandler(recipe);
        class_1799 resultItem = recipeHandler.predictResultItem((class_1860)recipeHolder);
        if (this.isGroupItem(resultItem)) {
            return null;
        }
        CraftingOperation operation = context.createOperation(recipeHolder).prepare();
        if (!this.kitchen.isRecipeAvailable(operation)) {
            return null;
        }
        List<class_1856> missingIngredients = operation.getMissingIngredients();
        List<class_1856> missingUtensils = operation.getMissingIngredients();
        return new CraftableWithStatus(resultItem, !missingIngredients.isEmpty(), !missingUtensils.isEmpty());
    }

    private boolean isGroupItem(class_1799 resultItem) {
        class_2960 itemId = class_7923.field_41178.method_10221((Object)resultItem.method_7909());
        for (KitchenRecipeGroup group : CookingForBlockheadsRegistry.getGroups()) {
            class_2960 groupItemId = class_7923.field_41178.method_10221((Object)group.getParentItem());
            if (groupItemId.equals((Object)itemId)) continue;
            for (class_1856 ingredient : group.getChildren()) {
                if (!ingredient.method_8093(resultItem)) continue;
                return true;
            }
        }
        return false;
    }

    private Collection<class_8786<?>> getRecipesFor(class_1799 resultItem) {
        ArrayList recipes = new ArrayList(CookingForBlockheadsRegistry.getRecipesFor(resultItem));
        recipes.addAll(CookingForBlockheadsRegistry.getRecipesInGroup(resultItem));
        return recipes;
    }

    public void broadcastAvailableRecipes() {
        this.craftables = this.getAvailableCraftables();
        Balm.getNetworking().sendTo(this.player, (class_8710)new AvailableCraftablesListMessage(this.craftables));
    }

    public void broadcastRecipesForResultItem(class_1799 resultItem) {
        ArrayList<RecipeWithStatus> result = new ArrayList<RecipeWithStatus>();
        class_1863 recipeManager = this.player.method_73183().method_8503().method_3772();
        CraftingContext context = new CraftingContext(this.kitchen, this.player);
        Collection<class_8786<?>> recipesForResult = this.getRecipesFor(resultItem);
        for (class_8786<?> recipe : recipesForResult) {
            CraftingOperation operation = context.createOperation(recipe).withLockedInputs(this.lockedInputs).prepare();
            recipeManager.method_64679(recipe.comp_1932(), recipeDisplayEntry -> result.add(new RecipeWithStatus((class_10297)recipeDisplayEntry, operation.getMissingIngredients(), operation.getMissingIngredientsMask(), (List<class_1799>)operation.getLockedInputs())));
        }
        this.recipesForSelection = result;
        Balm.getNetworking().sendTo(this.player, (class_8710)new SelectionRecipesListMessage(result));
    }

    public void craft(class_10298 recipeDisplayId, class_2371<class_1799> lockedInputs, boolean craftFullStack, boolean addToInventory) {
        class_1937 level = this.player.method_73183();
        class_1863.class_10288 serverDisplayInfo = level.method_8503().method_3772().method_64686(recipeDisplayId);
        if (serverDisplayInfo == null) {
            CookingForBlockheads.logger.error("Received invalid recipe from client: {}", (Object)recipeDisplayId);
            return;
        }
        class_8786 recipe = serverDisplayInfo.comp_3250();
        if (!this.kitchen.canProcess(recipe.comp_1933().method_17716())) {
            CookingForBlockheads.logger.error("Received invalid craft request, unprocessable recipe {}", (Object)recipeDisplayId);
            return;
        }
        CraftingContext context = new CraftingContext(this.kitchen, this.player);
        context.addListener(operation -> {
            Optional<class_2561> feedback = operation.getFeedback();
            feedback.ifPresent(component -> Balm.getNetworking().sendTo(this.player, (class_8710)new KitchenFeedbackMessage((class_2561)component)));
        });
        CraftingOperation operation2 = context.createOperation(recipe).withLockedInputs(lockedInputs);
        KitchenRecipeHandler recipeHandler = CookingForBlockheadsAPI.getKitchenRecipeHandler(recipe.comp_1933());
        class_1799 resultItem = recipeHandler.predictResultItem((class_1860)recipe);
        int repeats = craftFullStack ? resultItem.method_7914() / resultItem.method_7947() : 1;
        for (int i = 0; i < repeats; ++i) {
            class_1799 itemStack;
            operation2.prepare();
            if (!operation2.canCraft()) break;
            class_1799 carried = this.method_34255();
            if (!(carried.method_7960() || class_1799.method_31577((class_1799)carried, (class_1799)resultItem) && carried.method_7947() < carried.method_7914())) {
                if (!craftFullStack && !addToInventory) break;
                addToInventory = true;
            }
            if ((itemStack = operation2.craft(this, this.player.method_73183().method_30349())).method_7960()) break;
            if (addToInventory) {
                if (this.player.method_31548().method_7394(itemStack)) continue;
                this.player.method_7328(itemStack, false);
                continue;
            }
            if (carried.method_7960()) {
                this.method_34254(itemStack);
                continue;
            }
            if (class_1799.method_31577((class_1799)carried, (class_1799)itemStack) && carried.method_7947() < carried.method_7914()) {
                carried.method_7933(itemStack.method_7947());
                continue;
            }
            if (this.player.method_31548().method_7394(itemStack)) continue;
            this.player.method_7328(itemStack, false);
        }
        this.craftablesDirty = true;
        this.recipesDirty = true;
    }

    public void setCraftables(List<CraftableWithStatus> craftables) {
        int previousSelectionIndex = this.selectedCraftable != null ? this.filteredCraftables.indexOf(this.selectedCraftable) : -1;
        this.craftables = craftables;
        this.updateFilteredRecipes();
        if (previousSelectionIndex != -1) {
            Iterator<CraftableWithStatus> it = this.filteredCraftables.iterator();
            CraftableWithStatus found = null;
            while (it.hasNext()) {
                CraftableWithStatus recipe = it.next();
                if (!class_1799.method_31577((class_1799)recipe.itemStack(), (class_1799)this.selectedCraftable.itemStack())) continue;
                found = recipe;
                it.remove();
                break;
            }
            while (previousSelectionIndex > this.filteredCraftables.size()) {
                this.filteredCraftables.add(null);
            }
            this.filteredCraftables.add(previousSelectionIndex, found);
            this.selectedCraftable = found;
        }
        this.updateCraftableSlots();
        this.setScrollOffsetDirty(true);
    }

    public void updateCraftableSlots() {
        int i = this.scrollOffset * 3;
        for (CraftableListingFakeSlot slot : this.recipeListingSlots) {
            if (i < this.filteredCraftables.size()) {
                CraftableWithStatus craftable = this.filteredCraftables.get(i);
                slot.setCraftable(craftable);
                ++i;
                continue;
            }
            slot.setCraftable(null);
        }
    }

    private void updateMatrixSlots() {
        RecipeWithStatus selectedRecipe = this.getSelectedRecipe();
        if (selectedRecipe != null) {
            this.updateMatrixSlots(selectedRecipe);
        } else {
            for (int i = 0; i < this.matrixSlots.size(); ++i) {
                CraftMatrixFakeSlot matrixSlot = this.matrixSlots.get(i);
                matrixSlot.setIngredient(i, null, class_1799.field_8037);
                matrixSlot.setMissing(true);
            }
        }
    }

    private void updateMatrixSlots(RecipeWithStatus recipe) {
        class_10295 recipeDisplay = recipe.recipeDisplayEntry().comp_3263();
        class_2371 matrix = class_2371.method_10213((int)9, (Object)class_10302.class_10305.field_54681);
        boolean[] missingMatrix = new boolean[9];
        int[] ingredientIndexMatrix = new int[9];
        class_10295 class_102952 = recipeDisplay;
        Objects.requireNonNull(class_102952);
        class_10295 class_102953 = class_102952;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{class_10300.class, class_10301.class, class_10294.class}, (Object)class_102953, n)) {
            case 0: {
                class_10300 shapedCraftingRecipeDisplay = (class_10300)class_102953;
                List ingredients = shapedCraftingRecipeDisplay.comp_3270();
                int i = 0;
                while (i < ingredients.size()) {
                    class_10302 ingredient = (class_10302)ingredients.get(i);
                    int recipeWidth = shapedCraftingRecipeDisplay.comp_3268();
                    int origX = i % recipeWidth;
                    int origY = i / recipeWidth;
                    int offsetX = recipeWidth == 1 ? 1 : 0;
                    int matrixSlot = origY * 3 + origX + offsetX;
                    matrix.set(matrixSlot, (Object)ingredient);
                    missingMatrix[matrixSlot] = (recipe.missingIngredientsMask() & 1 << i) == 1 << i;
                    ingredientIndexMatrix[matrixSlot] = i++;
                }
                break;
            }
            case 1: {
                class_10301 shapelessCraftingRecipeDisplay = (class_10301)class_102953;
                List ingredients = shapelessCraftingRecipeDisplay.comp_3271();
                for (int i = 0; i < ingredients.size(); ++i) {
                    class_10302 ingredient = (class_10302)ingredients.get(i);
                    matrix.set(i, (Object)ingredient);
                    missingMatrix[i] = (recipe.missingIngredientsMask() & 1 << i) == 1 << i;
                    ingredientIndexMatrix[i] = i;
                }
                break;
            }
            case 2: {
                class_10294 furnaceRecipeDisplay = (class_10294)class_102953;
                class_10302 ingredient = furnaceRecipeDisplay.comp_3256();
                int matrixSlot = 4;
                matrix.set(4, (Object)ingredient);
                missingMatrix[4] = (recipe.missingIngredientsMask() & 1) == 1;
                ingredientIndexMatrix[4] = 0;
                break;
            }
        }
        for (int i = 0; i < this.matrixSlots.size(); ++i) {
            CraftMatrixFakeSlot matrixSlot = this.matrixSlots.get(i);
            List<class_1799> lockedInputs = recipe.lockedInputs();
            int ingredientIndex = ingredientIndexMatrix[i];
            class_1799 lockedInput = lockedInputs.get(ingredientIndex);
            matrixSlot.setIngredient(ingredientIndex, (class_10302)matrix.get(i), lockedInput);
            matrixSlot.setMissing(missingMatrix[i]);
        }
    }

    public void setSortComparator(Comparator<CraftableWithStatus> comparator) {
        this.currentSorting = new FavoriteComparator(comparator);
        this.filteredCraftables.removeIf(Objects::isNull);
        this.filteredCraftables.sort(this.currentSorting);
        this.updateCraftableSlots();
    }

    public int getItemListCount() {
        return this.filteredCraftables.size();
    }

    public void setScrollOffset(int scrollOffset) {
        this.scrollOffset = scrollOffset;
        this.updateCraftableSlots();
    }

    public void search(@Nullable String term) {
        this.currentSearch = term;
        this.updateFilteredRecipes();
        this.setScrollOffset(0);
    }

    private void updateFilteredRecipes() {
        this.filteredCraftables.clear();
        for (CraftableWithStatus craftable : this.craftables) {
            if (!this.searchMatches(craftable.itemStack())) continue;
            this.filteredCraftables.add(craftable);
        }
        this.filteredCraftables.sort(this.currentSorting);
    }

    private boolean searchMatches(class_1799 resultItem) {
        if (this.currentSearch == null || this.currentSearch.trim().isEmpty()) {
            return true;
        }
        String lowerCaseSearch = this.currentSearch.toLowerCase();
        if (resultItem.method_7954().getString().toLowerCase(Locale.ENGLISH).contains(lowerCaseSearch)) {
            return true;
        }
        List tooltips = resultItem.method_7950(class_1792.class_9635.field_51353, this.player, (class_1836)class_1836.class_1837.field_41070);
        for (class_2561 tooltip : tooltips) {
            if (!tooltip.getString().toLowerCase(Locale.ENGLISH).contains(lowerCaseSearch)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public RecipeWithStatus getSelectedRecipe() {
        return this.recipesForSelection != null ? this.recipesForSelection.get(this.recipesForSelectionIndex) : null;
    }

    public boolean isSelectedSlot(CraftableListingFakeSlot slot) {
        return this.selectedCraftable != null && slot.getCraftable() != null && class_1799.method_31577((class_1799)slot.getCraftable().itemStack(), (class_1799)this.selectedCraftable.itemStack());
    }

    public boolean isScrollOffsetDirty() {
        return this.scrollOffsetDirty;
    }

    public void setScrollOffsetDirty(boolean dirty) {
        this.scrollOffsetDirty = dirty;
    }

    public void setRecipesForSelection(List<RecipeWithStatus> recipes) {
        this.recipesForSelection = !recipes.isEmpty() ? recipes : null;
        this.recipesForSelectionIndex = this.recipesForSelection != null ? Math.max(0, Math.min(this.recipesForSelection.size() - 1, this.recipesForSelectionIndex)) : 0;
        this.updateMatrixSlots();
    }

    public void nextRecipe(int dir) {
        if (this.recipesForSelection != null) {
            this.recipesForSelectionIndex = Math.max(0, Math.min(this.recipesForSelection.size() - 1, this.recipesForSelectionIndex + dir));
            this.updateCraftableSlots();
        }
        this.updateMatrixSlots();
    }

    public boolean selectionHasRecipeVariants() {
        return this.recipesForSelection != null && this.recipesForSelection.size() > 1;
    }

    public boolean selectionHasPreviousRecipe() {
        return this.recipesForSelectionIndex > 0;
    }

    public boolean selectionHasNextRecipe() {
        return this.recipesForSelection != null && this.recipesForSelectionIndex < this.recipesForSelection.size() - 1;
    }

    public List<CraftMatrixFakeSlot> getMatrixSlots() {
        return this.matrixSlots;
    }

    @Nullable
    public CraftableWithStatus findCraftableForResultItem(class_1799 resultItem) {
        return this.craftables.stream().filter(it -> class_1799.method_31577((class_1799)it.itemStack(), (class_1799)resultItem)).findAny().orElse(null);
    }

    public Kitchen getKitchen() {
        return this.kitchen;
    }

    public void setLockedInput(int i, class_1799 lockedInput) {
        this.lockedInputs.set(i, (Object)lockedInput);
        if (this.selectedCraftable != null) {
            this.requestSelectionRecipes(this.selectedCraftable);
        }
    }

    public int getRecipesForSelectionIndex() {
        return this.filteredCraftables.indexOf(this.selectedCraftable);
    }

    public void clearHistory() {
        this.history.clear();
    }

    public void pushHistory() {
        if (this.selectedCraftable != null) {
            this.history.add(this.selectedCraftable);
        }
    }

    public void popHistory() {
        if (!this.history.isEmpty()) {
            CraftableWithStatus entry = this.history.removeLast();
            this.selectCraftable(entry);
        }
    }
}

