/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.registry;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.blay09.mods.balm.api.event.BalmEvents;
import net.blay09.mods.balm.api.event.server.ServerReloadFinishedEvent;
import net.blay09.mods.balm.api.event.server.ServerStartedEvent;
import net.blay09.mods.cookingforblockheads.CookingForBlockheadsConfig;
import net.blay09.mods.cookingforblockheads.api.ISortButton;
import net.blay09.mods.cookingforblockheads.api.KitchenRecipeGroup;
import net.blay09.mods.cookingforblockheads.api.KitchenRecipeHandler;
import net.blay09.mods.cookingforblockheads.mixin.RecipeManagerAccessor;
import net.blay09.mods.cookingforblockheads.tag.ModItemTags;
import net.minecraft.class_10289;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1863;
import net.minecraft.class_2960;
import net.minecraft.class_3956;
import net.minecraft.class_5455;
import net.minecraft.class_7923;
import net.minecraft.class_8786;
import net.minecraft.class_9334;
import net.minecraft.class_9695;

public class CookingForBlockheadsRegistry {
    private static final Multimap<class_2960, class_8786<?>> recipesByItemId = ArrayListMultimap.create();
    private static final Multimap<class_2960, class_8786<?>> recipesByGroup = ArrayListMultimap.create();
    private static final List<ISortButton> sortButtons = new ArrayList<ISortButton>();
    private static final Map<class_1799, Integer> ovenFuelItems = new HashMap<class_1799, Integer>();
    private static final Map<Class<? extends class_1860<?>>, KitchenRecipeHandler<?, ?>> kitchenRecipeHandlers = new HashMap();

    public static void initialize(BalmEvents events) {
        events.onEvent(ServerReloadFinishedEvent.class, event -> CookingForBlockheadsRegistry.reload(event.getServer().method_3772(), (class_5455)event.getServer().method_30611()));
        events.onEvent(ServerStartedEvent.class, event -> CookingForBlockheadsRegistry.reload(event.getServer().method_3772(), (class_5455)event.getServer().method_30611()));
    }

    private static void reload(class_1863 recipeManager, class_5455 registryAccess) {
        recipesByItemId.clear();
        CookingForBlockheadsRegistry.loadRecipesByType(recipeManager, registryAccess, class_3956.field_17545);
        CookingForBlockheadsRegistry.loadRecipesByType(recipeManager, registryAccess, class_3956.field_17546);
    }

    private static <C extends class_9695, T extends class_1860<C>> void loadRecipesByType(class_1863 recipeManager, class_5455 registryAccess, class_3956<T> recipeType) {
        class_10289 recipeMap = ((RecipeManagerAccessor)recipeManager).getRecipes();
        for (class_8786 recipeHolder : recipeMap.method_64698(recipeType)) {
            class_1799 resultItem;
            class_1860 recipe;
            Object recipeHandler;
            if (!CookingForBlockheadsRegistry.isEligibleRecipe(recipeHolder) || (recipeHandler = CookingForBlockheadsRegistry.getKitchenRecipeHandler(recipe = recipeHolder.comp_1933())) == null || !CookingForBlockheadsRegistry.isEligibleResultItem(resultItem = recipeHandler.predictResultItem((class_1860)recipe))) continue;
            class_2960 itemId = class_7923.field_41178.method_10221((Object)resultItem.method_7909());
            recipesByItemId.put((Object)itemId, (Object)recipeHolder);
            List<KitchenRecipeGroup> groups = CookingForBlockheadsRegistry.getGroups();
            block1: for (KitchenRecipeGroup group : groups) {
                for (class_1856 ingredient : group.getChildren()) {
                    if (!ingredient.method_8093(resultItem)) continue;
                    class_2960 groupItemId = class_7923.field_41178.method_10221((Object)group.getParentItem());
                    recipesByGroup.put((Object)groupItemId, (Object)recipeHolder);
                    continue block1;
                }
            }
        }
    }

    public static List<KitchenRecipeGroup> getGroups() {
        return List.of();
    }

    private static boolean isEligibleResultItem(class_1799 itemStack) {
        if (itemStack.method_31573(ModItemTags.EXCLUDED)) {
            return false;
        }
        return itemStack.method_57826(class_9334.field_50075) || itemStack.method_31573(ModItemTags.FOODS) || itemStack.method_31573(ModItemTags.INGREDIENTS);
    }

    private static <T extends class_9695> boolean isEligibleRecipe(class_8786<? extends class_1860<T>> recipe) {
        return !CookingForBlockheadsConfig.getActive().excludedRecipes.contains(recipe.comp_1932().method_29177());
    }

    public static <C extends class_9695, T extends class_1860<C>> void registerKitchenRecipeHandler(Class<T> recipeType, KitchenRecipeHandler<C, T> handler) {
        kitchenRecipeHandlers.put(recipeType, handler);
    }

    public static <C extends class_9695, T extends class_1860<C>, V extends KitchenRecipeHandler<C, T>> V getKitchenRecipeHandler(T recipe) {
        for (Class<class_1860<?>> handlerClass : kitchenRecipeHandlers.keySet()) {
            if (!handlerClass.isAssignableFrom(recipe.getClass())) continue;
            return (V)kitchenRecipeHandlers.get(handlerClass);
        }
        return (V)kitchenRecipeHandlers.get(recipe.getClass());
    }

    public static void addSortButton(ISortButton nameSortButton) {
        sortButtons.add(nameSortButton);
    }

    public static Collection<ISortButton> getSortButtons() {
        return sortButtons;
    }

    public static void addOvenFuel(class_1799 fuelItem, int fuelTime) {
        ovenFuelItems.put(fuelItem, fuelTime);
    }

    public static int getOvenFuelTime(class_1799 itemStack) {
        for (Map.Entry<class_1799, Integer> entry : ovenFuelItems.entrySet()) {
            if (!class_1799.method_7984((class_1799)entry.getKey(), (class_1799)itemStack)) continue;
            return entry.getValue();
        }
        return 0;
    }

    public static Collection<class_8786<?>> getRecipesFor(class_1799 resultItem) {
        class_2960 itemId = class_7923.field_41178.method_10221((Object)resultItem.method_7909());
        return recipesByItemId.get((Object)itemId);
    }

    public static Collection<? extends class_8786<?>> getRecipesInGroup(class_1799 resultItem) {
        class_2960 itemId = class_7923.field_41178.method_10221((Object)resultItem.method_7909());
        return recipesByGroup.get((Object)itemId);
    }

    public static Multimap<class_2960, class_8786<?>> getRecipesByItemId() {
        return recipesByItemId;
    }
}

