/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.block.entity;

import java.util.Optional;
import net.blay09.mods.balm.api.container.DefaultContainer;
import net.blay09.mods.balm.common.BalmBlockEntity;
import net.blay09.mods.cookingforblockheads.CookingForBlockheadsConfig;
import net.blay09.mods.cookingforblockheads.block.ModBlocks;
import net.blay09.mods.cookingforblockheads.block.ToasterBlock;
import net.blay09.mods.cookingforblockheads.block.entity.ModBlockEntities;
import net.blay09.mods.cookingforblockheads.component.ModComponents;
import net.blay09.mods.cookingforblockheads.recipe.ModRecipes;
import net.blay09.mods.cookingforblockheads.recipe.ToasterRecipe;
import net.blay09.mods.cookingforblockheads.sound.ModSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Unit;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;

public class ToasterBlockEntity
extends BalmBlockEntity {
    private static final int UPDATE_INTERVAL = 20;
    private static final int TOAST_TICKS = 1200;
    private final DefaultContainer container = new DefaultContainer(2){

        public void setChanged() {
            ToasterBlockEntity.this.setChanged();
            ToasterBlockEntity.this.sync();
        }
    };
    private boolean isDirty;
    private int ticksSinceUpdate;
    private boolean active;
    private int toastTicks;

    public ToasterBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.toaster.get(), pos, state);
    }

    public boolean triggerEvent(int id, int type) {
        if (id == 0) {
            this.level.playSound(null, this.worldPosition, (SoundEvent)ModSounds.toasterStart.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
            return true;
        }
        if (id == 1) {
            this.level.playSound(null, this.worldPosition, (SoundEvent)ModSounds.toasterStop.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
            return true;
        }
        if (id == 2) {
            BlockState state = this.level.getBlockState(this.worldPosition);
            this.level.sendBlockUpdated(this.worldPosition, state, state, 3);
            return true;
        }
        return super.triggerEvent(id, type);
    }

    public void loadAdditional(ValueInput input) {
        input.child("ItemHandler").ifPresent(it -> ContainerHelper.loadAllItems((ValueInput)it, (NonNullList)this.container.getItems()));
        this.active = input.getBooleanOr("Active", false);
        this.toastTicks = input.getIntOr("ToastTicks", 0);
    }

    public void saveAdditional(ValueOutput output) {
        ContainerHelper.saveAllItems((ValueOutput)output.child("ItemHandler"), (NonNullList)this.container.getItems());
        output.putBoolean("Active", this.active);
        output.putInt("ToastTicks", this.toastTicks);
    }

    public void writeUpdateTag(ValueOutput output) {
        this.saveAdditional(output);
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, ToasterBlockEntity blockEntity) {
        blockEntity.serverTick(level, pos, state);
    }

    public void serverTick(Level level, BlockPos pos, BlockState state) {
        if (this.active) {
            --this.toastTicks;
            if (this.toastTicks <= 0 && !level.isClientSide()) {
                for (int i = 0; i < this.container.getContainerSize(); ++i) {
                    ItemStack inputStack = this.container.getItem(i);
                    if (inputStack.isEmpty()) continue;
                    ItemStack outputStack = this.toastItem(inputStack);
                    ItemEntity itemEntity = new ItemEntity(level, (double)((float)this.worldPosition.getX() + 0.5f), (double)((float)this.worldPosition.getY() + 0.75f), (double)((float)this.worldPosition.getZ() + 0.5f), outputStack);
                    itemEntity.setDeltaMovement(0.0, (double)0.1f, 0.0);
                    level.addFreshEntity((Entity)itemEntity);
                    this.container.setItem(i, ItemStack.EMPTY);
                }
                this.setActive(false);
            }
            this.isDirty = true;
        }
        ++this.ticksSinceUpdate;
        if (this.isDirty && this.ticksSinceUpdate > 20) {
            this.sync();
            this.ticksSinceUpdate = 0;
            this.isDirty = false;
        }
    }

    public void setActive(boolean active) {
        this.active = active;
        if (active) {
            this.toastTicks = 1200;
            this.level.blockEvent(this.worldPosition, ModBlocks.toaster, 0, 0);
        } else {
            this.toastTicks = 0;
            this.level.blockEvent(this.worldPosition, ModBlocks.toaster, 1, 0);
        }
        this.level.blockEvent(this.worldPosition, ModBlocks.toaster, 2, 0);
        BlockState state = this.level.getBlockState(this.worldPosition);
        this.level.setBlockAndUpdate(this.worldPosition, (BlockState)state.setValue((Property)ToasterBlock.ACTIVE, (Comparable)Boolean.valueOf(active)));
        this.isDirty = true;
        this.setChanged();
    }

    public boolean isActive() {
        return this.active;
    }

    public float getToastProgress() {
        return 1.0f - (float)this.toastTicks / 1200.0f;
    }

    public Container getContainer() {
        return this.container;
    }

    public boolean isBurningToast() {
        boolean firstToasted = this.container.getItem(0).has((DataComponentType)ModComponents.toasted.get());
        boolean secondToasted = this.container.getItem(1).has((DataComponentType)ModComponents.toasted.get());
        return firstToasted || secondToasted;
    }

    private ItemStack toastItem(ItemStack itemStack) {
        SingleRecipeInput recipeInput = new SingleRecipeInput(itemStack);
        Optional toastRecipe = this.level.getServer().getRecipeManager().getRecipeFor(ModRecipes.toasterRecipeType, (RecipeInput)recipeInput, this.level);
        ItemStack outputItem = toastRecipe.map(recipeHolder -> ((ToasterRecipe)recipeHolder.value()).assemble(recipeInput, (HolderLookup.Provider)this.level.registryAccess())).orElse(itemStack);
        if (outputItem.is(Items.BREAD)) {
            return this.toastBread(outputItem);
        }
        return outputItem;
    }

    private ItemStack toastBread(ItemStack itemStack) {
        boolean alreadyToasted = itemStack.has((DataComponentType)ModComponents.toasted.get());
        if (alreadyToasted) {
            if (CookingForBlockheadsConfig.getActive().allowVeryToastedBread) {
                ItemStack veryToasted = new ItemStack((ItemLike)Items.CHARCOAL);
                veryToasted.set(DataComponents.CUSTOM_NAME, (Object)Component.translatable((String)"tooltip.cookingforblockheads.very_toasted"));
                return veryToasted;
            }
            return itemStack;
        }
        ItemStack toasted = itemStack.copy();
        toasted.set(DataComponents.CUSTOM_NAME, (Object)Component.translatable((String)"tooltip.cookingforblockheads.toasted", (Object[])new Object[]{itemStack.getHoverName()}));
        toasted.set((DataComponentType)ModComponents.toasted.get(), (Object)Unit.INSTANCE);
        return toasted;
    }

    public boolean canToast(ItemStack itemStack) {
        MinecraftServer server = this.level.getServer();
        if (server == null) {
            return false;
        }
        return server.getRecipeManager().getRecipeFor(ModRecipes.toasterRecipeType, (RecipeInput)new SingleRecipeInput(itemStack), this.level).map(it -> true).orElseGet(() -> itemStack.is(Items.BREAD));
    }
}

