/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.blay09.mods.cookingforblockheads.block.CounterBlock;
import net.blay09.mods.cookingforblockheads.block.entity.CounterBlockEntity;
import net.blay09.mods.cookingforblockheads.client.ModModels;
import net.blay09.mods.cookingforblockheads.client.render.RenderUtils;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.block.model.BlockStateModel;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.state.BlockEntityRenderState;
import net.minecraft.client.renderer.feature.ModelFeatureRenderer;
import net.minecraft.client.renderer.item.ItemModelResolver;
import net.minecraft.client.renderer.item.ItemStackRenderState;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionfc;

public class CounterRenderer<T extends CounterBlockEntity>
implements BlockEntityRenderer<T, CounterRenderState> {
    private static final float doorOriginX = 0.84375f;
    private static final float doorOriginZ = 0.09375f;
    private final ItemModelResolver itemModelResolver;

    protected float getDoorOriginX() {
        return 0.84375f;
    }

    protected float getDoorOriginZ() {
        return 0.09375f;
    }

    protected float getBottomShelfOffsetY() {
        return -0.85f;
    }

    protected float getTopShelfOffsetY() {
        return 0.35f;
    }

    protected BlockStateModel getDoorModel(@Nullable DyeColor blockColor, boolean isFlipped) {
        int colorIndex = blockColor != null ? blockColor.getId() + 1 : 0;
        return isFlipped ? (BlockStateModel)ModModels.counterDoorsFlipped.get(colorIndex).get() : (BlockStateModel)ModModels.counterDoors.get(colorIndex).get();
    }

    public CounterRenderer(BlockEntityRendererProvider.Context context) {
        this.itemModelResolver = context.itemModelResolver();
    }

    public CounterRenderState createRenderState() {
        return new CounterRenderState();
    }

    public void extractRenderState(T blockEntity, CounterRenderState renderState, float delta, Vec3 vec, @Nullable ModelFeatureRenderer.CrumblingOverlay crumblingOverlay) {
        DyeColor dyeColor;
        super.extractRenderState(blockEntity, (BlockEntityRenderState)renderState, delta, vec, crumblingOverlay);
        Block block = renderState.blockState.getBlock();
        if (block instanceof CounterBlock) {
            CounterBlock counterBlock = (CounterBlock)block;
            dyeColor = counterBlock.getColor();
        } else {
            dyeColor = null;
        }
        renderState.dye = dyeColor;
        renderState.doorAngle = ((CounterBlockEntity)blockEntity).getDoorAnimator().getRenderAngle(delta);
        renderState.flipped = ((CounterBlockEntity)blockEntity).isFlipped();
        int id = (int)blockEntity.getBlockPos().asLong();
        renderState.items = new ArrayList<ItemStackRenderState>();
        for (int i = 0; i < ((CounterBlockEntity)blockEntity).getContainer().getContainerSize(); ++i) {
            ItemStack itemStack = ((CounterBlockEntity)blockEntity).getContainer().getItem(i);
            ItemStackRenderState itemStackRenderState = new ItemStackRenderState();
            this.itemModelResolver.updateForTopItem(itemStackRenderState, itemStack, ItemDisplayContext.FIXED, blockEntity.getLevel(), null, id + i);
            renderState.items.add(itemStackRenderState);
        }
    }

    public void submit(CounterRenderState renderState, PoseStack poseStack, SubmitNodeCollector submitNodeCollector, CameraRenderState cameraRenderState) {
        poseStack.pushPose();
        float doorOriginX = this.getDoorOriginX();
        float doorOriginZ = this.getDoorOriginZ();
        float doorDirection = -1.0f;
        if (renderState.flipped) {
            doorOriginX = 1.0f - doorOriginX;
            doorDirection = 1.0f;
        }
        RenderUtils.applyBlockAngle(poseStack, renderState.blockState);
        poseStack.translate(-0.5f, 0.0f, -0.5f);
        poseStack.translate(doorOriginX, 0.0f, doorOriginZ);
        poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(doorDirection * (float)Math.toDegrees(renderState.doorAngle)));
        poseStack.translate(-doorOriginX, 0.0f, -doorOriginZ);
        BlockStateModel model = this.getDoorModel(renderState.dye, renderState.flipped);
        submitNodeCollector.submitBlockModel(poseStack, RenderType.entityCutout((ResourceLocation)TextureAtlas.LOCATION_BLOCKS), model, 0.0f, 0.0f, 0.0f, renderState.lightCoords, OverlayTexture.NO_OVERLAY, 0);
        poseStack.popPose();
        if (renderState.doorAngle > 0.0f) {
            poseStack.pushPose();
            poseStack.translate(0.0, 0.5, 0.0);
            RenderUtils.applyBlockAngle(poseStack, renderState.blockState);
            poseStack.scale(0.3f, 0.3f, 0.3f);
            int itemsPerShelf = renderState.items.size() / 2;
            int itemsPerRow = itemsPerShelf / 2;
            for (int i = renderState.items.size() - 1; i >= 0; --i) {
                ItemStackRenderState itemStackRenderState = renderState.items.get(i);
                if (itemStackRenderState.isEmpty()) continue;
                int shelfIndex = i % itemsPerShelf;
                int rowIndex = i % itemsPerRow;
                float spacing = 2.0f / (float)itemsPerRow;
                float offsetX = ((float)rowIndex - (float)itemsPerRow / 2.0f) * -spacing + (shelfIndex >= itemsPerRow ? -0.2f : 0.0f);
                float offsetY = i < itemsPerShelf ? this.getTopShelfOffsetY() : this.getBottomShelfOffsetY();
                float offsetZ = shelfIndex < itemsPerRow ? 0.5f : -0.5f;
                poseStack.pushPose();
                poseStack.translate(offsetX, offsetY, offsetZ);
                poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(45.0f));
                itemStackRenderState.submit(poseStack, submitNodeCollector, renderState.lightCoords, OverlayTexture.NO_OVERLAY, 0);
                poseStack.popPose();
            }
            poseStack.popPose();
        }
    }

    public static class CounterRenderState
    extends BlockEntityRenderState {
        public List<ItemStackRenderState> items = Collections.emptyList();
        @Nullable
        public DyeColor dye;
        public float doorAngle;
        public boolean flipped;
    }
}

