/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.client.render;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.Map;
import java.util.Optional;
import net.blay09.mods.cookingforblockheads.block.BaseKitchenBlock;
import net.blay09.mods.cookingforblockheads.block.entity.CowJarBlockEntity;
import net.blay09.mods.cookingforblockheads.client.ModModels;
import net.blay09.mods.cookingforblockheads.client.render.MilkJarRenderer;
import net.blay09.mods.cookingforblockheads.client.render.RenderUtils;
import net.minecraft.client.model.AdultAndBabyModelPair;
import net.minecraft.client.model.CowModel;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.block.model.BlockStateModel;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.ClientAsset;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.animal.CowVariant;
import net.minecraft.world.entity.animal.CowVariants;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.variant.ModelAndTexture;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionfc;

public class CowJarRenderer
extends MilkJarRenderer<CowJarBlockEntity> {
    private final Map<CowVariant.ModelType, AdultAndBabyModelPair<CowModel>> models;

    public CowJarRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
        this.models = CowJarRenderer.bakeModels(context);
    }

    private static Map<CowVariant.ModelType, AdultAndBabyModelPair<CowModel>> bakeModels(BlockEntityRendererProvider.Context context) {
        return Maps.newEnumMap(Map.of(CowVariant.ModelType.NORMAL, new AdultAndBabyModelPair((Model)new CowModel(context.bakeLayer(ModelLayers.COW)), (Model)new CowModel(context.bakeLayer(ModelLayers.COW_BABY))), CowVariant.ModelType.WARM, new AdultAndBabyModelPair((Model)new CowModel(context.bakeLayer(ModelLayers.WARM_COW)), (Model)new CowModel(context.bakeLayer(ModelLayers.WARM_COW_BABY))), CowVariant.ModelType.COLD, new AdultAndBabyModelPair((Model)new CowModel(context.bakeLayer(ModelLayers.COLD_COW)), (Model)new CowModel(context.bakeLayer(ModelLayers.COLD_COW_BABY)))));
    }

    @Override
    public MilkJarRenderer.MilkJarRenderState createRenderState() {
        return new CowJarRenderState();
    }

    private Optional<CowVariant> getDefaultCowVariant(@Nullable Level level) {
        if (level == null) {
            return Optional.empty();
        }
        return level.registryAccess().lookup(Registries.COW_VARIANT).flatMap(it -> it.getOptional(CowVariants.DEFAULT));
    }

    private boolean shouldCreepyStare(@Nullable Level level) {
        return level != null && level.getMoonPhase() == 0 && level.isDarkOutside();
    }

    private void headbang(@Nullable Level level, CowJarRenderState renderState, int bpm) {
        long gameTime = level != null ? level.getGameTime() : 0L;
        float headbangIntensity = 25.0f;
        float headbangSpeed = (float)bpm * (float)Math.PI / 600.0f;
        renderState.cow.xRot = (float)Math.sin((float)gameTime * headbangSpeed) * headbangIntensity;
        renderState.cow.yRot = (float)Math.cos((float)gameTime * headbangSpeed * 0.7f) * 10.0f;
    }

    private void creepyStare(Level level, BlockPos pos, BlockState state, float delta, CowJarRenderState renderState) {
        Player nearestPlayer = level.getNearestPlayer((double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 0.5f), (double)((float)pos.getZ() + 0.5f), 16.0, false);
        if (nearestPlayer != null) {
            float relativeYaw;
            Vec3 cowPos = new Vec3((double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 0.5f), (double)((float)pos.getZ() + 0.5f));
            Vec3 playerPos = nearestPlayer.getEyePosition(delta);
            Vec3 direction = playerPos.subtract(cowPos);
            float blockYaw = ((Direction)state.getValue(BaseKitchenBlock.FACING)).toYRot();
            double yaw = Math.atan2(-direction.x, direction.z);
            float yawDegrees = (float)Math.toDegrees(yaw);
            for (relativeYaw = yawDegrees - blockYaw; relativeYaw > 180.0f; relativeYaw -= 360.0f) {
            }
            while (relativeYaw < -180.0f) {
                relativeYaw += 360.0f;
            }
            renderState.cow.yRot = Mth.clamp((float)relativeYaw, (float)-90.0f, (float)90.0f);
            double horizontalDistance = Math.sqrt(direction.x * direction.x + direction.z * direction.z);
            double pitch = Math.atan2(-direction.y, horizontalDistance);
            float pitchDegrees = (float)Math.toDegrees(pitch);
            renderState.cow.xRot = Mth.clamp((float)pitchDegrees, (float)-60.0f, (float)60.0f);
        } else {
            renderState.cow.xRot = 0.0f;
            renderState.cow.yRot = 0.0f;
        }
    }

    private void theCowIsAlive(@Nullable Level level, BlockPos pos, BlockState state, float delta, CowJarRenderState renderState, CowJarBlockEntity blockEntity) {
        if (blockEntity.isPartying()) {
            this.headbang(level, renderState, 85);
            return;
        }
        if (this.shouldCreepyStare(level)) {
            this.creepyStare(level, pos, state, delta, renderState);
            return;
        }
        renderState.cow.xRot = 0.0f;
        renderState.cow.yRot = 0.0f;
    }

    @Override
    public void extractRenderState(CowJarBlockEntity blockEntity, MilkJarRenderer.MilkJarRenderState renderState, float delta, Vec3 vec, // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable ModelFeatureRenderer.CrumblingOverlay crumblingOverlay) {
        super.extractRenderState(blockEntity, renderState, delta, vec, crumblingOverlay);
        if (renderState instanceof CowJarRenderState) {
            CowJarRenderState cowJarRenderState = (CowJarRenderState)renderState;
            this.theCowIsAlive(blockEntity.getLevel(), blockEntity.getBlockPos(), blockEntity.getBlockState(), delta, cowJarRenderState, blockEntity);
            cowJarRenderState.variant = blockEntity.getVariant() != null ? (CowVariant)blockEntity.getVariant().value() : (CowVariant)this.getDefaultCowVariant(blockEntity.getLevel()).orElse(null);
        }
    }

    @Override
    public void submit(MilkJarRenderer.MilkJarRenderState renderState, PoseStack poseStack, SubmitNodeCollector submitNodeCollector, CameraRenderState cameraRenderState) {
        super.submit(renderState, poseStack, submitNodeCollector, cameraRenderState);
        if (renderState instanceof CowJarRenderState) {
            CowJarRenderState cowJarRenderState = (CowJarRenderState)renderState;
            if (cowJarRenderState.variant != null) {
                poseStack.pushPose();
                poseStack.translate(0.5f, 0.5f, 0.5f);
                poseStack.mulPose((Quaternionfc)Axis.ZP.rotationDegrees(180.0f));
                poseStack.translate(-0.5f, -0.5f, -0.5f);
                RenderUtils.applyBlockAngle(poseStack, renderState.blockState, 180.0f);
                poseStack.translate(0.0f, 0.675f, 0.0f);
                float scale = 0.2f;
                poseStack.scale(scale, scale, scale);
                ModelAndTexture modelAndTexture = cowJarRenderState.variant.modelAndTexture();
                CowModel model = (CowModel)this.models.get(modelAndTexture.model()).getModel(cowJarRenderState.cow.isBaby);
                ClientAsset.ResourceTexture textureAsset = modelAndTexture.asset();
                submitNodeCollector.submitModel((Model)model, (Object)cowJarRenderState.cow, poseStack, RenderType.entityCutout((ResourceLocation)textureAsset.texturePath()), renderState.lightCoords, OverlayTexture.NO_OVERLAY, 0, renderState.breakProgress);
                poseStack.popPose();
            }
        }
    }

    @Override
    protected BlockStateModel getLiquidModel() {
        return (BlockStateModel)ModModels.cowJarLiquid.get();
    }

    public static class CowJarRenderState
    extends MilkJarRenderer.MilkJarRenderState {
        public final LivingEntityRenderState cow = new LivingEntityRenderState();
        @Nullable
        public CowVariant variant;
    }
}

