/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.blay09.mods.cookingforblockheads.block.OvenBlock;
import net.blay09.mods.cookingforblockheads.block.entity.OvenBlockEntity;
import net.blay09.mods.cookingforblockheads.client.ModModels;
import net.blay09.mods.cookingforblockheads.client.render.RenderUtils;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.block.model.BlockStateModel;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.state.BlockEntityRenderState;
import net.minecraft.client.renderer.feature.ModelFeatureRenderer;
import net.minecraft.client.renderer.item.ItemModelResolver;
import net.minecraft.client.renderer.item.ItemStackRenderState;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionfc;

public class OvenRenderer
implements BlockEntityRenderer<OvenBlockEntity, OvenRenderState> {
    private final ItemModelResolver itemModelResolver;

    public OvenRenderer(BlockEntityRendererProvider.Context context) {
        this.itemModelResolver = context.itemModelResolver();
    }

    public OvenRenderState createRenderState() {
        return new OvenRenderState();
    }

    public void extractRenderState(OvenBlockEntity blockEntity, OvenRenderState renderState, float delta, Vec3 vec, @Nullable ModelFeatureRenderer.CrumblingOverlay crumblingOverlay) {
        DyeColor dyeColor;
        super.extractRenderState((BlockEntity)blockEntity, (BlockEntityRenderState)renderState, delta, vec, crumblingOverlay);
        this.itemModelResolver.updateForTopItem(renderState.firstTool, blockEntity.getToolItem(0), ItemDisplayContext.FIXED, blockEntity.getLevel(), null, 0);
        this.itemModelResolver.updateForTopItem(renderState.secondTool, blockEntity.getToolItem(1), ItemDisplayContext.FIXED, blockEntity.getLevel(), null, 0);
        this.itemModelResolver.updateForTopItem(renderState.thirdTool, blockEntity.getToolItem(2), ItemDisplayContext.FIXED, blockEntity.getLevel(), null, 0);
        this.itemModelResolver.updateForTopItem(renderState.fourthTool, blockEntity.getToolItem(3), ItemDisplayContext.FIXED, blockEntity.getLevel(), null, 0);
        renderState.doorAngle = blockEntity.getDoorAnimator().getRenderAngle(delta);
        Block block = blockEntity.getBlockState().getBlock();
        if (block instanceof OvenBlock) {
            OvenBlock oven = (OvenBlock)block;
            dyeColor = oven.getColor();
        } else {
            dyeColor = DyeColor.WHITE;
        }
        renderState.dye = dyeColor;
        renderState.active = blockEntity.isBurning();
        int id = (int)blockEntity.getBlockPos().asLong();
        renderState.items = new ArrayList<ItemStackRenderState>();
        for (int i = 0; i < 9; ++i) {
            ItemStack itemStack = blockEntity.getInternalContainer().getItem(7 + i);
            ItemStackRenderState itemStackRenderState = new ItemStackRenderState();
            this.itemModelResolver.updateForTopItem(itemStackRenderState, itemStack, ItemDisplayContext.FIXED, blockEntity.getLevel(), null, id + i);
            renderState.items.add(itemStackRenderState);
        }
    }

    public void submit(OvenRenderState renderState, PoseStack poseStack, SubmitNodeCollector submitNodeCollector, CameraRenderState cameraRenderState) {
        poseStack.pushPose();
        RenderUtils.applyBlockAngle(poseStack, renderState.blockState);
        poseStack.translate(-0.5f, 0.0f, -0.5f);
        poseStack.mulPose((Quaternionfc)Axis.XN.rotationDegrees((float)Math.toDegrees(renderState.doorAngle)));
        int colorIndex = renderState.dye.getId();
        BlockStateModel model = renderState.doorAngle < 0.3f && renderState.active ? (BlockStateModel)ModModels.ovenDoorsActive.get(colorIndex).get() : (BlockStateModel)ModModels.ovenDoors.get(colorIndex).get();
        submitNodeCollector.submitBlockModel(poseStack, RenderType.entityCutout((ResourceLocation)TextureAtlas.LOCATION_BLOCKS), model, 0.0f, 0.0f, 0.0f, renderState.lightCoords, OverlayTexture.NO_OVERLAY, 0);
        poseStack.translate(0.0f, 0.0f, -1.0f);
        BlockStateModel handleModel = (BlockStateModel)ModModels.ovenDoorHandles.get(colorIndex).get();
        submitNodeCollector.submitBlockModel(poseStack, RenderType.entityCutout((ResourceLocation)TextureAtlas.LOCATION_BLOCKS), handleModel, 0.0f, 0.0f, 0.0f, renderState.lightCoords, OverlayTexture.NO_OVERLAY, 0);
        poseStack.popPose();
        poseStack.pushPose();
        poseStack.translate(0.0, 1.05, 0.0);
        RenderUtils.applyBlockAngle(poseStack, renderState.blockState);
        poseStack.scale(0.4f, 0.4f, 0.4f);
        if (!renderState.firstTool.isEmpty()) {
            poseStack.pushPose();
            poseStack.translate(-0.55f, 0.0f, 0.5f);
            poseStack.mulPose((Quaternionfc)Axis.XP.rotationDegrees(45.0f));
            renderState.firstTool.submit(poseStack, submitNodeCollector, renderState.lightCoords, OverlayTexture.NO_OVERLAY, 0);
            poseStack.popPose();
        }
        if (!renderState.secondTool.isEmpty()) {
            poseStack.pushPose();
            poseStack.translate(0.55f, 0.0f, 0.5f);
            poseStack.mulPose((Quaternionfc)Axis.XP.rotationDegrees(45.0f));
            renderState.secondTool.submit(poseStack, submitNodeCollector, renderState.lightCoords, OverlayTexture.NO_OVERLAY, 0);
            poseStack.popPose();
        }
        if (!renderState.thirdTool.isEmpty()) {
            poseStack.pushPose();
            poseStack.translate(-0.55f, 0.0f, -0.5f);
            poseStack.mulPose((Quaternionfc)Axis.XP.rotationDegrees(45.0f));
            renderState.thirdTool.submit(poseStack, submitNodeCollector, renderState.lightCoords, OverlayTexture.NO_OVERLAY, 0);
            poseStack.popPose();
        }
        if (!renderState.fourthTool.isEmpty()) {
            poseStack.pushPose();
            poseStack.translate(0.55f, 0.0f, -0.5f);
            poseStack.mulPose((Quaternionfc)Axis.XP.rotationDegrees(45.0f));
            renderState.fourthTool.submit(poseStack, submitNodeCollector, renderState.lightCoords, OverlayTexture.NO_OVERLAY, 0);
            poseStack.popPose();
        }
        poseStack.popPose();
        if (renderState.doorAngle > 0.0f) {
            poseStack.pushPose();
            poseStack.translate(0.0, 0.4, 0.0);
            RenderUtils.applyBlockAngle(poseStack, renderState.blockState);
            poseStack.scale(0.3f, 0.3f, 0.3f);
            float offsetX = 0.825f;
            float offsetZ = 0.8f;
            for (int i = 0; i < renderState.items.size(); ++i) {
                ItemStackRenderState itemStackRenderState = renderState.items.get(i);
                if (!itemStackRenderState.isEmpty()) {
                    poseStack.pushPose();
                    poseStack.translate(offsetX, 0.0f, offsetZ);
                    poseStack.mulPose((Quaternionfc)Axis.XP.rotationDegrees(90.0f));
                    itemStackRenderState.submit(poseStack, submitNodeCollector, renderState.lightCoords, OverlayTexture.NO_OVERLAY, 0);
                    poseStack.popPose();
                }
                if (!((offsetX -= 0.8f) < -0.8f)) continue;
                offsetX = 0.825f;
                offsetZ -= 0.8f;
            }
            poseStack.popPose();
        }
    }

    public static class OvenRenderState
    extends BlockEntityRenderState {
        public final ItemStackRenderState firstTool = new ItemStackRenderState();
        public final ItemStackRenderState secondTool = new ItemStackRenderState();
        public final ItemStackRenderState thirdTool = new ItemStackRenderState();
        public final ItemStackRenderState fourthTool = new ItemStackRenderState();
        public List<ItemStackRenderState> items = Collections.emptyList();
        public float doorAngle;
        public DyeColor dye = DyeColor.WHITE;
        public boolean active;
    }
}

