/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import net.blay09.mods.cookingforblockheads.block.entity.SinkBlockEntity;
import net.blay09.mods.cookingforblockheads.client.ModModels;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.block.model.BlockStateModel;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.state.BlockEntityRenderState;
import net.minecraft.client.renderer.feature.ModelFeatureRenderer;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class SinkRenderer
implements BlockEntityRenderer<SinkBlockEntity, SinkRenderState> {
    public SinkRenderer(BlockEntityRendererProvider.Context context) {
    }

    public SinkRenderState createRenderState() {
        return new SinkRenderState();
    }

    public void extractRenderState(SinkBlockEntity blockEntity, SinkRenderState renderState, float delta, Vec3 vec, @Nullable ModelFeatureRenderer.CrumblingOverlay crumblingOverlay) {
        super.extractRenderState((BlockEntity)blockEntity, (BlockEntityRenderState)renderState, delta, vec, crumblingOverlay);
        renderState.fluidLevel = (float)blockEntity.getFluidTank().getAmount() / (float)blockEntity.getFluidTank().getCapacity();
        Level level = blockEntity.getLevel();
        renderState.waterColor = level != null ? ((Biome)level.getBiome(blockEntity.getBlockPos()).value()).getWaterColor() : -1;
    }

    public void submit(SinkRenderState renderState, PoseStack poseStack, SubmitNodeCollector submitNodeCollector, CameraRenderState cameraRenderState) {
        if (renderState.fluidLevel > 0.0f) {
            poseStack.pushPose();
            float filledPercentage = renderState.fluidLevel;
            poseStack.translate(0.0f, 0.5f - 0.5f * filledPercentage, 0.0f);
            poseStack.scale(1.0f, filledPercentage, 1.0f);
            BlockStateModel model = (BlockStateModel)ModModels.sinkLiquid.get();
            int color = renderState.waterColor;
            float red = (float)(color >> 16 & 0xFF) / 255.0f;
            float green = (float)(color >> 8 & 0xFF) / 255.0f;
            float blue = (float)(color & 0xFF) / 255.0f;
            submitNodeCollector.submitBlockModel(poseStack, RenderType.entitySolid((ResourceLocation)TextureAtlas.LOCATION_BLOCKS), model, red, green, blue, renderState.lightCoords, OverlayTexture.NO_OVERLAY, 0);
            poseStack.popPose();
        }
    }

    public static class SinkRenderState
    extends BlockEntityRenderState {
        public float fluidLevel;
        public int waterColor;
    }
}

