/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import net.blay09.mods.cookingforblockheads.block.entity.ToasterBlockEntity;
import net.blay09.mods.cookingforblockheads.client.render.RenderUtils;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.state.BlockEntityRenderState;
import net.minecraft.client.renderer.feature.ModelFeatureRenderer;
import net.minecraft.client.renderer.item.ItemModelResolver;
import net.minecraft.client.renderer.item.ItemStackRenderState;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class ToasterRenderer
implements BlockEntityRenderer<ToasterBlockEntity, ToasterRenderState> {
    private final ItemModelResolver itemModelResolver;

    public ToasterRenderer(BlockEntityRendererProvider.Context context) {
        this.itemModelResolver = context.itemModelResolver();
    }

    public ToasterRenderState createRenderState() {
        return new ToasterRenderState();
    }

    public void extractRenderState(ToasterBlockEntity blockEntity, ToasterRenderState renderState, float delta, Vec3 vec, @Nullable ModelFeatureRenderer.CrumblingOverlay crumblingOverlay) {
        super.extractRenderState((BlockEntity)blockEntity, (BlockEntityRenderState)renderState, delta, vec, crumblingOverlay);
        renderState.active = blockEntity.isActive();
        this.itemModelResolver.updateForTopItem(renderState.leftItem, blockEntity.getContainer().getItem(0), ItemDisplayContext.FIXED, blockEntity.getLevel(), null, 0);
        this.itemModelResolver.updateForTopItem(renderState.rightItem, blockEntity.getContainer().getItem(1), ItemDisplayContext.FIXED, blockEntity.getLevel(), null, 0);
    }

    public void submit(ToasterRenderState renderState, PoseStack poseStack, SubmitNodeCollector submitNodeCollector, CameraRenderState cameraRenderState) {
        if (!renderState.leftItem.isEmpty() || !renderState.rightItem.isEmpty()) {
            poseStack.pushPose();
            RenderUtils.applyBlockAngle(poseStack, renderState.blockState);
            poseStack.translate(0.0, 0.25 + (renderState.active ? -0.075 : 0.0), 0.0);
            float shrinkage = 0.3f;
            poseStack.scale(shrinkage, shrinkage, shrinkage);
            if (!renderState.leftItem.isEmpty()) {
                poseStack.pushPose();
                poseStack.translate(0.0f, 0.0f, 0.2f);
                renderState.leftItem.submit(poseStack, submitNodeCollector, renderState.lightCoords, OverlayTexture.NO_OVERLAY, 0);
                poseStack.popPose();
            }
            if (!renderState.rightItem.isEmpty()) {
                poseStack.pushPose();
                poseStack.translate(0.0f, 0.0f, -0.2f);
                renderState.rightItem.submit(poseStack, submitNodeCollector, renderState.lightCoords, OverlayTexture.NO_OVERLAY, 0);
                poseStack.popPose();
            }
            poseStack.popPose();
        }
    }

    public static class ToasterRenderState
    extends BlockEntityRenderState {
        public final ItemStackRenderState leftItem = new ItemStackRenderState();
        public final ItemStackRenderState rightItem = new ItemStackRenderState();
        public boolean active;
    }
}

