/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.crafting;

import java.util.ArrayList;
import java.util.List;
import net.blay09.mods.cookingforblockheads.tag.ModItemTags;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.display.RecipeDisplayEntry;
import org.jetbrains.annotations.Nullable;

public record RecipeWithStatus(RecipeDisplayEntry recipeDisplayEntry, List<Ingredient> missingIngredients, int missingIngredientsMask, List<ItemStack> lockedInputs) {
    public static final StreamCodec<RegistryFriendlyByteBuf, RecipeWithStatus> STREAM_CODEC = StreamCodec.composite((StreamCodec)RecipeDisplayEntry.STREAM_CODEC, RecipeWithStatus::recipeDisplayEntry, (StreamCodec)ByteBufCodecs.collection(ArrayList::new, (StreamCodec)Ingredient.CONTENTS_STREAM_CODEC), RecipeWithStatus::missingIngredients, (StreamCodec)ByteBufCodecs.INT, RecipeWithStatus::missingIngredientsMask, (StreamCodec)ItemStack.OPTIONAL_LIST_STREAM_CODEC, RecipeWithStatus::lockedInputs, RecipeWithStatus::new);
    public static final StreamCodec<RegistryFriendlyByteBuf, List<RecipeWithStatus>> LIST_STREAM_CODEC = STREAM_CODEC.apply(ByteBufCodecs.collection(ArrayList::new));

    public static RecipeWithStatus best(@Nullable RecipeWithStatus first, @Nullable RecipeWithStatus second) {
        if (first == null) {
            return second;
        }
        if (second == null) {
            return first;
        }
        if (first.missingIngredients.size() < second.missingIngredients.size()) {
            return first;
        }
        if (second.missingIngredients.size() < first.missingIngredients.size()) {
            return second;
        }
        return first;
    }

    public boolean canCraft() {
        return this.missingIngredients.isEmpty();
    }

    public boolean isMissingUtensils() {
        return this.missingIngredients.stream().anyMatch(RecipeWithStatus::isUtensil);
    }

    private static boolean isUtensil(Ingredient ingredient) {
        for (Holder utensilItem : BuiltInRegistries.ITEM.getTagOrEmpty(ModItemTags.UTENSILS)) {
            if (!ingredient.acceptsItem(utensilItem)) continue;
            return true;
        }
        return false;
    }
}

