/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.mixin;

import net.blay09.mods.cookingforblockheads.block.entity.CowJarBlockEntity;
import net.minecraft.client.renderer.LevelEventHandler;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LevelEventHandler.class})
public class LevelEventHandlerMixin {
    @Inject(method={"notifyNearbyEntities(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Z)V"}, at={@At(value="HEAD")})
    private void notifyNearbyEntities(Level level, BlockPos pos, boolean playing, CallbackInfo ci) {
        int radius = 3;
        BlockPos.MutableBlockPos mutablePos = pos.mutable();
        for (int x = -radius; x <= radius; ++x) {
            for (int y = -radius; y <= radius; ++y) {
                for (int z = -radius; z <= radius; ++z) {
                    mutablePos.setWithOffset((Vec3i)pos, x, y, z);
                    BlockEntity blockEntity = level.getBlockEntity((BlockPos)mutablePos);
                    if (!(blockEntity instanceof CowJarBlockEntity)) continue;
                    CowJarBlockEntity cowJar = (CowJarBlockEntity)blockEntity;
                    cowJar.setRecordPlayingNearby(pos, playing);
                }
            }
        }
    }
}

