/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.network.message;

import java.util.HashSet;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.cookingforblockheads.network.message.FavoriteListMessage;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public record ToggleFavoriteMessage(ResourceLocation itemId, boolean favorite) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<ToggleFavoriteMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"cookingforblockheads", (String)"toggle_favorite"));
    public static final StreamCodec<RegistryFriendlyByteBuf, ToggleFavoriteMessage> STREAM_CODEC = StreamCodec.composite((StreamCodec)ResourceLocation.STREAM_CODEC, ToggleFavoriteMessage::itemId, (StreamCodec)ByteBufCodecs.BOOL, ToggleFavoriteMessage::favorite, ToggleFavoriteMessage::new);

    public static void handle(ServerPlayer player, ToggleFavoriteMessage message) {
        CompoundTag data = Balm.getHooks().getPersistentData((Player)player);
        CompoundTag cfbData = data.getCompoundOrEmpty("CookingForBlockheads");
        CompoundTag favoriteItems = cfbData.getCompoundOrEmpty("FavoriteItemIds");
        if (message.favorite) {
            favoriteItems.putBoolean(message.itemId.toString(), true);
        } else {
            favoriteItems.remove(message.itemId.toString());
        }
        cfbData.put("FavoriteItemIds", (Tag)favoriteItems);
        data.put("CookingForBlockheads", (Tag)cfbData);
        HashSet<ResourceLocation> favoriteItemIds = new HashSet<ResourceLocation>();
        for (String favoriteItemId : favoriteItems.keySet()) {
            favoriteItemIds.add(ResourceLocation.parse((String)favoriteItemId));
        }
        Balm.getNetworking().sendTo((Player)player, (CustomPacketPayload)new FavoriteListMessage(favoriteItemIds));
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

